# µD3TN Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).


## [Unreleased]

### Deprecated

- AAPv1 will be removed in the future -- please use AAP 2.0


## [v0.14.5] - 2025-09-26

### Added

- Implement a tool to inject bundles via MTCP (`tools/cla/mtcp_send_bundle.py`)
- Enable the creation of BPv7 "Previous Node" extension blocks when the compile time option `BUNDLE7_TX_PRODUCE_PREVIOUS_NODE_BLOCK` is set to `1` (disabled by default).

### Changed

- Change the default administrative record type code for [BIBE](https://datatracker.ietf.org/doc/html/draft-ietf-dtn-bibect-05) to `64443` (as per the newest draft), and allow for changing it using the `BIBE_AR_TYPE_CODE` compile-time option. This replaces the `BIBE_CL_DRAFT_1_COMPATIBILITY` option, which was setting the type code to `7` to enable ION interoperability.


## [v0.14.4] - 2025-08-22

### Fixed

- Fix a crash in TCPCLv3 when an incoming connection replaces and stops a link task that is performing outgoing connection attempts (#256, !231)
- Fix an issue in the contact-based scheduling and forwarding (DFCF) logic dropping bundles received during a contact, which already had one link associated with it that terminated/dropped before the contact ended, and is now trying to reconnect (#258, !233)

### Changed

- All client-related headers for AAP 2.0 plus all Python libraries and tools are now available under the Apache 2.0 and BSD 3-clause licenses instead of AGPL v3. This ensures that there are no issues with commercial AAP 2.0 clients or derivatives.


## [v0.14.3] - 2025-07-25

### Security

- Fix possible DoS: Fix a NULL pointer dereference if a bundle's destination EID is a non-singleton EID (#255)

### Added

- Implement a new JSON-based contact configuration format and use it in the CLI tools (whereas the CLI tool parameters remain unchanged)
- Implement support for requesting and receiving status reports to AAP2 and the respective tools
- Add Protobuf APIs (AAP2, Storage Agent) to the web documentation
- Document Contact and Link configuration concepts, interfaces, and tools

### Changed

- Enhance the validation of incoming bundles, checking their BP conformance before further processing
- Perform basic EID validations also in the Python tooling to provide better error messages in case of issues
- Update dependencies


## [v0.14.2] - 2024-12-04

### Security

- Fix a potential double-free vulnerability (#233, may lead to DoS under Glibc)

### Added

- Update and significantly extend µD3TN's documentation, use mkDocs for rendering it and publish it on https://d3tn.gitlab.io/ud3tn/

### Changed

- Adapt the default TCP port for AAP 2.0 from 4242 to 4244 so it does not conflict with AAP


## [v0.14.1] - 2024-10-28

### Added

- Enable AAP 2.0 to use a TCP socket instead of only a POSIX IPC socket

### Fixed

- Fix a reachable assertion in the BPv7 parser (#227)


## [v0.14.0] - 2024-10-01 - "Nivium"

### Added

This release contains two major new features, which should be considered experimental:

1. A modular forwarding and routing interface leveraging AAP 2.0:
    - AAP 2.0 is extended to allow applications to a) control and monitor outgoing links and b) perform forwarding decisions.
    - A shared-secret authentication + authorization procedure is implemented — applications intending to perform privileged actions need to specify an "administrative secret" passed to µD3TN at launch through an environment variable.
    - Moreover, two Python implementations of forwarding algorithms (Bundle Dispatch Modules, BDMs) are provided: a "compatibility BDM" implementing the well-known µD3TN forwarding approach and a simple static BDM based on a JSON routing table, intended to be used as a template for developing further BDMs.
2. A persistent storage feature based on SQLite, implemented as a CLA that represents a "storage-only bundle node" conceptionally:
    - This makes persistent storage a "next hop" to which bundles can be sent based on the decision of the used forwarding algorithm.
    - Releasing and/or dropping bundles from storage is controlled through a Protobuf-based API provided by the storage system on a dedicated endpoint.
    - Authorization is ensured via a flag set through AAP 2.0 if the administrative secret has been specified.

Additionally, the following new features are contained in this release:

- Extended and new tooling for controlling µD3TN through AAP 2.0.
- Extend the provided Nix tooling and integration.
- Allow FIB entries to specify a "direct dispatch" flag that causes the BPA to not consult the BDM, but directly forward bundles if their destination matches.

### Changed

- License change: µD3TN as a whole is now provided unter the terms of the GNU AGPL. Some parts (e.g. the Python tools and some modules) will stay under the terms of the Apache 2 and BSD licenses.
- Graceful Termination of CLAs and the AAP 2.0 agent.
- Restructuring of the integrated next-hop forwarding approach so it is much more modular and can be fully disabled when using an external forwarding daemon (BDM).
- Move the Python tools to the `python-ud3tn-utils` package (links are provided in Git for backward-compatibility).
- Usability improvements for the AAP and AAP 2.0 interfaces.
- Reliability and consistency improvements as well as general cleanups, bug fixes, and documentation improvements.

### Deprecated

- The `aap_config.py` utility has been deprecated in favor of `aap2-config`, as it cannot set the flag required for secure operation. To continue using it, µD3TN needs to be launched with the `--allow-remote-config` commandline argument.


## [v0.13.0] - 2023-12-22 - "Maxwell"

### Added

- Preview version of AAP 2.0 - a new Protobuf-based application interface, with Python tooling equivalent to the AAP 1.0 tools provided in tools/aap2; see doc/aap20.md
- Added a "data decoder" that can be built using `make data-decoder` and allows for inspecting captured bundles and CLA packets as well as running fuzz testing on the parsers
- Support for local node IDs not containing a terminating slash (dtn scheme) or a service number (ipn scheme)
- Introduce configurable log levels - you can now select how verbose the output should be and debug log messages are disabled at compile time for more performant release builds
- Added a Nix Flake definition and a Nix-based development environment
- Automated testing on macOS and FreeBSD

### Changed

- Moved all compile-time configuration options to config.mk with examples and defaults documented in config.mk.example
- Improved rate limiting for outgoing CLA connections that now also works when operating over SSH tunnels
- Improved interoperability testing, including tests against HDTN and DTN7-rs
- Improved static analysis, including automated execution of cppcheck
- Pinning of Python dependencies to ensure a deterministic Python environment
- Several small bug fixes, more tests, and general improvements


## [v0.12.0] - 2023-05-23 - "Loki"

### Added

- macOS support
- FreeBSD support
- ARM and ARM-64 support with Clang and GCC compilers
- aap_echo and aap_ping utilities plus a built-in echo agent to realize basic reachability and latency tests
- transparent delivery of the bundle creation timestamp to applications via the AAP bundle identifier
- CBHE (RFC 6260) support for incoming BPv6 bundles

### Changed

- improved interoperability testing with ION 3.7 and 4.1 plus IONe and added documentation for it
- substantial improvements of the test toolchain, including a Docker image with all dependencies, static analysis, and support for sanitizers
- improved IPv6 support
- lots of further bug fixes and improvements, internal simplifications, and cleanups

### Removed

- removal of the unused STM32 target


## [v0.11.0] - 2022-03-08 - "Kerwan"

### Added

- Implement Bundle-in-Bundle Encapsulation convergence layer (in this initial version without custody transfer features)
- Add proper support for the `ipn:` EID scheme (BPv7 and BPv6 without CBHE)
- Enable contacts with "infinite" capacity (long-running, high-data-rate contacts where the capacity does not matter anymore are considered to allow for infinite bundles)
- Add a simple bundle forwarding stress test

### Changed

- Make the remote configuration capability a command line flag
- Update license: µD3TN is now additionally provided under the Apache 2.0 license

### Fixed

- Fix build of `libud3tn.so` shared library
- Fix EID validation being too permissive


## [v0.10.0] - 2021-09-24 - "Juliet"

### Added

- BPv7 compatibility:
    - Millisecond-based timestamps
    - Support of Bundle Age extension block
    - Drop previous node block (unsupported by µD3TN, but has to be removed according to standard)
- Add a Docker image
- Make it possible to use an RX read timeout for unreliable connections

### Changed

- Disallow remote configuration: Config bundles are only accepted via AAP
- Use working directory instead of `/tmp` for AAP socket by default
- Increase maximum number of fragments
- Bugfixes and documentation improvements (e.g., README, quick start guide)


## [v0.9.0] - 2020-11-19 - "Imbrium"

This is the initial public release of µD3TN.
This section documents the changes between µPCN v0.8.0 and this release.

### Changed

- GitLab publication and renaming to µD3TN
- Public Continuous Integration pipeline
- Separation of Python modules into packages pyD3TN and ud3tn-utils
- Minor bugfixes and documentation improvements


## [µPCN v0.8.0] - 2020-10-31 - "Himalayas"

### Added

- Support for BPv7 draft version 22
- ION interopability test for BPv7

### Changed

- Updated license information
- Updated command line parser
- Replaced TCP socket used for AAP by a UNIX domain socket
- Updated documentation


## [µPCN v0.7.0] - 2019-11-06 - "Galaxius"

### Added

- MTCP implementation according to https://tools.ietf.org/html/draft-ietf-dtn-mtcpcl-00
- CLA parameters plus parts of the µPCN configration can be provided as CLI parameters
- Added support for BPv7 draft version 17 (https://tools.ietf.org/html/draft-ietf-dtn-bpbis-17)
- IPv6 support for CLAs
- Support for a DTN application API based on an Application Agent Protocol (AAP)
- ION interopability test

### Changed

- Modified the overall architecture of the communication subsystem
- Major refactoring of build system
- New packet format of STM32 USB CLA made compatible with MTCP
- Replacement of integration tests by new pyupcn-based toolchain

### Removed

- Removed neighbor discovery approach


## [µPCN v0.6.0] - 2018-05-01 - "Falsaron"

In this release, an updated version of the Bundle Protocol version 7 draft specification (draft version 10) is available. Furthermore, the transmission and receive subsystem has been restructured to support various convergence layers.

### Added

- Integration of the TCPCL convergence layer
- Support for the Space Packet Protocol (SPP)

### Changed

- Update of the BP-bis implementation to RFC draft version 10 (https://tools.ietf.org/html/draft-ietf-dtn-bpbis-10)
- Partial project restructuring
- Various bugfixes


## [µPCN v0.5.0] - 2017-05-20 - "Elysium"

The main goal of this release was to include support for the Bundle protocol version 7 draft specification for testing and evaluation purposes.

### Added

- Implementation of the BP-bis draft specification defined by https://tools.ietf.org/html/draft-ietf-dtn-bpbis-06
- Support for FreeRTOS 9

### Changed

- Fixing various bugs after running fuzzing tests


## [µPCN v0.4.0] - 2016-12-02 - "Denali"

The main goal of this release was to port µPCN to the POSIX interface.

### Added

- Add POSIX support

### Changed

- Restructured µPCN to make it work against a generic, platform independent interface
- Improved Bundle serialization / throughput
- Extended test tools
- Several bug fixes


## [µPCN v0.3.1] - 2016-09-16

### Fixed

- The serializer erroneously emits the data body length field before the eid fields. This was a violation of the block RFC 5050 block layout.


## [µPCN v0.3.0] - 2016-06-24 - "Caloris"

The main goal of this release was to integrate a contact prediction approach.

### Added

- Integrated new version of the Ring Road Neighbor Discovery (RRND)
- Implemented enhanced contact prediction approach based on RRND and SGP4
- Provided static code analysis (make clang-check)

### Changed

- Restructured GroundStationTask - one Task cares for several ground stations
- Extended test tools
- Several bug fixes plus performance improvements


## [µPCN v0.2.0] - 2015-11-15 - "Boösaule"

This release focused on stabilizing the initial release.

### Added

- Added trust handling to the ContactManager
- Extended test infrastructure (e.g. Denial-of-Service test is available)
- Implemented zero-copy-approach by using a pointer lookup table for often used data (e.g. EIDs)
- Increased configurability of µPCN
- Improved error handling

### Changed

- Bugfixing, restructuring and cleanup


## [µPCN v0.1.0] - 2015-03-29 - "Aeolis"

This was the initial release of µPCN.

### Added

- RFC 5050 conformant bundle protocol version 6 implementation
- Two-stage routing approach with decision optimization between contacts
- DTN IP Neighbor Discovery (IPND draft 02) with extensions for RX/TX bitrate,
  AX.25 CLA address and cookie to protect against DoS attacks
- Unit test suite and integrated debugging tools (mem management, logging, CPU)
- Test setup for running pre-defined test scenarios with TCP server


[Unreleased]: https://gitlab.com/d3tn/ud3tn/-/compare/v0.14.5...HEAD
[v0.14.5]: https://gitlab.com/d3tn/ud3tn/-/compare/v0.14.4...v0.14.5
[v0.14.4]: https://gitlab.com/d3tn/ud3tn/-/compare/v0.14.3...v0.14.4
[v0.14.3]: https://gitlab.com/d3tn/ud3tn/-/compare/v0.14.2...v0.14.3
[v0.14.2]: https://gitlab.com/d3tn/ud3tn/-/compare/v0.14.1...v0.14.2
[v0.14.1]: https://gitlab.com/d3tn/ud3tn/-/compare/v0.14.0...v0.14.1
[v0.14.0]: https://gitlab.com/d3tn/ud3tn/-/compare/v0.13.0...v0.14.0
[v0.13.0]: https://gitlab.com/d3tn/ud3tn/-/compare/v0.12.0...v0.13.0
[v0.12.0]: https://gitlab.com/d3tn/ud3tn/-/compare/v0.11.0...v0.12.0
[v0.11.0]: https://gitlab.com/d3tn/ud3tn/-/compare/v0.10.0...v0.11.0
[v0.10.0]: https://gitlab.com/d3tn/ud3tn/-/compare/v0.9.0...v0.10.0
[v0.9.0]: https://gitlab.com/d3tn/ud3tn/-/compare/0ce4bee9...v0.9.0
[µPCN v0.8.0]: https://upcn.eu/releases/upcn-0.8.0.tar.gz
[µPCN v0.7.0]: https://upcn.eu/releases/upcn-0.7.0.tar.gz
[µPCN v0.6.0]: https://upcn.eu/releases/upcn-0.6.0.tar.gz
[µPCN v0.5.0]: https://upcn.eu/releases/upcn-0.5.0.tar.gz
[µPCN v0.4.0]: https://upcn.eu/releases/upcn-0.4.0.tar.gz
[µPCN v0.3.1]: https://upcn.eu/releases/upcn-0.3.1.tar.gz
[µPCN v0.3.0]: https://upcn.eu/releases/upcn-0.3.0.tar.gz
[µPCN v0.2.0]: https://upcn.eu/releases/upcn-0.2.0.tar.gz
[µPCN v0.1.0]: https://upcn.eu/releases/upcn-0.1.0.tar.gz
