// SPDX-License-Identifier: BSD-3-Clause OR Apache-2.0
#include "bundle7/eid.h"
#include "bundle7/previousnode.h"

#include "ud3tn/bundle.h"
#include "ud3tn/common.h"
#include "ud3tn/eid.h"

#include "cbor.h"

#include <stdlib.h>

struct bundle_block_list *bundle7_previous_node_create_entry(const char *local_node_id)
{
	struct bundle_block *const prev_node = bundle_block_create(
		BUNDLE_BLOCK_TYPE_PREVIOUS_NODE
	);

	if (!prev_node)
		return NULL;

	struct bundle_block_list *const bbl_entry = bundle_block_entry_create(prev_node);
	const size_t eid_len = bundle7_eid_get_max_serialized_size(local_node_id);

	if (!bbl_entry || eid_len == 0) {
		bundle_block_free(prev_node);
		return NULL;
	}

	void *const block_payload = malloc(eid_len);

	if (!block_payload) {
		bundle_block_entry_free(bbl_entry);
		return NULL;
	}

	prev_node->data = block_payload;

	const size_t serialized_len = bundle7_previous_node_serialize(
		local_node_id,
		block_payload,
		eid_len
	);

	if (!serialized_len) {
		bundle_block_entry_free(bbl_entry);
		return NULL;
	}
	prev_node->length = serialized_len;

	return bbl_entry;
}

size_t bundle7_previous_node_serialize(const char *previous_node, uint8_t *buffer, size_t length)
{
	ASSERT(validate_eid(previous_node) == UD3TN_OK);

	const int len = bundle7_eid_serialize(previous_node, buffer, length);

	if (len < 0)
		return 0;
	return (size_t)len;
}
