# Link and Contact Configuration

µD3TN comes with easy-to-use interfaces and command line utilities for configuring its connections to other reachable DTN nodes.

## Difference between Link and Contact

There are two concepts built into the µD3TN daemon, *Links* and *Contacts*:

- **Links**: The core of µD3TN itself is only aware of its *current connectivity*, which is represented as *Links* to other nodes. In this regard, a Link is *an active, unidirectional channel via a specific CLA to send bundles to another DTN node*.
- **Contacts**: On the contrary, a *Contact* is *a current or future (scheduled) time interval during which µD3TN has the opportunity to establish a Link to another DTN node*. It is basically an entry in an internal schedule that instructs µD3TN to attempt to establish and afterwards tear down a Link to a specific node.

!!! tip

    For persistent connections, configure static Links. For scheduled connection intervals, use Contacts.

## CLA Addresses

For establishing an outgoing Link on its own, µD3TN requires a CLA address.
These addresses have the format `<cla-kind>:<address>`, whereas:

- `<cla-kind>` defines the CLA to be used, e.g., `tcpclv3`, `mtcp`, or `tcpspp`, and
- `<address>` is CLA-specific. For TCP-based CLAs, this will be a hostname (or IP address) plus a port number, separated by a colon.

**Examples:**

- `tcpclv3:127.0.0.1:4556`
- `tcpclv3:[::1]:4556` (IPv6)
- `mtcp:dtn-node1.d3tn.net:13370` (using a hostname)

## Configuring Links

Links are configured through an AAP 2.0 interface that can be accessed via the `aap2-configure-link` utility.

**Invocation:** `aap2-configure-link [options] NODE_ID CLA_ADDR`

**Mandatory arguments:**

- `NODE_ID`: the node identifier of the DTN node assumed to be reachable via the provided CLA address. If the CLA address is already known or a Link exists already, this node will be added to the set of reachable nodes.
- `CLA_ADDR`: the CLA address to connect to, using the format specified above.

**Important optional arguments:**

- `--socket` OR `--tcp HOST PORT`: the AAP 2.0 socket configured for the µD3TN instance, either a UNIX domain or TCP socket.
- `--secret`, `--secret-var`: if you specified an administrative shared secret for µD3TN (mandatory in release builds), provide it through one of these arguments (`--secret-var` is the name of an environment variable containing the secret).
- `-d,--delete`: do not *create*, but *delete* the specified entry. If it is the last node pointing to the given CLA address and a Link exists to it, the Link will be torn down.
- `-i,--indirect`: do not assume that bundles destined for this node can directly be forwarded using this link, but request a routing decision from the used [BDM](../architecture-overview.md#generic-bundle-forwarding-interface-gbfi) (only relevant for very specific use cases).

## Configuring Contacts

Contacts are configured with the integrated contact-based scheduler (see [details on the configuration format](../contacts_data_format.md)), for which the `aap2-config` utility provides a command line interface.

**Invocation:** `aap2-config [options] NODE_ID CLA_ADDR`

**Mandatory arguments:**

- `NODE_ID`: the node identifier of the next-hop DTN node for the given Contacts.
- `CLA_ADDR`: the CLA address to connect to during the given Contacts, using the format specified above.

**Important optional arguments:**

- `--socket` OR `--tcp HOST PORT`: the AAP 2.0 socket configured for the µD3TN instance, either a UNIX domain or TCP socket.
- `--secret`, `--secret-var`: if you specified an administrative shared secret for µD3TN (mandatory in release builds), provide it through one of these arguments (`--secret-var` is the name of an environment variable containing the secret).
- `-r,--reaches NODE_ID`: specify another node transitively reachable via the configured node.
- `-s,--schedule START_OFFSET DURATION DATA_RATE`: schedule a Contact starting in `START_OFFSET` seconds, being available for `DURATION` seconds, with a minimum average data rate of `DATA_RATE` bytes per second.
- `-d, --delete`: delete the given configuration, or the whole node in case no scheduled contacts and transitively-reachable nodes are specified.
- `--dest_eid NODE_ID`: send the configuration bundle to another DTN node (specified via its node identifier `NODE_ID`) rather than to the one directly connected via AAP. Requires that the other µD3TN instance has been started with `--allow-remote-config`.
