/* Automatically generated nanopb header */
/* Generated by nanopb-0.4.8 */

#ifndef PB_AGENTS_STORAGE_STORAGE_AGENT_PB_H_INCLUDED
#define PB_AGENTS_STORAGE_STORAGE_AGENT_PB_H_INCLUDED
#include <pb.h>

#if PB_PROTO_HEADER_VERSION != 40
#error Regenerate this file with the current version of nanopb generator.
#endif

/* Enum definitions */
typedef enum _StorageOperation {
    /* Invalid. */
    StorageOperation_STORAGE_OPERATION_UNSPECIFIED = 0,
    /* List all bundles matching the given filter. */
    StorageOperation_STORAGE_OPERATION_LIST_BUNDLES = 1,
    /* Delete all bundles matching the given filter. */
    StorageOperation_STORAGE_OPERATION_DELETE_BUNDLES = 2,
    /* Push all bundles matching the given filter to the BPA ("receive" them). */
    StorageOperation_STORAGE_OPERATION_PUSH_BUNDLES = 3
} StorageOperation;

/* Struct definitions */
typedef struct _CompoundBundleId {
    char *source_eid;
    uint64_t creation_timestamp;
    uint64_t sequence_number;
    uint64_t fragment_offset;
    uint64_t payload_length;
} CompoundBundleId;

typedef struct _BundleMetadataFilter {
    /* An EID pattern to match a set of bundles. May contain '*' as a placeholder (similar to POSIX-style glob patterns). */
    char *eid_glob;
} BundleMetadataFilter;

typedef struct _StorageCall {
    StorageOperation operation;
    pb_size_t which_bundle_filter;
    union {
        CompoundBundleId id;
        /* string uuid = 3; */
        BundleMetadataFilter metadata;
    } bundle_filter;
} StorageCall;


#ifdef __cplusplus
extern "C" {
#endif

/* Helper constants for enums */
#define _StorageOperation_MIN StorageOperation_STORAGE_OPERATION_UNSPECIFIED
#define _StorageOperation_MAX StorageOperation_STORAGE_OPERATION_PUSH_BUNDLES
#define _StorageOperation_ARRAYSIZE ((StorageOperation)(StorageOperation_STORAGE_OPERATION_PUSH_BUNDLES+1))



#define StorageCall_operation_ENUMTYPE StorageOperation


/* Initializer values for message structs */
#define CompoundBundleId_init_default            {NULL, 0, 0, 0, 0}
#define BundleMetadataFilter_init_default        {NULL}
#define StorageCall_init_default                 {_StorageOperation_MIN, 0, {CompoundBundleId_init_default}}
#define CompoundBundleId_init_zero               {NULL, 0, 0, 0, 0}
#define BundleMetadataFilter_init_zero           {NULL}
#define StorageCall_init_zero                    {_StorageOperation_MIN, 0, {CompoundBundleId_init_zero}}

/* Field tags (for use in manual encoding/decoding) */
#define CompoundBundleId_source_eid_tag          1
#define CompoundBundleId_creation_timestamp_tag  3
#define CompoundBundleId_sequence_number_tag     4
#define CompoundBundleId_fragment_offset_tag     5
#define CompoundBundleId_payload_length_tag      6
#define BundleMetadataFilter_eid_glob_tag        1
#define StorageCall_operation_tag                1
#define StorageCall_id_tag                       2
#define StorageCall_metadata_tag                 4

/* Struct field encoding specification for nanopb */
#define CompoundBundleId_FIELDLIST(X, a) \
X(a, POINTER,  SINGULAR, STRING,   source_eid,        1) \
X(a, STATIC,   SINGULAR, UINT64,   creation_timestamp,   3) \
X(a, STATIC,   SINGULAR, UINT64,   sequence_number,   4) \
X(a, STATIC,   SINGULAR, UINT64,   fragment_offset,   5) \
X(a, STATIC,   SINGULAR, UINT64,   payload_length,    6)
#define CompoundBundleId_CALLBACK NULL
#define CompoundBundleId_DEFAULT NULL

#define BundleMetadataFilter_FIELDLIST(X, a) \
X(a, POINTER,  OPTIONAL, STRING,   eid_glob,          1)
#define BundleMetadataFilter_CALLBACK NULL
#define BundleMetadataFilter_DEFAULT NULL

#define StorageCall_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UENUM,    operation,         1) \
X(a, STATIC,   ONEOF,    MESSAGE,  (bundle_filter,id,bundle_filter.id),   2) \
X(a, STATIC,   ONEOF,    MESSAGE,  (bundle_filter,metadata,bundle_filter.metadata),   4)
#define StorageCall_CALLBACK NULL
#define StorageCall_DEFAULT NULL
#define StorageCall_bundle_filter_id_MSGTYPE CompoundBundleId
#define StorageCall_bundle_filter_metadata_MSGTYPE BundleMetadataFilter

extern const pb_msgdesc_t CompoundBundleId_msg;
extern const pb_msgdesc_t BundleMetadataFilter_msg;
extern const pb_msgdesc_t StorageCall_msg;

/* Defines for backwards compatibility with code written before nanopb-0.4.0 */
#define CompoundBundleId_fields &CompoundBundleId_msg
#define BundleMetadataFilter_fields &BundleMetadataFilter_msg
#define StorageCall_fields &StorageCall_msg

/* Maximum encoded size of messages (where known) */
/* CompoundBundleId_size depends on runtime parameters */
/* BundleMetadataFilter_size depends on runtime parameters */
/* StorageCall_size depends on runtime parameters */

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
