// SPDX-License-Identifier: BSD-3-Clause OR Apache-2.0
#ifndef BUNDLE7_PREVIOUSNODE_H_INCLUDED
#define BUNDLE7_PREVIOUSNODE_H_INCLUDED

#include <stddef.h>
#include <stdint.h>

#ifndef BUNDLE7_TX_PRODUCE_PREVIOUS_NODE_BLOCK
#define BUNDLE7_TX_PRODUCE_PREVIOUS_NODE_BLOCK 0
#endif // BUNDLE7_TX_PRODUCE_PREVIOUS_NODE_BLOCK

/**
 * Creates a bundle_block_list entry including a new previous node block that specifies the
 * provided local node identifier as "previous hop".
 *
 * @param local_node_id The node identifier to be specified in the new "previous node" block.
 *                      Must be a valid node ID.
 * @return A bundle_block_list entry, or NULL on error.
 */
struct bundle_block_list *bundle7_previous_node_create_entry(const char *local_node_id);

/**
 * Generates the CBOR-encoded version of a Previous Node block and writes it
 * into the passed buffer. The buffer must be at least strlen(previous_node) + 1 + 4 bytes long.
 *
 * @param previous_node The node ID to be written to the Previous Node block. Must be valid node ID.
 * @param buffer Output buffer
 * @param length Buffer length
 * @return Number of bytes written into buffer, zero on error
 */
size_t bundle7_previous_node_serialize(const char *previous_node, uint8_t *buffer, size_t length);

#endif // BUNDLE7_PREVIOUSNODE_H_INCLUDED
