// SPDX-License-Identifier: BSD-3-Clause OR Apache-2.0
#include "aap/aap.h"
#include "aap/aap_serializer.h"

#include "bundle7/reports.h"

#include "ud3tn/common.h"
#include "ud3tn/report_manager.h"

#include "testud3tn_unity.h"

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>

static const uint8_t valid_bpdu[] = {
	0x82, 0x19, 0xFB, 0xBB, 0x83, 0x00, 0x00, 0x58, 0x5A, 0x9F, 0x89, 0x07,
	0x00, 0x01, 0x82, 0x01, 0x77, 0x2F, 0x2F, 0x75, 0x70, 0x70,
	0x65, 0x72, 0x32, 0x2E, 0x64, 0x74, 0x6E, 0x2F, 0x62, 0x75,
	0x6E, 0x64, 0x6C, 0x65, 0x73, 0x69, 0x6E, 0x6B, 0x82, 0x01,
	0x6C, 0x2F, 0x2F, 0x73, 0x65, 0x6E, 0x64, 0x65, 0x72, 0x2E,
	0x64, 0x74, 0x6E, 0x82, 0x01, 0x00, 0x81, 0x1B, 0x00, 0x00,
	0x00, 0xA1, 0x34, 0x8A, 0xA2, 0x0B, 0x00, 0x1A, 0x05, 0x26,
	0x5C, 0x00, 0x42, 0xEE, 0xEB, 0x86, 0x01, 0x01, 0x00, 0x02,
	0x4A, 0x48, 0x61, 0x6C, 0x6C, 0x6F, 0x20, 0x57, 0x65, 0x6C,
	0x74, 0x44, 0x39, 0x50, 0xA7, 0x07, 0xFF
};

// Missing retransmission time
static const uint8_t bpdu_two_elem[] = {
	0x82, 0x19, 0xFB, 0xBB, 0x83, 0x00, 0x58, 0x5A, 0x9F, 0x89, 0x07, 0x00,
	0x01, 0x82, 0x01, 0x77, 0x2F, 0x2F, 0x75, 0x70, 0x70, 0x65,
	0x72, 0x32, 0x2E, 0x64, 0x74, 0x6E, 0x2F, 0x62, 0x75, 0x6E,
	0x64, 0x6C, 0x65, 0x73, 0x69, 0x6E, 0x6B, 0x82, 0x01, 0x6C,
	0x2F, 0x2F, 0x73, 0x65, 0x6E, 0x64, 0x65, 0x72, 0x2E, 0x64,
	0x74, 0x6E, 0x82, 0x01, 0x00, 0x81, 0x1B, 0x00, 0x00, 0x00,
	0xA1, 0x34, 0x8A, 0xA2, 0x0B, 0x00, 0x1A, 0x05, 0x26, 0x5C,
	0x00, 0x42, 0xEE, 0xEB, 0x86, 0x01, 0x01, 0x00, 0x02, 0x4A,
	0x48, 0x61, 0x6C, 0x6C, 0x6F, 0x20, 0x57, 0x65, 0x6C, 0x74,
	0x44, 0x39, 0x50, 0xA7, 0x07, 0xFF
};

// Added element
static const uint8_t bpdu_four_elem[] = {
	0x82, 0x19, 0xFB, 0xBB, 0x83, 0x00, 0x00, 0x00, 0x58, 0x5A, 0x9F, 0x89,
	0x07, 0x00, 0x01, 0x82, 0x01, 0x77, 0x2F, 0x2F, 0x75, 0x70,
	0x70, 0x65, 0x72, 0x32, 0x2E, 0x64, 0x74, 0x6E, 0x2F, 0x62,
	0x75, 0x6E, 0x64, 0x6C, 0x65, 0x73, 0x69, 0x6E, 0x6B, 0x82,
	0x01, 0x6C, 0x2F, 0x2F, 0x73, 0x65, 0x6E, 0x64, 0x65, 0x72,
	0x2E, 0x64, 0x74, 0x6E, 0x82, 0x01, 0x00, 0x81, 0x1B, 0x00,
	0x00, 0x00, 0xA1, 0x34, 0x8A, 0xA2, 0x0B, 0x00, 0x1A, 0x05,
	0x26, 0x5C, 0x00, 0x42, 0xEE, 0xEB, 0x86, 0x01, 0x01, 0x00,
	0x02, 0x4A, 0x48, 0x61, 0x6C, 0x6C, 0x6F, 0x20, 0x57, 0x65,
	0x6C, 0x74, 0x44, 0x39, 0x50, 0xA7, 0x07, 0xFF
};

static const uint8_t bpdu_wrong_type[] = {
	0x82, 0x19, 0xFB, 0xBB, 0x83, 0x00, 0x58, 0x01, 0x62, 0x58, 0x5A, 0x9F,
	0x89, 0x07, 0x00, 0x01, 0x82, 0x01, 0x77, 0x2F, 0x2F, 0x75,
	0x70, 0x70, 0x65, 0x72, 0x32, 0x2E, 0x64, 0x74, 0x6E, 0x2F,
	0x62, 0x75, 0x6E, 0x64, 0x6C, 0x65, 0x73, 0x69, 0x6E, 0x6B,
	0x82, 0x01, 0x6C, 0x2F, 0x2F, 0x73, 0x65, 0x6E, 0x64, 0x65,
	0x72, 0x2E, 0x64, 0x74, 0x6E, 0x82, 0x01, 0x00, 0x81, 0x1B,
	0x00, 0x00, 0x00, 0xA1, 0x34, 0x8A, 0xA2, 0x0B, 0x00, 0x1A,
	0x05, 0x26, 0x5C, 0x00, 0x42, 0xEE, 0xEB, 0x86, 0x01, 0x01,
	0x00, 0x02, 0x4A, 0x48, 0x61, 0x6C, 0x6C, 0x6F, 0x20, 0x57,
	0x65, 0x6C, 0x74, 0x44, 0x39, 0x50, 0xA7, 0x07, 0xFF
};

TEST_GROUP(bibe_validation);

TEST_SETUP(bibe_validation)
{
}

TEST_TEAR_DOWN(bibe_validation)
{
}

TEST(bibe_validation, validate_bpdu)
{
	struct bundle_administrative_record *record;

	record = parse_administrative_record(
		7,
		valid_bpdu,
		sizeof(valid_bpdu)
	);

	TEST_ASSERT_NOT_NULL(record);
	free(record);
}

TEST(bibe_validation, validate_short_bpdu)
{
	struct bundle_administrative_record *record;

	record = parse_administrative_record(
		7,
		bpdu_two_elem,
		sizeof(bpdu_two_elem)
	);

	TEST_ASSERT_NULL(record);
}

TEST(bibe_validation, validate_long_bpdu)
{
	struct bundle_administrative_record *record;

	record = parse_administrative_record(
		7,
		bpdu_four_elem,
		sizeof(bpdu_four_elem)
	);

	TEST_ASSERT_NULL(record);
}

TEST(bibe_validation, validate_malformed_bpdu)
{
	struct bundle_administrative_record *record;

	record = parse_administrative_record(
		7,
		bpdu_wrong_type,
		sizeof(bpdu_wrong_type)
	);

	TEST_ASSERT_NULL(record);
}

TEST_GROUP_RUNNER(bibe_validation)
{
	RUN_TEST_CASE(bibe_validation, validate_bpdu);
	RUN_TEST_CASE(bibe_validation, validate_short_bpdu);
	RUN_TEST_CASE(bibe_validation, validate_long_bpdu);
	RUN_TEST_CASE(bibe_validation, validate_malformed_bpdu);
}
