macro(EXEC_CHECK CMD)
    message(" === ${CMD} ${ARGN}")
    execute_process(COMMAND ${CMAKE_COMMAND} -E env PYTHONPATH=${cnkalman_root_source_dir} ${CMD} ${ARGN} RESULT_VARIABLE CMD_RESULT)
    if(CMD_RESULT)
        message(FATAL_ERROR "Error running ${CMD} ${ARGN}")
    endif()
endmacro()
exec_check(${TEST_KALMAN_MODELS})
message(${CMAKE_CURRENT_BINARY_DIR}/BikeLandmarks.kf)
exec_check(python3 ${BENCHMARK_SCRIPT} ${CMAKE_CURRENT_BINARY_DIR}/BikeLandmarks.kf)
exec_check(python3 ${BENCHMARK_SCRIPT} ${CMAKE_CURRENT_BINARY_DIR}/LinearToy.kf)
exec_check(python3 ${BENCHMARK_SCRIPT} ${CMAKE_CURRENT_BINARY_DIR}/EggLandscape.kf)
exec_check(python3 ${BENCHMARK_SCRIPT} ${CMAKE_CURRENT_BINARY_DIR}/BearingsOnlyTracking.kf)
exec_check(python3 ${BENCHMARK_SCRIPT} ${CMAKE_CURRENT_BINARY_DIR}/BearingsOnlyTracking.small-iteration.kf)