#pragma once
#include "common.h"
// clang-format off
static inline void gen_imu_rot_f(FLT* out, const FLT time, const FLT* imu_rot) {
	const GEN_FLT obj_qw = imu_rot[0];
	const GEN_FLT obj_qi = imu_rot[1];
	const GEN_FLT obj_qj = imu_rot[2];
	const GEN_FLT obj_qk = imu_rot[3];
	const GEN_FLT aa_x = imu_rot[4];
	const GEN_FLT aa_y = imu_rot[5];
	const GEN_FLT aa_z = imu_rot[6];
	const GEN_FLT x0 = time * time;
	const GEN_FLT x1 = x0 * (aa_z * aa_z);
	const GEN_FLT x2 = x0 * (aa_x * aa_x);
	const GEN_FLT x3 = x0 * (aa_y * aa_y);
	const GEN_FLT x4 = 1e-10 + x3 + x1 + x2;
	const GEN_FLT x5 = sqrt(x4);
	const GEN_FLT x6 = 0.5 * x5;
	const GEN_FLT x7 = sin(x6);
	const GEN_FLT x8 = (1. / x4) * (x7 * x7);
	const GEN_FLT x9 = cos(x6);
	const GEN_FLT x10 = 1. / sqrt(1e-11 + (x2 * x8) + (x9 * x9) + (x1 * x8) + (x3 * x8));
	const GEN_FLT x11 = (1. / x5) * x7 * x10 * time;
	const GEN_FLT x12 = x11 * obj_qj;
	const GEN_FLT x13 = x9 * x10;
	const GEN_FLT x14 = x11 * aa_z;
	const GEN_FLT x15 = x11 * aa_x;
	const GEN_FLT x16 = x11 * aa_y;
	out[0] = (-1 * x12 * aa_y) + (-1 * x15 * obj_qi) + (-1 * x14 * obj_qk) + (x13 * obj_qw);
	out[1] = (x15 * obj_qw) + (x13 * obj_qi) + (-1 * x12 * aa_z) + (x16 * obj_qk);
	out[2] = (-1 * x15 * obj_qk) + (x16 * obj_qw) + (x14 * obj_qi) + (x13 * obj_qj);
	out[3] = (x12 * aa_x) + (x13 * obj_qk) + (x14 * obj_qw) + (-1 * x16 * obj_qi);
	out[4] = aa_x;
	out[5] = aa_y;
	out[6] = aa_z;
}

// Jacobian of imu_rot_f wrt [time]
static inline void gen_imu_rot_f_jac_time(FLT* out, const FLT time, const FLT* imu_rot) {
	const GEN_FLT obj_qw = imu_rot[0];
	const GEN_FLT obj_qi = imu_rot[1];
	const GEN_FLT obj_qj = imu_rot[2];
	const GEN_FLT obj_qk = imu_rot[3];
	const GEN_FLT aa_x = imu_rot[4];
	const GEN_FLT aa_y = imu_rot[5];
	const GEN_FLT aa_z = imu_rot[6];
	const GEN_FLT x0 = time * time;
	const GEN_FLT x1 = aa_z * aa_z;
	const GEN_FLT x2 = x0 * x1;
	const GEN_FLT x3 = aa_x * aa_x;
	const GEN_FLT x4 = x0 * x3;
	const GEN_FLT x5 = aa_y * aa_y;
	const GEN_FLT x6 = x0 * x5;
	const GEN_FLT x7 = 1e-10 + x6 + x2 + x4;
	const GEN_FLT x8 = 1. / x7;
	const GEN_FLT x9 = sqrt(x7);
	const GEN_FLT x10 = 0.5 * x9;
	const GEN_FLT x11 = sin(x10);
	const GEN_FLT x12 = x11 * x11;
	const GEN_FLT x13 = x8 * x12;
	const GEN_FLT x14 = cos(x10);
	const GEN_FLT x15 = 1e-11 + (x4 * x13) + (x14 * x14) + (x2 * x13) + (x6 * x13);
	const GEN_FLT x16 = 1. / sqrt(x15);
	const GEN_FLT x17 = time * obj_qi;
	const GEN_FLT x18 = x17 * x16;
	const GEN_FLT x19 = x18 * aa_x;
	const GEN_FLT x20 = 2 * time;
	const GEN_FLT x21 = x5 * x20;
	const GEN_FLT x22 = x1 * x20;
	const GEN_FLT x23 = x3 * x20;
	const GEN_FLT x24 = x23 + x21 + x22;
	const GEN_FLT x25 = (1. / (x7 * sqrt(x7))) * x11;
	const GEN_FLT x26 = x24 * x25;
	const GEN_FLT x27 = x24 * x14;
	const GEN_FLT x28 = x8 * x27;
	const GEN_FLT x29 = 0.25 * x28;
	const GEN_FLT x30 = 0.5 * x27;
	const GEN_FLT x31 = x30 * x25;
	const GEN_FLT x32 = (1. / x9) * x11;
	const GEN_FLT x33 = (1. / (x7 * x7)) * x24 * x12;
	const GEN_FLT x34 = ((x22 * x13) + (x23 * x13) + (-1 * x6 * x33) + (-1 * x30 * x32) + (x4 * x31) + (-1 * x2 * x33) + (x21 * x13) + (-1 * x4 * x33) + (x6 * x31) + (x2 * x31)) * (1. / (x15 * sqrt(x15)));
	const GEN_FLT x35 = x34 * x14;
	const GEN_FLT x36 = 1.0/2.0 * x35;
	const GEN_FLT x37 = x32 * x34 * time;
	const GEN_FLT x38 = x37 * aa_y;
	const GEN_FLT x39 = 1.0/2.0 * obj_qj;
	const GEN_FLT x40 = x32 * x16;
	const GEN_FLT x41 = x40 * aa_x;
	const GEN_FLT x42 = x40 * aa_y;
	const GEN_FLT x43 = x16 * time;
	const GEN_FLT x44 = x43 * aa_y;
	const GEN_FLT x45 = x29 * obj_qj;
	const GEN_FLT x46 = x44 * x26;
	const GEN_FLT x47 = 1.0/2.0 * obj_qk;
	const GEN_FLT x48 = x37 * aa_z;
	const GEN_FLT x49 = x29 * obj_qk;
	const GEN_FLT x50 = x43 * aa_z;
	const GEN_FLT x51 = 0.25 * obj_qw;
	const GEN_FLT x52 = x40 * x24;
	const GEN_FLT x53 = x40 * aa_z;
	const GEN_FLT x54 = x50 * x26;
	const GEN_FLT x55 = x32 * x34 * x17;
	const GEN_FLT x56 = x43 * aa_x;
	const GEN_FLT x57 = 1.0/2.0 * obj_qw;
	const GEN_FLT x58 = x57 * x26;
	const GEN_FLT x59 = x51 * x28;
	const GEN_FLT x60 = x59 * x43;
	const GEN_FLT x61 = x37 * aa_x;
	const GEN_FLT x62 = 0.25 * x52;
	const GEN_FLT x63 = x56 * x26;
	const GEN_FLT x64 = 1.0/2.0 * aa_z;
	const GEN_FLT x65 = x26 * x18;
	const GEN_FLT x66 = x29 * x18;
	const GEN_FLT x67 = 1.0/2.0 * aa_y;
	out[0] = (x54 * x47) + (-1 * x42 * obj_qj) + (1.0/2.0 * x55 * aa_x) + (-1 * x29 * x19) + (-1 * x36 * obj_qw) + (1.0/2.0 * x26 * x19) + (x47 * x48) + (x38 * x39) + (-1 * x44 * x45) + (x46 * x39) + (-1 * x50 * x49) + (-1 * x53 * obj_qk) + (-1 * x41 * obj_qi) + (-1 * x52 * x51);
	out[1] = (-1 * x62 * obj_qi) + (-1 * x50 * x45) + (-1 * x61 * x57) + (x44 * x49) + (x54 * x39) + (x42 * obj_qk) + (-1 * x53 * obj_qj) + (-1 * x46 * x47) + (x48 * x39) + (x41 * obj_qw) + (-1 * x47 * x38) + (-1 * x36 * obj_qi) + (-1 * x58 * x56) + (x60 * aa_x);
	out[2] = (x61 * x47) + (-1 * x62 * obj_qj) + (x59 * x44) + (-1 * x41 * obj_qk) + (-1 * x36 * obj_qj) + (-1 * x64 * x65) + (x53 * obj_qi) + (-1 * x58 * x44) + (x63 * x47) + (-1 * x57 * x38) + (-1 * x64 * x55) + (x42 * obj_qw) + (x66 * aa_z) + (-1 * x56 * x49);
	out[3] = (-1 * x62 * obj_qk) + (x67 * x65) + (x67 * x55) + (x56 * x45) + (x60 * aa_z) + (-1 * x54 * x57) + (x41 * obj_qj) + (x53 * obj_qw) + (-1 * x63 * x39) + (-1 * x57 * x48) + (-1 * x42 * obj_qi) + (-1 * x66 * aa_y) + (-1 * x47 * x35) + (-1 * x61 * x39);
	out[4] = 0;
	out[5] = 0;
	out[6] = 0;
}

// Jacobian of imu_rot_f wrt [obj_qw, obj_qi, obj_qj, obj_qk, aa_x, aa_y, aa_z]
static inline void gen_imu_rot_f_jac_imu_rot(FLT* out, const FLT time, const FLT* imu_rot) {
	const GEN_FLT obj_qw = imu_rot[0];
	const GEN_FLT obj_qi = imu_rot[1];
	const GEN_FLT obj_qj = imu_rot[2];
	const GEN_FLT obj_qk = imu_rot[3];
	const GEN_FLT aa_x = imu_rot[4];
	const GEN_FLT aa_y = imu_rot[5];
	const GEN_FLT aa_z = imu_rot[6];
	const GEN_FLT x0 = time * time;
	const GEN_FLT x1 = aa_z * aa_z;
	const GEN_FLT x2 = x0 * x1;
	const GEN_FLT x3 = aa_x * aa_x;
	const GEN_FLT x4 = x0 * x3;
	const GEN_FLT x5 = aa_y * aa_y;
	const GEN_FLT x6 = x0 * x5;
	const GEN_FLT x7 = 1e-10 + x6 + x2 + x4;
	const GEN_FLT x8 = sqrt(x7);
	const GEN_FLT x9 = 0.5 * x8;
	const GEN_FLT x10 = cos(x9);
	const GEN_FLT x11 = 1. / x7;
	const GEN_FLT x12 = sin(x9);
	const GEN_FLT x13 = x12 * x12;
	const GEN_FLT x14 = x13 * x11;
	const GEN_FLT x15 = 1e-11 + (x4 * x14) + (x10 * x10) + (x2 * x14) + (x6 * x14);
	const GEN_FLT x16 = 1. / sqrt(x15);
	const GEN_FLT x17 = x10 * x16;
	const GEN_FLT x18 = x12 * x16;
	const GEN_FLT x19 = 1. / x8;
	const GEN_FLT x20 = x19 * time;
	const GEN_FLT x21 = x20 * x18;
	const GEN_FLT x22 = x21 * aa_x;
	const GEN_FLT x23 = x21 * aa_y;
	const GEN_FLT x24 = x21 * aa_z;
	const GEN_FLT x25 = -1 * x22;
	const GEN_FLT x26 = -1 * x23;
	const GEN_FLT x27 = -1 * x24;
	const GEN_FLT x28 = time * time * time;
	const GEN_FLT x29 = 1. / (x7 * sqrt(x7));
	const GEN_FLT x30 = x28 * x29;
	const GEN_FLT x31 = x3 * x30;
	const GEN_FLT x32 = x18 * obj_qi;
	const GEN_FLT x33 = 2 * x14;
	const GEN_FLT x34 = x0 * x33;
	const GEN_FLT x35 = time * time * time * time;
	const GEN_FLT x36 = x35 * (aa_x * aa_x * aa_x);
	const GEN_FLT x37 = 2 * (1. / (x7 * x7)) * x13;
	const GEN_FLT x38 = 1.0 * x12 * x10;
	const GEN_FLT x39 = x38 * x29;
	const GEN_FLT x40 = x35 * x37;
	const GEN_FLT x41 = x1 * x40;
	const GEN_FLT x42 = x35 * x39;
	const GEN_FLT x43 = x42 * aa_x;
	const GEN_FLT x44 = x5 * x40;
	const GEN_FLT x45 = x0 * x19;
	const GEN_FLT x46 = x45 * x38;
	const GEN_FLT x47 = (-1 * x44 * aa_x) + (x5 * x43) + (x36 * x39) + (-1 * x46 * aa_x) + (-1 * x36 * x37) + (x34 * aa_x) + (x1 * x43) + (-1 * x41 * aa_x);
	const GEN_FLT x48 = 1.0/2.0 * (1. / (x15 * sqrt(x15)));
	const GEN_FLT x49 = x48 * x10;
	const GEN_FLT x50 = x47 * x49;
	const GEN_FLT x51 = x18 * obj_qw;
	const GEN_FLT x52 = 0.5 * x45;
	const GEN_FLT x53 = x52 * aa_x;
	const GEN_FLT x54 = aa_y * obj_qj;
	const GEN_FLT x55 = x48 * x20 * x12;
	const GEN_FLT x56 = x55 * x47;
	const GEN_FLT x57 = x56 * aa_z;
	const GEN_FLT x58 = x21 * obj_qi;
	const GEN_FLT x59 = -1 * x58;
	const GEN_FLT x60 = 0.5 * x28 * x11 * x17;
	const GEN_FLT x61 = x60 * aa_x;
	const GEN_FLT x62 = x61 * x54;
	const GEN_FLT x63 = x18 * obj_qj;
	const GEN_FLT x64 = x30 * aa_x;
	const GEN_FLT x65 = x64 * aa_y;
	const GEN_FLT x66 = x63 * x65;
	const GEN_FLT x67 = x56 * aa_x;
	const GEN_FLT x68 = x3 * x60;
	const GEN_FLT x69 = x18 * obj_qk;
	const GEN_FLT x70 = x64 * aa_z;
	const GEN_FLT x71 = x61 * aa_z;
	const GEN_FLT x72 = (-1 * x71 * obj_qk) + (x70 * x69);
	const GEN_FLT x73 = x71 * obj_qj;
	const GEN_FLT x74 = aa_y * obj_qk;
	const GEN_FLT x75 = x21 * obj_qw;
	const GEN_FLT x76 = x65 * x69;
	const GEN_FLT x77 = x70 * x63;
	const GEN_FLT x78 = x52 * x32;
	const GEN_FLT x79 = x74 * x61;
	const GEN_FLT x80 = x21 * obj_qk;
	const GEN_FLT x81 = -1 * x80;
	const GEN_FLT x82 = x70 * x32;
	const GEN_FLT x83 = x71 * obj_qi;
	const GEN_FLT x84 = aa_y * obj_qw;
	const GEN_FLT x85 = (x84 * x61) + (-1 * x65 * x51);
	const GEN_FLT x86 = aa_y * obj_qi;
	const GEN_FLT x87 = aa_z * obj_qw;
	const GEN_FLT x88 = x63 * x20;
	const GEN_FLT x89 = x51 * aa_z;
	const GEN_FLT x90 = (x87 * x61) + (-1 * x89 * x64);
	const GEN_FLT x91 = (x65 * x32) + (-1 * x86 * x61);
	const GEN_FLT x92 = -1 * x88;
	const GEN_FLT x93 = x3 * x40;
	const GEN_FLT x94 = x42 * aa_y;
	const GEN_FLT x95 = x0 * aa_y;
	const GEN_FLT x96 = x95 * x19;
	const GEN_FLT x97 = aa_y * aa_y * aa_y;
	const GEN_FLT x98 = (-1 * x97 * x40) + (x97 * x42) + (x95 * x33) + (x3 * x94) + (-1 * x93 * aa_y) + (-1 * x96 * x38) + (x1 * x94) + (-1 * x41 * aa_y);
	const GEN_FLT x99 = x98 * x49;
	const GEN_FLT x100 = x55 * x98;
	const GEN_FLT x101 = x30 * aa_y;
	const GEN_FLT x102 = x101 * aa_z;
	const GEN_FLT x103 = x69 * x102;
	const GEN_FLT x104 = x100 * aa_z;
	const GEN_FLT x105 = x60 * aa_z;
	const GEN_FLT x106 = x74 * x105;
	const GEN_FLT x107 = x5 * x60;
	const GEN_FLT x108 = 0.5 * x96;
	const GEN_FLT x109 = x5 * x30;
	const GEN_FLT x110 = x100 * aa_x;
	const GEN_FLT x111 = x100 * aa_y;
	const GEN_FLT x112 = x100 * obj_qj;
	const GEN_FLT x113 = (-1 * x54 * x105) + (x63 * x102);
	const GEN_FLT x114 = x86 * x105;
	const GEN_FLT x115 = x32 * x102;
	const GEN_FLT x116 = (-1 * x89 * x101) + (x87 * x60 * aa_y);
	const GEN_FLT x117 = x42 * aa_z;
	const GEN_FLT x118 = aa_z * aa_z * aa_z;
	const GEN_FLT x119 = (-1 * x40 * x118) + (-1 * x93 * aa_z) + (-1 * x44 * aa_z) + (x34 * aa_z) + (-1 * x46 * aa_z) + (x42 * x118) + (x5 * x117) + (x3 * x117);
	const GEN_FLT x120 = x55 * x119;
	const GEN_FLT x121 = x49 * x119;
	const GEN_FLT x122 = x120 * aa_x;
	const GEN_FLT x123 = x120 * aa_z;
	const GEN_FLT x124 = x1 * x60;
	const GEN_FLT x125 = x1 * x30;
	const GEN_FLT x126 = x18 * x125;
	const GEN_FLT x127 = x52 * aa_z;
	out[0] = x17;
	out[1] = x22;
	out[2] = x23;
	out[3] = x24;
	out[4] = 0;
	out[5] = 0;
	out[6] = 0;
	out[7] = x25;
	out[8] = x17;
	out[9] = x24;
	out[10] = x26;
	out[11] = 0;
	out[12] = 0;
	out[13] = 0;
	out[14] = x26;
	out[15] = x27;
	out[16] = x17;
	out[17] = x22;
	out[18] = 0;
	out[19] = 0;
	out[20] = 0;
	out[21] = x27;
	out[22] = x23;
	out[23] = x25;
	out[24] = x17;
	out[25] = 0;
	out[26] = 0;
	out[27] = 0;
	out[28] = (-1 * x68 * obj_qi) + (x67 * obj_qi) + x72 + x66 + (x32 * x31) + (-1 * x50 * obj_qw) + (x57 * obj_qk) + (-1 * x53 * x51) + (-1 * x62) + x59 + (x54 * x56);
	out[29] = (x68 * obj_qw) + (x57 * obj_qj) + x77 + (-1 * x78 * aa_x) + x75 + (-1 * x74 * x56) + (-1 * x51 * x31) + (-1 * x73) + x79 + (-1 * x76) + (-1 * x50 * obj_qi) + (-1 * x67 * obj_qw);
	out[30] = x85 + (-1 * x63 * x53) + (-1 * x68 * obj_qk) + (-1 * x84 * x56) + (-1 * x50 * obj_qj) + x81 + (x67 * obj_qk) + (-1 * x82) + (-1 * x57 * obj_qi) + (x69 * x31) + x83;
	out[31] = x90 + (x68 * obj_qj) + x91 + (-1 * x67 * obj_qj) + x88 + (-1 * x87 * x56) + (x86 * x56) + (-1 * x63 * x31) + (-1 * x69 * x53) + (-1 * x50 * obj_qk);
	out[32] = 1;
	out[33] = 0;
	out[34] = 0;
	out[35] = (x110 * obj_qi) + x91 + (-1 * x107 * obj_qj) + (-1 * x106) + (x63 * x109) + (-1 * x99 * obj_qw) + (-1 * x51 * x108) + (x104 * obj_qk) + x92 + (x54 * x100) + x103;
	out[36] = x85 + (-1 * x110 * obj_qw) + (-1 * x99 * obj_qi) + (-1 * x69 * x109) + (x107 * obj_qk) + (-1 * x111 * obj_qk) + x80 + x113 + (x112 * aa_z) + (-1 * x32 * x108);
	out[37] = (x110 * obj_qk) + x114 + (-1 * x79) + (-1 * x99 * obj_qj) + (-1 * x63 * x108) + (x107 * obj_qw) + (-1 * x104 * obj_qi) + (-1 * x115) + x76 + (-1 * x111 * obj_qw) + x75 + (-1 * x51 * x109);
	out[38] = (-1 * x66) + x116 + (-1 * x112 * aa_x) + (-1 * x69 * x108) + (-1 * x107 * obj_qi) + (-1 * x99 * obj_qk) + x62 + x59 + (x111 * obj_qi) + (-1 * x87 * x100) + (x32 * x109);
	out[39] = 0;
	out[40] = 1;
	out[41] = 0;
	out[42] = x82 + (x126 * obj_qk) + (x123 * obj_qk) + (x122 * obj_qi) + (x54 * x120) + x113 + (-1 * x89 * x52) + (-1 * x83) + (-1 * x124 * obj_qk) + (-1 * x121 * obj_qw) + x81;
	out[43] = (-1 * x74 * x120) + (-1 * x121 * obj_qi) + (-1 * x103) + (x63 * x125) + x92 + (-1 * x124 * obj_qj) + (-1 * x122 * obj_qw) + x90 + (-1 * x78 * aa_z) + (x123 * obj_qj) + x106;
	out[44] = x72 + (-1 * x84 * x120) + (-1 * x121 * obj_qj) + (x122 * obj_qk) + x58 + (-1 * x63 * x127) + (-1 * x126 * obj_qi) + x116 + (-1 * x123 * obj_qi) + (x124 * obj_qi);
	out[45] = (-1 * x69 * x127) + (x86 * x120) + (-1 * x121 * obj_qk) + x73 + x75 + (-1 * x77) + (-1 * x87 * x120) + (-1 * x122 * obj_qj) + (-1 * x114) + (-1 * x51 * x125) + (x124 * obj_qw) + x115;
	out[46] = 0;
	out[47] = 0;
	out[48] = 1;
}

static inline void gen_kalman_model_predict(FLT* out, const FLT t, const SurviveKalmanModel* kalman_model) {
	const GEN_FLT obj_px = (*kalman_model).Pose.Pos[0];
	const GEN_FLT obj_py = (*kalman_model).Pose.Pos[1];
	const GEN_FLT obj_pz = (*kalman_model).Pose.Pos[2];
	const GEN_FLT obj_qw = (*kalman_model).Pose.Rot[0];
	const GEN_FLT obj_qi = (*kalman_model).Pose.Rot[1];
	const GEN_FLT obj_qj = (*kalman_model).Pose.Rot[2];
	const GEN_FLT obj_qk = (*kalman_model).Pose.Rot[3];
	const GEN_FLT vx = (*kalman_model).Velocity.Pos[0];
	const GEN_FLT vy = (*kalman_model).Velocity.Pos[1];
	const GEN_FLT vz = (*kalman_model).Velocity.Pos[2];
	const GEN_FLT avx = (*kalman_model).Velocity.AxisAngleRot[0];
	const GEN_FLT avy = (*kalman_model).Velocity.AxisAngleRot[1];
	const GEN_FLT avz = (*kalman_model).Velocity.AxisAngleRot[2];
	const GEN_FLT acc_x = (*kalman_model).Acc[0];
	const GEN_FLT acc_y = (*kalman_model).Acc[1];
	const GEN_FLT acc_z = (*kalman_model).Acc[2];
	const GEN_FLT acc_scale = (*kalman_model).AccScale;
	const GEN_FLT imu_w = (*kalman_model).IMUCorrection[0];
	const GEN_FLT imu_x = (*kalman_model).IMUCorrection[1];
	const GEN_FLT imu_y = (*kalman_model).IMUCorrection[2];
	const GEN_FLT imu_z = (*kalman_model).IMUCorrection[3];
	const GEN_FLT acc_biasx = (*kalman_model).AccBias[0];
	const GEN_FLT acc_biasy = (*kalman_model).AccBias[1];
	const GEN_FLT acc_biasz = (*kalman_model).AccBias[2];
	const GEN_FLT gbx = (*kalman_model).GyroBias[0];
	const GEN_FLT gby = (*kalman_model).GyroBias[1];
	const GEN_FLT gbz = (*kalman_model).GyroBias[2];
	const GEN_FLT x0 = t * t;
	const GEN_FLT x1 = 1.0/2.0 * x0;
	const GEN_FLT x2 = x0 * (avz * avz);
	const GEN_FLT x3 = x0 * (avx * avx);
	const GEN_FLT x4 = x0 * (avy * avy);
	const GEN_FLT x5 = 1e-10 + x4 + x2 + x3;
	const GEN_FLT x6 = sqrt(x5);
	const GEN_FLT x7 = 0.5 * x6;
	const GEN_FLT x8 = sin(x7);
	const GEN_FLT x9 = (1. / x5) * (x8 * x8);
	const GEN_FLT x10 = cos(x7);
	const GEN_FLT x11 = 1. / sqrt(1e-11 + (x3 * x9) + (x10 * x10) + (x2 * x9) + (x4 * x9));
	const GEN_FLT x12 = t * (1. / x6) * x8 * x11;
	const GEN_FLT x13 = x12 * avy;
	const GEN_FLT x14 = x11 * x10;
	const GEN_FLT x15 = x12 * avz;
	const GEN_FLT x16 = x12 * obj_qi;
	const GEN_FLT x17 = x12 * avx;
	out[0] = (t * vx) + (x1 * acc_x) + obj_px;
	out[1] = (t * vy) + (x1 * acc_y) + obj_py;
	out[2] = (t * vz) + (x1 * acc_z) + obj_pz;
	out[3] = (-1 * x15 * obj_qk) + (-1 * x16 * avx) + (-1 * x13 * obj_qj) + (x14 * obj_qw);
	out[4] = (x14 * obj_qi) + (x17 * obj_qw) + (-1 * x15 * obj_qj) + (x13 * obj_qk);
	out[5] = (-1 * x17 * obj_qk) + (x14 * obj_qj) + (x13 * obj_qw) + (x16 * avz);
	out[6] = (x17 * obj_qj) + (-1 * x16 * avy) + (x14 * obj_qk) + (x15 * obj_qw);
	out[7] = vx + (t * acc_x);
	out[8] = vy + (t * acc_y);
	out[9] = vz + (t * acc_z);
	out[10] = avx;
	out[11] = avy;
	out[12] = avz;
	out[13] = acc_x;
	out[14] = acc_y;
	out[15] = acc_z;
	out[16] = acc_scale;
	out[17] = imu_w;
	out[18] = imu_x;
	out[19] = imu_y;
	out[20] = imu_z;
	out[21] = acc_biasx;
	out[22] = acc_biasy;
	out[23] = acc_biasz;
	out[24] = gbx;
	out[25] = gby;
	out[26] = gbz;
}

// Jacobian of kalman_model_predict wrt [t]
static inline void gen_kalman_model_predict_jac_t(FLT* out, const FLT t, const SurviveKalmanModel* kalman_model) {
	const GEN_FLT obj_px = (*kalman_model).Pose.Pos[0];
	const GEN_FLT obj_py = (*kalman_model).Pose.Pos[1];
	const GEN_FLT obj_pz = (*kalman_model).Pose.Pos[2];
	const GEN_FLT obj_qw = (*kalman_model).Pose.Rot[0];
	const GEN_FLT obj_qi = (*kalman_model).Pose.Rot[1];
	const GEN_FLT obj_qj = (*kalman_model).Pose.Rot[2];
	const GEN_FLT obj_qk = (*kalman_model).Pose.Rot[3];
	const GEN_FLT vx = (*kalman_model).Velocity.Pos[0];
	const GEN_FLT vy = (*kalman_model).Velocity.Pos[1];
	const GEN_FLT vz = (*kalman_model).Velocity.Pos[2];
	const GEN_FLT avx = (*kalman_model).Velocity.AxisAngleRot[0];
	const GEN_FLT avy = (*kalman_model).Velocity.AxisAngleRot[1];
	const GEN_FLT avz = (*kalman_model).Velocity.AxisAngleRot[2];
	const GEN_FLT acc_x = (*kalman_model).Acc[0];
	const GEN_FLT acc_y = (*kalman_model).Acc[1];
	const GEN_FLT acc_z = (*kalman_model).Acc[2];
	const GEN_FLT acc_scale = (*kalman_model).AccScale;
	const GEN_FLT imu_w = (*kalman_model).IMUCorrection[0];
	const GEN_FLT imu_x = (*kalman_model).IMUCorrection[1];
	const GEN_FLT imu_y = (*kalman_model).IMUCorrection[2];
	const GEN_FLT imu_z = (*kalman_model).IMUCorrection[3];
	const GEN_FLT acc_biasx = (*kalman_model).AccBias[0];
	const GEN_FLT acc_biasy = (*kalman_model).AccBias[1];
	const GEN_FLT acc_biasz = (*kalman_model).AccBias[2];
	const GEN_FLT gbx = (*kalman_model).GyroBias[0];
	const GEN_FLT gby = (*kalman_model).GyroBias[1];
	const GEN_FLT gbz = (*kalman_model).GyroBias[2];
	const GEN_FLT x0 = t * t;
	const GEN_FLT x1 = avz * avz;
	const GEN_FLT x2 = x0 * x1;
	const GEN_FLT x3 = avx * avx;
	const GEN_FLT x4 = x0 * x3;
	const GEN_FLT x5 = avy * avy;
	const GEN_FLT x6 = x0 * x5;
	const GEN_FLT x7 = 1e-10 + x6 + x2 + x4;
	const GEN_FLT x8 = 1. / x7;
	const GEN_FLT x9 = sqrt(x7);
	const GEN_FLT x10 = 0.5 * x9;
	const GEN_FLT x11 = sin(x10);
	const GEN_FLT x12 = x11 * x11;
	const GEN_FLT x13 = x8 * x12;
	const GEN_FLT x14 = cos(x10);
	const GEN_FLT x15 = 1e-11 + (x4 * x13) + (x14 * x14) + (x2 * x13) + (x6 * x13);
	const GEN_FLT x16 = 1. / sqrt(x15);
	const GEN_FLT x17 = (1. / x9) * x11;
	const GEN_FLT x18 = x17 * x16;
	const GEN_FLT x19 = x18 * avx;
	const GEN_FLT x20 = 1.0/2.0 * obj_qj;
	const GEN_FLT x21 = t * avy;
	const GEN_FLT x22 = 2 * t;
	const GEN_FLT x23 = x5 * x22;
	const GEN_FLT x24 = x1 * x22;
	const GEN_FLT x25 = x3 * x22;
	const GEN_FLT x26 = x25 + x23 + x24;
	const GEN_FLT x27 = (1. / (x7 * sqrt(x7))) * x11;
	const GEN_FLT x28 = x26 * x27;
	const GEN_FLT x29 = x28 * x16;
	const GEN_FLT x30 = x21 * x29;
	const GEN_FLT x31 = 0.25 * obj_qj;
	const GEN_FLT x32 = x26 * x14;
	const GEN_FLT x33 = x8 * x32;
	const GEN_FLT x34 = x31 * x33;
	const GEN_FLT x35 = x34 * x16;
	const GEN_FLT x36 = 0.5 * x32;
	const GEN_FLT x37 = x36 * x27;
	const GEN_FLT x38 = (1. / (x7 * x7)) * x26 * x12;
	const GEN_FLT x39 = ((x23 * x13) + (x6 * x37) + (x2 * x37) + (-1 * x6 * x38) + (-1 * x4 * x38) + (-1 * x36 * x17) + (x4 * x37) + (x25 * x13) + (-1 * x2 * x38) + (x24 * x13)) * (1. / (x15 * sqrt(x15)));
	const GEN_FLT x40 = x39 * x17;
	const GEN_FLT x41 = x40 * x20;
	const GEN_FLT x42 = 1.0/2.0 * obj_qk;
	const GEN_FLT x43 = x16 * avz;
	const GEN_FLT x44 = t * x43;
	const GEN_FLT x45 = x44 * x28;
	const GEN_FLT x46 = x18 * avy;
	const GEN_FLT x47 = 1.0/2.0 * obj_qi;
	const GEN_FLT x48 = t * avx;
	const GEN_FLT x49 = x48 * x29;
	const GEN_FLT x50 = 1.0/2.0 * x40;
	const GEN_FLT x51 = t * x50;
	const GEN_FLT x52 = x51 * avz;
	const GEN_FLT x53 = x51 * avx;
	const GEN_FLT x54 = x26 * x18;
	const GEN_FLT x55 = 0.25 * x54;
	const GEN_FLT x56 = x39 * x14;
	const GEN_FLT x57 = 1.0/2.0 * x56;
	const GEN_FLT x58 = 0.25 * x33;
	const GEN_FLT x59 = x58 * x44;
	const GEN_FLT x60 = x58 * x16;
	const GEN_FLT x61 = x60 * x48;
	const GEN_FLT x62 = x18 * avz;
	const GEN_FLT x63 = t * obj_qw;
	const GEN_FLT x64 = x63 * avx;
	const GEN_FLT x65 = 1.0/2.0 * x29;
	const GEN_FLT x66 = x60 * x21;
	const GEN_FLT x67 = x51 * avy;
	const GEN_FLT x68 = x63 * avy;
	const GEN_FLT x69 = x48 * x20;
	const GEN_FLT x70 = x63 * x43;
	out[0] = (t * acc_x) + vx;
	out[1] = (t * acc_y) + vy;
	out[2] = (t * acc_z) + vz;
	out[3] = (-1 * x61 * obj_qi) + (-1 * x35 * x21) + (-1 * x19 * obj_qi) + (x41 * x21) + (-1 * x57 * obj_qw) + (x42 * x45) + (x52 * obj_qk) + (x30 * x20) + (-1 * x62 * obj_qk) + (x47 * x49) + (-1 * x55 * obj_qw) + (-1 * x46 * obj_qj) + (-1 * x59 * obj_qk) + (x53 * obj_qi);
	out[4] = (-1 * x55 * obj_qi) + (-1 * x42 * x30) + (x46 * obj_qk) + (x45 * x20) + (x19 * obj_qw) + (-1 * x64 * x65) + (-1 * x64 * x50) + (-1 * x62 * obj_qj) + (-1 * x44 * x34) + (x60 * x64) + (x66 * obj_qk) + (-1 * x57 * obj_qi) + (-1 * x67 * obj_qk) + (t * x41 * avz);
	out[5] = (-1 * x54 * x31) + (x59 * obj_qi) + (-1 * x61 * obj_qk) + (-1 * x52 * obj_qi) + (x53 * obj_qk) + (x62 * obj_qi) + (-1 * x68 * x65) + (-1 * x19 * obj_qk) + (x60 * x68) + (-1 * x45 * x47) + (x46 * obj_qw) + (-1 * x68 * x50) + (x42 * x49) + (-1 * x56 * x20);
	out[6] = (-1.0/2.0 * x70 * x28) + (-1 * x63 * x50 * avz) + (-1 * x66 * obj_qi) + (-1 * x55 * obj_qk) + (x48 * x35) + (x70 * x58) + (-1 * x46 * obj_qi) + (-1 * x69 * x40) + (-1 * x57 * obj_qk) + (x19 * obj_qj) + (x47 * x30) + (-1 * x69 * x29) + (x67 * obj_qi) + (x62 * obj_qw);
	out[7] = acc_x;
	out[8] = acc_y;
	out[9] = acc_z;
	out[10] = 0;
	out[11] = 0;
	out[12] = 0;
	out[13] = 0;
	out[14] = 0;
	out[15] = 0;
	out[16] = 0;
	out[17] = 0;
	out[18] = 0;
	out[19] = 0;
	out[20] = 0;
	out[21] = 0;
	out[22] = 0;
	out[23] = 0;
	out[24] = 0;
	out[25] = 0;
	out[26] = 0;
}

// Jacobian of kalman_model_predict wrt [obj_px, obj_py, obj_pz, obj_qw, obj_qi, obj_qj, obj_qk, vx, vy, vz, avx, avy, avz, acc_x, acc_y, acc_z, acc_scale, imu_w, imu_x, imu_y, imu_z, acc_biasx, acc_biasy, acc_biasz, gbx, gby, gbz]
static inline void gen_kalman_model_predict_jac_kalman_model(FLT* out, const FLT t, const SurviveKalmanModel* kalman_model) {
	const GEN_FLT obj_px = (*kalman_model).Pose.Pos[0];
	const GEN_FLT obj_py = (*kalman_model).Pose.Pos[1];
	const GEN_FLT obj_pz = (*kalman_model).Pose.Pos[2];
	const GEN_FLT obj_qw = (*kalman_model).Pose.Rot[0];
	const GEN_FLT obj_qi = (*kalman_model).Pose.Rot[1];
	const GEN_FLT obj_qj = (*kalman_model).Pose.Rot[2];
	const GEN_FLT obj_qk = (*kalman_model).Pose.Rot[3];
	const GEN_FLT vx = (*kalman_model).Velocity.Pos[0];
	const GEN_FLT vy = (*kalman_model).Velocity.Pos[1];
	const GEN_FLT vz = (*kalman_model).Velocity.Pos[2];
	const GEN_FLT avx = (*kalman_model).Velocity.AxisAngleRot[0];
	const GEN_FLT avy = (*kalman_model).Velocity.AxisAngleRot[1];
	const GEN_FLT avz = (*kalman_model).Velocity.AxisAngleRot[2];
	const GEN_FLT acc_x = (*kalman_model).Acc[0];
	const GEN_FLT acc_y = (*kalman_model).Acc[1];
	const GEN_FLT acc_z = (*kalman_model).Acc[2];
	const GEN_FLT acc_scale = (*kalman_model).AccScale;
	const GEN_FLT imu_w = (*kalman_model).IMUCorrection[0];
	const GEN_FLT imu_x = (*kalman_model).IMUCorrection[1];
	const GEN_FLT imu_y = (*kalman_model).IMUCorrection[2];
	const GEN_FLT imu_z = (*kalman_model).IMUCorrection[3];
	const GEN_FLT acc_biasx = (*kalman_model).AccBias[0];
	const GEN_FLT acc_biasy = (*kalman_model).AccBias[1];
	const GEN_FLT acc_biasz = (*kalman_model).AccBias[2];
	const GEN_FLT gbx = (*kalman_model).GyroBias[0];
	const GEN_FLT gby = (*kalman_model).GyroBias[1];
	const GEN_FLT gbz = (*kalman_model).GyroBias[2];
	const GEN_FLT x0 = t * t;
	const GEN_FLT x1 = 1.0/2.0 * x0;
	const GEN_FLT x2 = avz * avz;
	const GEN_FLT x3 = x0 * x2;
	const GEN_FLT x4 = avx * avx;
	const GEN_FLT x5 = x0 * x4;
	const GEN_FLT x6 = avy * avy;
	const GEN_FLT x7 = x0 * x6;
	const GEN_FLT x8 = 1e-10 + x7 + x3 + x5;
	const GEN_FLT x9 = 1. / x8;
	const GEN_FLT x10 = sqrt(x8);
	const GEN_FLT x11 = 0.5 * x10;
	const GEN_FLT x12 = sin(x11);
	const GEN_FLT x13 = x12 * x12;
	const GEN_FLT x14 = x9 * x13;
	const GEN_FLT x15 = cos(x11);
	const GEN_FLT x16 = 1e-11 + (x5 * x14) + (x15 * x15) + (x3 * x14) + (x7 * x14);
	const GEN_FLT x17 = 1. / sqrt(x16);
	const GEN_FLT x18 = x15 * x17;
	const GEN_FLT x19 = x12 * (1. / x10);
	const GEN_FLT x20 = t * x19;
	const GEN_FLT x21 = x20 * x17;
	const GEN_FLT x22 = x21 * avx;
	const GEN_FLT x23 = -1 * x22;
	const GEN_FLT x24 = x21 * avy;
	const GEN_FLT x25 = -1 * x24;
	const GEN_FLT x26 = x21 * avz;
	const GEN_FLT x27 = -1 * x26;
	const GEN_FLT x28 = x21 * obj_qi;
	const GEN_FLT x29 = -1 * x28;
	const GEN_FLT x30 = x17 * obj_qi;
	const GEN_FLT x31 = t * t * t;
	const GEN_FLT x32 = (1. / (x8 * sqrt(x8))) * x12;
	const GEN_FLT x33 = x32 * x31;
	const GEN_FLT x34 = x4 * x33;
	const GEN_FLT x35 = avx * avx * avx;
	const GEN_FLT x36 = t * t * t * t;
	const GEN_FLT x37 = 2 * (1. / (x8 * x8)) * x13;
	const GEN_FLT x38 = x36 * x37;
	const GEN_FLT x39 = 2 * x14;
	const GEN_FLT x40 = x0 * x39;
	const GEN_FLT x41 = 1.0 * x15;
	const GEN_FLT x42 = x41 * x32;
	const GEN_FLT x43 = x42 * x36;
	const GEN_FLT x44 = x38 * avx;
	const GEN_FLT x45 = x2 * x43;
	const GEN_FLT x46 = x0 * x19;
	const GEN_FLT x47 = x46 * avx;
	const GEN_FLT x48 = (-1 * x41 * x47) + (x6 * x43 * avx) + (x40 * avx) + (-1 * x35 * x38) + (x43 * x35) + (-1 * x2 * x44) + (-1 * x6 * x44) + (x45 * avx);
	const GEN_FLT x49 = 1.0/2.0 * (1. / (x16 * sqrt(x16)));
	const GEN_FLT x50 = x49 * x20;
	const GEN_FLT x51 = x50 * avy;
	const GEN_FLT x52 = x51 * x48;
	const GEN_FLT x53 = 0.5 * x9 * x31 * x18;
	const GEN_FLT x54 = x4 * x53;
	const GEN_FLT x55 = x53 * avy;
	const GEN_FLT x56 = x55 * avx;
	const GEN_FLT x57 = x56 * obj_qj;
	const GEN_FLT x58 = x49 * x15;
	const GEN_FLT x59 = x58 * x48;
	const GEN_FLT x60 = x17 * obj_qw;
	const GEN_FLT x61 = 0.5 * x47;
	const GEN_FLT x62 = x17 * obj_qj;
	const GEN_FLT x63 = x33 * avy;
	const GEN_FLT x64 = x63 * avx;
	const GEN_FLT x65 = x64 * x62;
	const GEN_FLT x66 = x50 * x48;
	const GEN_FLT x67 = x66 * avz;
	const GEN_FLT x68 = avx * obj_qi;
	const GEN_FLT x69 = avx * obj_qk;
	const GEN_FLT x70 = x17 * obj_qk;
	const GEN_FLT x71 = x33 * avx;
	const GEN_FLT x72 = x71 * avz;
	const GEN_FLT x73 = (x70 * x72) + (-1 * x69 * x53 * avz);
	const GEN_FLT x74 = x62 * x20;
	const GEN_FLT x75 = -1 * x74;
	const GEN_FLT x76 = x38 * avy;
	const GEN_FLT x77 = x0 * avy;
	const GEN_FLT x78 = x77 * x19;
	const GEN_FLT x79 = x36 * (avy * avy * avy);
	const GEN_FLT x80 = (x77 * x39) + (x79 * x42) + (-1 * x2 * x76) + (-1 * x78 * x41) + (-1 * x79 * x37) + (x4 * x43 * avy) + (-1 * x4 * x76) + (x45 * avy);
	const GEN_FLT x81 = x80 * x50;
	const GEN_FLT x82 = 0.5 * x78;
	const GEN_FLT x83 = x55 * avz;
	const GEN_FLT x84 = x83 * obj_qk;
	const GEN_FLT x85 = x6 * x33;
	const GEN_FLT x86 = x80 * x51;
	const GEN_FLT x87 = x81 * avz;
	const GEN_FLT x88 = x63 * avz;
	const GEN_FLT x89 = x88 * x70;
	const GEN_FLT x90 = x6 * x53;
	const GEN_FLT x91 = x80 * x58;
	const GEN_FLT x92 = (-1 * x56 * obj_qi) + (x64 * x30);
	const GEN_FLT x93 = x38 * avz;
	const GEN_FLT x94 = x43 * avz;
	const GEN_FLT x95 = x46 * avz;
	const GEN_FLT x96 = avz * avz * avz;
	const GEN_FLT x97 = (-1 * x6 * x93) + (-1 * x96 * x38) + (x4 * x94) + (x40 * avz) + (-1 * x4 * x93) + (-1 * x95 * x41) + (x96 * x43) + (x6 * x94);
	const GEN_FLT x98 = x58 * x97;
	const GEN_FLT x99 = x51 * x97;
	const GEN_FLT x100 = x50 * x97;
	const GEN_FLT x101 = x2 * x53;
	const GEN_FLT x102 = avz * x100;
	const GEN_FLT x103 = x2 * x33;
	const GEN_FLT x104 = 0.5 * x95;
	const GEN_FLT x105 = x53 * avx;
	const GEN_FLT x106 = avz * x105;
	const GEN_FLT x107 = x106 * obj_qi;
	const GEN_FLT x108 = x21 * obj_qk;
	const GEN_FLT x109 = -1 * x108;
	const GEN_FLT x110 = x72 * x30;
	const GEN_FLT x111 = x62 * avz;
	const GEN_FLT x112 = (x63 * x111) + (-1 * x83 * obj_qj);
	const GEN_FLT x113 = avz * obj_qj;
	const GEN_FLT x114 = x69 * x55;
	const GEN_FLT x115 = x105 * x113;
	const GEN_FLT x116 = x70 * x64;
	const GEN_FLT x117 = x71 * x111;
	const GEN_FLT x118 = x66 * avx;
	const GEN_FLT x119 = x21 * obj_qw;
	const GEN_FLT x120 = x81 * avx;
	const GEN_FLT x121 = x85 * x17;
	const GEN_FLT x122 = (-1 * x60 * x64) + (x56 * obj_qw);
	const GEN_FLT x123 = avx * x100;
	const GEN_FLT x124 = (-1 * x72 * x60) + (x106 * obj_qw);
	const GEN_FLT x125 = x83 * obj_qi;
	const GEN_FLT x126 = x88 * x30;
	const GEN_FLT x127 = (-1 * x88 * x60) + (x83 * obj_qw);
	out[0] = 1;
	out[1] = 0;
	out[2] = 0;
	out[3] = 0;
	out[4] = 0;
	out[5] = 0;
	out[6] = 0;
	out[7] = t;
	out[8] = 0;
	out[9] = 0;
	out[10] = 0;
	out[11] = 0;
	out[12] = 0;
	out[13] = x1;
	out[14] = 0;
	out[15] = 0;
	out[16] = 0;
	out[17] = 0;
	out[18] = 0;
	out[19] = 0;
	out[20] = 0;
	out[21] = 0;
	out[22] = 0;
	out[23] = 0;
	out[24] = 0;
	out[25] = 0;
	out[26] = 0;
	out[27] = 0;
	out[28] = 1;
	out[29] = 0;
	out[30] = 0;
	out[31] = 0;
	out[32] = 0;
	out[33] = 0;
	out[34] = 0;
	out[35] = t;
	out[36] = 0;
	out[37] = 0;
	out[38] = 0;
	out[39] = 0;
	out[40] = 0;
	out[41] = x1;
	out[42] = 0;
	out[43] = 0;
	out[44] = 0;
	out[45] = 0;
	out[46] = 0;
	out[47] = 0;
	out[48] = 0;
	out[49] = 0;
	out[50] = 0;
	out[51] = 0;
	out[52] = 0;
	out[53] = 0;
	out[54] = 0;
	out[55] = 0;
	out[56] = 1;
	out[57] = 0;
	out[58] = 0;
	out[59] = 0;
	out[60] = 0;
	out[61] = 0;
	out[62] = 0;
	out[63] = t;
	out[64] = 0;
	out[65] = 0;
	out[66] = 0;
	out[67] = 0;
	out[68] = 0;
	out[69] = x1;
	out[70] = 0;
	out[71] = 0;
	out[72] = 0;
	out[73] = 0;
	out[74] = 0;
	out[75] = 0;
	out[76] = 0;
	out[77] = 0;
	out[78] = 0;
	out[79] = 0;
	out[80] = 0;
	out[81] = 0;
	out[82] = 0;
	out[83] = 0;
	out[84] = x18;
	out[85] = x23;
	out[86] = x25;
	out[87] = x27;
	out[88] = 0;
	out[89] = 0;
	out[90] = 0;
	out[91] = (x68 * x66) + (x67 * obj_qk) + (-1 * x59 * obj_qw) + x29 + (-1 * x60 * x61) + (x30 * x34) + (-1 * x57) + (x52 * obj_qj) + x73 + x65 + (-1 * x54 * obj_qi);
	out[92] = x92 + (-1 * x90 * obj_qj) + x89 + (x81 * x68) + (x86 * obj_qj) + x75 + (-1 * x82 * x60) + (x87 * obj_qk) + (-1 * x84) + (-1 * x91 * obj_qw) + (x85 * x62);
	out[93] = x112 + x110 + (x70 * x103) + (-1 * x107) + (x99 * obj_qj) + (-1 * x98 * obj_qw) + (-1 * x101 * obj_qk) + x109 + (x102 * obj_qk) + (-1 * x60 * x104) + (x68 * x100);
	out[94] = 0;
	out[95] = 0;
	out[96] = 0;
	out[97] = 0;
	out[98] = 0;
	out[99] = 0;
	out[100] = 0;
	out[101] = 0;
	out[102] = 0;
	out[103] = 0;
	out[104] = 0;
	out[105] = 0;
	out[106] = 0;
	out[107] = 0;
	out[108] = 0;
	out[109] = 0;
	out[110] = 0;
	out[111] = x22;
	out[112] = x18;
	out[113] = x27;
	out[114] = x24;
	out[115] = 0;
	out[116] = 0;
	out[117] = 0;
	out[118] = x119 + (-1 * x115) + (-1 * x61 * x30) + (-1 * x116) + (-1 * x59 * obj_qi) + (-1 * x60 * x34) + x117 + (x54 * obj_qw) + (x66 * x113) + x114 + (-1 * x52 * obj_qk) + (-1 * x118 * obj_qw);
	out[119] = x122 + (x81 * x113) + (-1 * x91 * obj_qi) + x112 + (-1 * x121 * obj_qk) + (-1 * x120 * obj_qw) + (-1 * x82 * x30) + x108 + (x90 * obj_qk) + (-1 * x86 * obj_qk);
	out[120] = x124 + (-1 * x123 * obj_qw) + (-1 * x98 * obj_qi) + (-1 * x101 * obj_qj) + x75 + (-1 * x99 * obj_qk) + (-1 * x89) + x84 + (x62 * x103) + (-1 * x30 * x104) + (x100 * x113);
	out[121] = 0;
	out[122] = 0;
	out[123] = 0;
	out[124] = 0;
	out[125] = 0;
	out[126] = 0;
	out[127] = 0;
	out[128] = 0;
	out[129] = 0;
	out[130] = 0;
	out[131] = 0;
	out[132] = 0;
	out[133] = 0;
	out[134] = 0;
	out[135] = 0;
	out[136] = 0;
	out[137] = 0;
	out[138] = x24;
	out[139] = x26;
	out[140] = x18;
	out[141] = x23;
	out[142] = 0;
	out[143] = 0;
	out[144] = 0;
	out[145] = (-1 * x110) + (x66 * x69) + x107 + (x70 * x34) + x122 + (-1 * x59 * obj_qj) + (-1 * x67 * obj_qi) + x109 + (-1 * x52 * obj_qw) + (-1 * x61 * x62) + (-1 * x54 * obj_qk);
	out[146] = (-1 * x114) + x125 + (x81 * x69) + x119 + (x90 * obj_qw) + (-1 * x85 * x60) + (-1 * x82 * x62) + (-1 * x91 * obj_qj) + (-1 * x86 * obj_qw) + (-1 * x126) + x116 + (-1 * x87 * obj_qi);
	out[147] = x73 + x127 + (-1 * x62 * x104) + (-1 * x99 * obj_qw) + (x101 * obj_qi) + (x69 * x100) + (-1 * x102 * obj_qi) + (-1 * x98 * obj_qj) + x28 + (-1 * x30 * x103);
	out[148] = 0;
	out[149] = 0;
	out[150] = 0;
	out[151] = 0;
	out[152] = 0;
	out[153] = 0;
	out[154] = 0;
	out[155] = 0;
	out[156] = 0;
	out[157] = 0;
	out[158] = 0;
	out[159] = 0;
	out[160] = 0;
	out[161] = 0;
	out[162] = 0;
	out[163] = 0;
	out[164] = 0;
	out[165] = x26;
	out[166] = x25;
	out[167] = x22;
	out[168] = x18;
	out[169] = 0;
	out[170] = 0;
	out[171] = 0;
	out[172] = x124 + x74 + x92 + (-1 * x118 * obj_qj) + (x52 * obj_qi) + (-1 * x62 * x34) + (-1 * x70 * x61) + (-1 * x59 * obj_qk) + (x54 * obj_qj) + (-1 * x67 * obj_qw);
	out[173] = (-1 * x65) + x57 + (-1 * x82 * x70) + (x121 * obj_qi) + (-1 * x87 * obj_qw) + x127 + (x86 * obj_qi) + (-1 * x90 * obj_qi) + x29 + (-1 * x91 * obj_qk) + (-1 * x120 * obj_qj);
	out[174] = (-1 * x117) + x119 + (-1 * x125) + (x101 * obj_qw) + (-1 * x102 * obj_qw) + (x99 * obj_qi) + (-1 * x70 * x104) + x115 + (-1 * x60 * x103) + (-1 * x98 * obj_qk) + x126 + (-1 * x123 * obj_qj);
	out[175] = 0;
	out[176] = 0;
	out[177] = 0;
	out[178] = 0;
	out[179] = 0;
	out[180] = 0;
	out[181] = 0;
	out[182] = 0;
	out[183] = 0;
	out[184] = 0;
	out[185] = 0;
	out[186] = 0;
	out[187] = 0;
	out[188] = 0;
	out[189] = 0;
	out[190] = 0;
	out[191] = 0;
	out[192] = 0;
	out[193] = 0;
	out[194] = 0;
	out[195] = 0;
	out[196] = 1;
	out[197] = 0;
	out[198] = 0;
	out[199] = 0;
	out[200] = 0;
	out[201] = 0;
	out[202] = t;
	out[203] = 0;
	out[204] = 0;
	out[205] = 0;
	out[206] = 0;
	out[207] = 0;
	out[208] = 0;
	out[209] = 0;
	out[210] = 0;
	out[211] = 0;
	out[212] = 0;
	out[213] = 0;
	out[214] = 0;
	out[215] = 0;
	out[216] = 0;
	out[217] = 0;
	out[218] = 0;
	out[219] = 0;
	out[220] = 0;
	out[221] = 0;
	out[222] = 0;
	out[223] = 0;
	out[224] = 1;
	out[225] = 0;
	out[226] = 0;
	out[227] = 0;
	out[228] = 0;
	out[229] = 0;
	out[230] = t;
	out[231] = 0;
	out[232] = 0;
	out[233] = 0;
	out[234] = 0;
	out[235] = 0;
	out[236] = 0;
	out[237] = 0;
	out[238] = 0;
	out[239] = 0;
	out[240] = 0;
	out[241] = 0;
	out[242] = 0;
	out[243] = 0;
	out[244] = 0;
	out[245] = 0;
	out[246] = 0;
	out[247] = 0;
	out[248] = 0;
	out[249] = 0;
	out[250] = 0;
	out[251] = 0;
	out[252] = 1;
	out[253] = 0;
	out[254] = 0;
	out[255] = 0;
	out[256] = 0;
	out[257] = 0;
	out[258] = t;
	out[259] = 0;
	out[260] = 0;
	out[261] = 0;
	out[262] = 0;
	out[263] = 0;
	out[264] = 0;
	out[265] = 0;
	out[266] = 0;
	out[267] = 0;
	out[268] = 0;
	out[269] = 0;
	out[270] = 0;
	out[271] = 0;
	out[272] = 0;
	out[273] = 0;
	out[274] = 0;
	out[275] = 0;
	out[276] = 0;
	out[277] = 0;
	out[278] = 0;
	out[279] = 0;
	out[280] = 1;
	out[281] = 0;
	out[282] = 0;
	out[283] = 0;
	out[284] = 0;
	out[285] = 0;
	out[286] = 0;
	out[287] = 0;
	out[288] = 0;
	out[289] = 0;
	out[290] = 0;
	out[291] = 0;
	out[292] = 0;
	out[293] = 0;
	out[294] = 0;
	out[295] = 0;
	out[296] = 0;
	out[297] = 0;
	out[298] = 0;
	out[299] = 0;
	out[300] = 0;
	out[301] = 0;
	out[302] = 0;
	out[303] = 0;
	out[304] = 0;
	out[305] = 0;
	out[306] = 0;
	out[307] = 0;
	out[308] = 1;
	out[309] = 0;
	out[310] = 0;
	out[311] = 0;
	out[312] = 0;
	out[313] = 0;
	out[314] = 0;
	out[315] = 0;
	out[316] = 0;
	out[317] = 0;
	out[318] = 0;
	out[319] = 0;
	out[320] = 0;
	out[321] = 0;
	out[322] = 0;
	out[323] = 0;
	out[324] = 0;
	out[325] = 0;
	out[326] = 0;
	out[327] = 0;
	out[328] = 0;
	out[329] = 0;
	out[330] = 0;
	out[331] = 0;
	out[332] = 0;
	out[333] = 0;
	out[334] = 0;
	out[335] = 0;
	out[336] = 1;
	out[337] = 0;
	out[338] = 0;
	out[339] = 0;
	out[340] = 0;
	out[341] = 0;
	out[342] = 0;
	out[343] = 0;
	out[344] = 0;
	out[345] = 0;
	out[346] = 0;
	out[347] = 0;
	out[348] = 0;
	out[349] = 0;
	out[350] = 0;
	out[351] = 0;
	out[352] = 0;
	out[353] = 0;
	out[354] = 0;
	out[355] = 0;
	out[356] = 0;
	out[357] = 0;
	out[358] = 0;
	out[359] = 0;
	out[360] = 0;
	out[361] = 0;
	out[362] = 0;
	out[363] = 0;
	out[364] = 1;
	out[365] = 0;
	out[366] = 0;
	out[367] = 0;
	out[368] = 0;
	out[369] = 0;
	out[370] = 0;
	out[371] = 0;
	out[372] = 0;
	out[373] = 0;
	out[374] = 0;
	out[375] = 0;
	out[376] = 0;
	out[377] = 0;
	out[378] = 0;
	out[379] = 0;
	out[380] = 0;
	out[381] = 0;
	out[382] = 0;
	out[383] = 0;
	out[384] = 0;
	out[385] = 0;
	out[386] = 0;
	out[387] = 0;
	out[388] = 0;
	out[389] = 0;
	out[390] = 0;
	out[391] = 0;
	out[392] = 1;
	out[393] = 0;
	out[394] = 0;
	out[395] = 0;
	out[396] = 0;
	out[397] = 0;
	out[398] = 0;
	out[399] = 0;
	out[400] = 0;
	out[401] = 0;
	out[402] = 0;
	out[403] = 0;
	out[404] = 0;
	out[405] = 0;
	out[406] = 0;
	out[407] = 0;
	out[408] = 0;
	out[409] = 0;
	out[410] = 0;
	out[411] = 0;
	out[412] = 0;
	out[413] = 0;
	out[414] = 0;
	out[415] = 0;
	out[416] = 0;
	out[417] = 0;
	out[418] = 0;
	out[419] = 0;
	out[420] = 1;
	out[421] = 0;
	out[422] = 0;
	out[423] = 0;
	out[424] = 0;
	out[425] = 0;
	out[426] = 0;
	out[427] = 0;
	out[428] = 0;
	out[429] = 0;
	out[430] = 0;
	out[431] = 0;
	out[432] = 0;
	out[433] = 0;
	out[434] = 0;
	out[435] = 0;
	out[436] = 0;
	out[437] = 0;
	out[438] = 0;
	out[439] = 0;
	out[440] = 0;
	out[441] = 0;
	out[442] = 0;
	out[443] = 0;
	out[444] = 0;
	out[445] = 0;
	out[446] = 0;
	out[447] = 0;
	out[448] = 1;
	out[449] = 0;
	out[450] = 0;
	out[451] = 0;
	out[452] = 0;
	out[453] = 0;
	out[454] = 0;
	out[455] = 0;
	out[456] = 0;
	out[457] = 0;
	out[458] = 0;
	out[459] = 0;
	out[460] = 0;
	out[461] = 0;
	out[462] = 0;
	out[463] = 0;
	out[464] = 0;
	out[465] = 0;
	out[466] = 0;
	out[467] = 0;
	out[468] = 0;
	out[469] = 0;
	out[470] = 0;
	out[471] = 0;
	out[472] = 0;
	out[473] = 0;
	out[474] = 0;
	out[475] = 0;
	out[476] = 1;
	out[477] = 0;
	out[478] = 0;
	out[479] = 0;
	out[480] = 0;
	out[481] = 0;
	out[482] = 0;
	out[483] = 0;
	out[484] = 0;
	out[485] = 0;
	out[486] = 0;
	out[487] = 0;
	out[488] = 0;
	out[489] = 0;
	out[490] = 0;
	out[491] = 0;
	out[492] = 0;
	out[493] = 0;
	out[494] = 0;
	out[495] = 0;
	out[496] = 0;
	out[497] = 0;
	out[498] = 0;
	out[499] = 0;
	out[500] = 0;
	out[501] = 0;
	out[502] = 0;
	out[503] = 0;
	out[504] = 1;
	out[505] = 0;
	out[506] = 0;
	out[507] = 0;
	out[508] = 0;
	out[509] = 0;
	out[510] = 0;
	out[511] = 0;
	out[512] = 0;
	out[513] = 0;
	out[514] = 0;
	out[515] = 0;
	out[516] = 0;
	out[517] = 0;
	out[518] = 0;
	out[519] = 0;
	out[520] = 0;
	out[521] = 0;
	out[522] = 0;
	out[523] = 0;
	out[524] = 0;
	out[525] = 0;
	out[526] = 0;
	out[527] = 0;
	out[528] = 0;
	out[529] = 0;
	out[530] = 0;
	out[531] = 0;
	out[532] = 1;
	out[533] = 0;
	out[534] = 0;
	out[535] = 0;
	out[536] = 0;
	out[537] = 0;
	out[538] = 0;
	out[539] = 0;
	out[540] = 0;
	out[541] = 0;
	out[542] = 0;
	out[543] = 0;
	out[544] = 0;
	out[545] = 0;
	out[546] = 0;
	out[547] = 0;
	out[548] = 0;
	out[549] = 0;
	out[550] = 0;
	out[551] = 0;
	out[552] = 0;
	out[553] = 0;
	out[554] = 0;
	out[555] = 0;
	out[556] = 0;
	out[557] = 0;
	out[558] = 0;
	out[559] = 0;
	out[560] = 1;
	out[561] = 0;
	out[562] = 0;
	out[563] = 0;
	out[564] = 0;
	out[565] = 0;
	out[566] = 0;
	out[567] = 0;
	out[568] = 0;
	out[569] = 0;
	out[570] = 0;
	out[571] = 0;
	out[572] = 0;
	out[573] = 0;
	out[574] = 0;
	out[575] = 0;
	out[576] = 0;
	out[577] = 0;
	out[578] = 0;
	out[579] = 0;
	out[580] = 0;
	out[581] = 0;
	out[582] = 0;
	out[583] = 0;
	out[584] = 0;
	out[585] = 0;
	out[586] = 0;
	out[587] = 0;
	out[588] = 1;
	out[589] = 0;
	out[590] = 0;
	out[591] = 0;
	out[592] = 0;
	out[593] = 0;
	out[594] = 0;
	out[595] = 0;
	out[596] = 0;
	out[597] = 0;
	out[598] = 0;
	out[599] = 0;
	out[600] = 0;
	out[601] = 0;
	out[602] = 0;
	out[603] = 0;
	out[604] = 0;
	out[605] = 0;
	out[606] = 0;
	out[607] = 0;
	out[608] = 0;
	out[609] = 0;
	out[610] = 0;
	out[611] = 0;
	out[612] = 0;
	out[613] = 0;
	out[614] = 0;
	out[615] = 0;
	out[616] = 1;
	out[617] = 0;
	out[618] = 0;
	out[619] = 0;
	out[620] = 0;
	out[621] = 0;
	out[622] = 0;
	out[623] = 0;
	out[624] = 0;
	out[625] = 0;
	out[626] = 0;
	out[627] = 0;
	out[628] = 0;
	out[629] = 0;
	out[630] = 0;
	out[631] = 0;
	out[632] = 0;
	out[633] = 0;
	out[634] = 0;
	out[635] = 0;
	out[636] = 0;
	out[637] = 0;
	out[638] = 0;
	out[639] = 0;
	out[640] = 0;
	out[641] = 0;
	out[642] = 0;
	out[643] = 0;
	out[644] = 1;
	out[645] = 0;
	out[646] = 0;
	out[647] = 0;
	out[648] = 0;
	out[649] = 0;
	out[650] = 0;
	out[651] = 0;
	out[652] = 0;
	out[653] = 0;
	out[654] = 0;
	out[655] = 0;
	out[656] = 0;
	out[657] = 0;
	out[658] = 0;
	out[659] = 0;
	out[660] = 0;
	out[661] = 0;
	out[662] = 0;
	out[663] = 0;
	out[664] = 0;
	out[665] = 0;
	out[666] = 0;
	out[667] = 0;
	out[668] = 0;
	out[669] = 0;
	out[670] = 0;
	out[671] = 0;
	out[672] = 1;
	out[673] = 0;
	out[674] = 0;
	out[675] = 0;
	out[676] = 0;
	out[677] = 0;
	out[678] = 0;
	out[679] = 0;
	out[680] = 0;
	out[681] = 0;
	out[682] = 0;
	out[683] = 0;
	out[684] = 0;
	out[685] = 0;
	out[686] = 0;
	out[687] = 0;
	out[688] = 0;
	out[689] = 0;
	out[690] = 0;
	out[691] = 0;
	out[692] = 0;
	out[693] = 0;
	out[694] = 0;
	out[695] = 0;
	out[696] = 0;
	out[697] = 0;
	out[698] = 0;
	out[699] = 0;
	out[700] = 1;
	out[701] = 0;
	out[702] = 0;
	out[703] = 0;
	out[704] = 0;
	out[705] = 0;
	out[706] = 0;
	out[707] = 0;
	out[708] = 0;
	out[709] = 0;
	out[710] = 0;
	out[711] = 0;
	out[712] = 0;
	out[713] = 0;
	out[714] = 0;
	out[715] = 0;
	out[716] = 0;
	out[717] = 0;
	out[718] = 0;
	out[719] = 0;
	out[720] = 0;
	out[721] = 0;
	out[722] = 0;
	out[723] = 0;
	out[724] = 0;
	out[725] = 0;
	out[726] = 0;
	out[727] = 0;
	out[728] = 1;
}

static inline void gen_imu_rot_f_aa(FLT* out, const FLT time, const FLT* imu_rot_aa) {
	const GEN_FLT aa_x = imu_rot_aa[0];
	const GEN_FLT aa_y = imu_rot_aa[1];
	const GEN_FLT aa_z = imu_rot_aa[2];
	const GEN_FLT lh_qi = imu_rot_aa[3];
	const GEN_FLT lh_qj = imu_rot_aa[4];
	const GEN_FLT lh_qk = imu_rot_aa[5];
	const GEN_FLT x0 = aa_z * aa_z;
	const GEN_FLT x1 = aa_x * aa_x;
	const GEN_FLT x2 = aa_y * aa_y;
	const GEN_FLT x3 = 1e-10 + x2 + x0 + x1;
	const GEN_FLT x4 = sqrt(x3);
	const GEN_FLT x5 = 0.5 * x4;
	const GEN_FLT x6 = sin(x5);
	const GEN_FLT x7 = (1. / x4) * x6;
	const GEN_FLT x8 = time * time;
	const GEN_FLT x9 = x8 * (lh_qk * lh_qk);
	const GEN_FLT x10 = x8 * (lh_qi * lh_qi);
	const GEN_FLT x11 = x8 * (lh_qj * lh_qj);
	const GEN_FLT x12 = 1e-10 + x11 + x9 + x10;
	const GEN_FLT x13 = sqrt(x12);
	const GEN_FLT x14 = 0.5 * x13;
	const GEN_FLT x15 = sin(x14);
	const GEN_FLT x16 = (x15 * x15) * (1. / x12);
	const GEN_FLT x17 = cos(x14);
	const GEN_FLT x18 = (1. / x3) * (x6 * x6);
	const GEN_FLT x19 = cos(x5);
	const GEN_FLT x20 = (1. / sqrt(1e-11 + (x19 * x19) + (x0 * x18) + (x1 * x18) + (x2 * x18))) * (1. / sqrt(1e-11 + (x9 * x16) + (x10 * x16) + (x17 * x17) + (x11 * x16)));
	const GEN_FLT x21 = x20 * x15 * (1. / x13) * time;
	const GEN_FLT x22 = x7 * x21;
	const GEN_FLT x23 = x22 * aa_y;
	const GEN_FLT x24 = x20 * x17;
	const GEN_FLT x25 = x7 * x24;
	const GEN_FLT x26 = x22 * aa_z;
	const GEN_FLT x27 = x21 * x19;
	const GEN_FLT x28 = (x26 * lh_qj) + (x27 * lh_qi) + (-1 * x23 * lh_qk) + (x25 * aa_x);
	const GEN_FLT x29 = x22 * aa_x;
	const GEN_FLT x30 = (x23 * lh_qi) + (x25 * aa_z) + (x27 * lh_qk) + (-1 * x29 * lh_qj);
	const GEN_FLT x31 = (-1 * x26 * lh_qi) + (x29 * lh_qk) + (x25 * aa_y) + (x27 * lh_qj);
	const GEN_FLT x32 = sqrt(1e-10 + (x30 * x30) + (x31 * x31) + (x28 * x28));
	const GEN_FLT x33 = 2 * (1. / x32) * atan2(x32, (x24 * x19) + (-1 * x29 * lh_qi) + (-1 * x26 * lh_qk) + (-1 * x23 * lh_qj));
	out[0] = x33 * x28;
	out[1] = x31 * x33;
	out[2] = x30 * x33;
	out[3] = lh_qi;
	out[4] = lh_qj;
	out[5] = lh_qk;
}

// Jacobian of imu_rot_f_aa wrt [time]
static inline void gen_imu_rot_f_aa_jac_time(FLT* out, const FLT time, const FLT* imu_rot_aa) {
	const GEN_FLT aa_x = imu_rot_aa[0];
	const GEN_FLT aa_y = imu_rot_aa[1];
	const GEN_FLT aa_z = imu_rot_aa[2];
	const GEN_FLT lh_qi = imu_rot_aa[3];
	const GEN_FLT lh_qj = imu_rot_aa[4];
	const GEN_FLT lh_qk = imu_rot_aa[5];
	const GEN_FLT x0 = time * time;
	const GEN_FLT x1 = lh_qk * lh_qk;
	const GEN_FLT x2 = x0 * x1;
	const GEN_FLT x3 = lh_qi * lh_qi;
	const GEN_FLT x4 = x0 * x3;
	const GEN_FLT x5 = lh_qj * lh_qj;
	const GEN_FLT x6 = x0 * x5;
	const GEN_FLT x7 = 1e-10 + x6 + x2 + x4;
	const GEN_FLT x8 = sqrt(x7);
	const GEN_FLT x9 = 0.5 * x8;
	const GEN_FLT x10 = sin(x9);
	const GEN_FLT x11 = (1. / x8) * x10;
	const GEN_FLT x12 = x10 * x10;
	const GEN_FLT x13 = 1. / x7;
	const GEN_FLT x14 = x13 * x12;
	const GEN_FLT x15 = cos(x9);
	const GEN_FLT x16 = 1e-11 + (x4 * x14) + (x15 * x15) + (x2 * x14) + (x6 * x14);
	const GEN_FLT x17 = aa_z * aa_z;
	const GEN_FLT x18 = aa_x * aa_x;
	const GEN_FLT x19 = aa_y * aa_y;
	const GEN_FLT x20 = 1e-10 + x19 + x17 + x18;
	const GEN_FLT x21 = sqrt(x20);
	const GEN_FLT x22 = 0.5 * x21;
	const GEN_FLT x23 = sin(x22);
	const GEN_FLT x24 = (x23 * x23) * (1. / x20);
	const GEN_FLT x25 = cos(x22);
	const GEN_FLT x26 = 1. / sqrt(1e-11 + (x24 * x18) + (x25 * x25) + (x24 * x17) + (x24 * x19));
	const GEN_FLT x27 = x26 * (1. / sqrt(x16));
	const GEN_FLT x28 = x23 * (1. / x21);
	const GEN_FLT x29 = x28 * x27;
	const GEN_FLT x30 = x29 * x11;
	const GEN_FLT x31 = x30 * lh_qk;
	const GEN_FLT x32 = x31 * aa_y;
	const GEN_FLT x33 = x29 * x15;
	const GEN_FLT x34 = x30 * lh_qj;
	const GEN_FLT x35 = x34 * aa_z;
	const GEN_FLT x36 = x25 * x27;
	const GEN_FLT x37 = x36 * x11;
	const GEN_FLT x38 = x37 * lh_qi;
	const GEN_FLT x39 = (x38 * time) + (x35 * time) + (-1 * x32 * time) + (x33 * aa_x);
	const GEN_FLT x40 = x37 * lh_qk;
	const GEN_FLT x41 = x34 * aa_x;
	const GEN_FLT x42 = x30 * lh_qi;
	const GEN_FLT x43 = x42 * aa_y;
	const GEN_FLT x44 = (x40 * time) + (x43 * time) + (x33 * aa_z) + (-1 * x41 * time);
	const GEN_FLT x45 = x31 * aa_x;
	const GEN_FLT x46 = x37 * lh_qj;
	const GEN_FLT x47 = x42 * aa_z;
	const GEN_FLT x48 = (x33 * aa_y) + (-1 * x47 * time) + (x45 * time) + (x46 * time);
	const GEN_FLT x49 = 1e-10 + (x48 * x48) + (x44 * x44) + (x39 * x39);
	const GEN_FLT x50 = sqrt(x49);
	const GEN_FLT x51 = 1. / x50;
	const GEN_FLT x52 = x31 * aa_z;
	const GEN_FLT x53 = x34 * aa_y;
	const GEN_FLT x54 = x36 * x15;
	const GEN_FLT x55 = x42 * aa_x;
	const GEN_FLT x56 = (-1 * x55 * time) + x54 + (-1 * x52 * time) + (-1 * x53 * time);
	const GEN_FLT x57 = x56 * x56;
	const GEN_FLT x58 = 2 * time;
	const GEN_FLT x59 = x5 * x58;
	const GEN_FLT x60 = x1 * x58;
	const GEN_FLT x61 = x3 * x58;
	const GEN_FLT x62 = x59 + x61 + x60;
	const GEN_FLT x63 = x62 * x15;
	const GEN_FLT x64 = 0.25 * x63 * x29 * x13;
	const GEN_FLT x65 = time * lh_qi;
	const GEN_FLT x66 = x65 * aa_x;
	const GEN_FLT x67 = (1. / (x7 * sqrt(x7))) * x10;
	const GEN_FLT x68 = 1.0/2.0 * x62 * x67;
	const GEN_FLT x69 = x68 * x29;
	const GEN_FLT x70 = time * lh_qk;
	const GEN_FLT x71 = x70 * aa_z;
	const GEN_FLT x72 = 0.5 * x63;
	const GEN_FLT x73 = x72 * x67;
	const GEN_FLT x74 = x6 * x62;
	const GEN_FLT x75 = (1. / (x7 * x7)) * x12;
	const GEN_FLT x76 = x75 * x62;
	const GEN_FLT x77 = 1.0/2.0 * x26 * (1. / (x16 * sqrt(x16))) * ((x2 * x73) + (-1 * x2 * x76) + (-1 * x4 * x76) + (x61 * x14) + (x60 * x14) + (x59 * x14) + (x4 * x73) + (-1 * x75 * x74) + (-1 * x72 * x11) + (0.5 * x74 * x67 * x15));
	const GEN_FLT x78 = x77 * x11;
	const GEN_FLT x79 = x78 * x28;
	const GEN_FLT x80 = time * lh_qj;
	const GEN_FLT x81 = x80 * aa_y;
	const GEN_FLT x82 = x79 * aa_y;
	const GEN_FLT x83 = x77 * x15;
	const GEN_FLT x84 = x79 * x65;
	const GEN_FLT x85 = 0.25 * x62;
	const GEN_FLT x86 = x65 * aa_z;
	const GEN_FLT x87 = x70 * aa_x;
	const GEN_FLT x88 = x85 * x54 * x13;
	const GEN_FLT x89 = x78 * x25;
	const GEN_FLT x90 = x83 * x28;
	const GEN_FLT x91 = x68 * x36;
	const GEN_FLT x92 = x85 * x30;
	const GEN_FLT x93 = 2 * ((x86 * x69) + x46 + (-1 * x80 * x89) + (-1 * x47) + (-1 * x87 * x79) + (-1 * x86 * x64) + (x80 * x88) + (x87 * x64) + (-1 * x92 * aa_y) + (x84 * aa_z) + (-1 * x90 * aa_y) + (-1 * x80 * x91) + x45 + (-1 * x87 * x69));
	const GEN_FLT x94 = x65 * aa_y;
	const GEN_FLT x95 = x80 * aa_x;
	const GEN_FLT x96 = 2 * ((-1 * x69 * x94) + x40 + (x88 * x70) + (-1 * x82 * x65) + (x64 * x94) + (x69 * x95) + x43 + (-1 * x89 * x70) + (-1 * x64 * x95) + (x79 * x95) + (-1 * x90 * aa_z) + (-1 * x41) + (-1 * x70 * x91) + (-1 * x92 * aa_z));
	const GEN_FLT x97 = x70 * aa_y;
	const GEN_FLT x98 = x80 * aa_z;
	const GEN_FLT x99 = 2 * ((-1 * x92 * aa_x) + x35 + (-1 * x65 * x91) + (-1 * x79 * x98) + (x88 * x65) + x38 + (-1 * x32) + (x79 * x97) + (-1 * x89 * x65) + (-1 * x90 * aa_x) + (-1 * x69 * x98) + (x64 * x98) + (-1 * x64 * x97) + (x69 * x97));
	const GEN_FLT x100 = (x99 * x39) + (x93 * x48) + (x96 * x44);
	const GEN_FLT x101 = 2 * (1. / (x49 + x57)) * x51 * x57 * ((1.0/2.0 * x51 * (1. / x56) * x100) + (-1 * x50 * (1. / x57) * ((-1 * x85 * x37) + (x84 * aa_x) + (-1 * x83 * x25) + (x71 * x69) + (x66 * x69) + (x81 * x69) + (-1 * x71 * x64) + (-1 * x52) + (-1 * x81 * x64) + (-1 * x64 * x66) + (x71 * x79) + (-1 * x55) + (-1 * x53) + (x80 * x82))));
	const GEN_FLT x102 = atan2(x50, x56);
	const GEN_FLT x103 = (1. / (x49 * sqrt(x49))) * x100 * x102;
	const GEN_FLT x104 = x51 * x102;
	out[0] = (x99 * x104) + (x39 * x101) + (-1 * x39 * x103);
	out[1] = (x93 * x104) + (x48 * x101) + (-1 * x48 * x103);
	out[2] = (x96 * x104) + (x44 * x101) + (-1 * x44 * x103);
	out[3] = 0;
	out[4] = 0;
	out[5] = 0;
}

// Jacobian of imu_rot_f_aa wrt [aa_x, aa_y, aa_z, lh_qi, lh_qj, lh_qk]
static inline void gen_imu_rot_f_aa_jac_imu_rot_aa(FLT* out, const FLT time, const FLT* imu_rot_aa) {
	const GEN_FLT aa_x = imu_rot_aa[0];
	const GEN_FLT aa_y = imu_rot_aa[1];
	const GEN_FLT aa_z = imu_rot_aa[2];
	const GEN_FLT lh_qi = imu_rot_aa[3];
	const GEN_FLT lh_qj = imu_rot_aa[4];
	const GEN_FLT lh_qk = imu_rot_aa[5];
	const GEN_FLT x0 = time * time;
	const GEN_FLT x1 = lh_qk * lh_qk;
	const GEN_FLT x2 = x0 * x1;
	const GEN_FLT x3 = lh_qi * lh_qi;
	const GEN_FLT x4 = x0 * x3;
	const GEN_FLT x5 = lh_qj * lh_qj;
	const GEN_FLT x6 = x0 * x5;
	const GEN_FLT x7 = 1e-10 + x6 + x2 + x4;
	const GEN_FLT x8 = sqrt(x7);
	const GEN_FLT x9 = 0.5 * x8;
	const GEN_FLT x10 = sin(x9);
	const GEN_FLT x11 = x10 * x10;
	const GEN_FLT x12 = 1. / x7;
	const GEN_FLT x13 = x12 * x11;
	const GEN_FLT x14 = cos(x9);
	const GEN_FLT x15 = 1e-11 + (x4 * x13) + (x14 * x14) + (x2 * x13) + (x6 * x13);
	const GEN_FLT x16 = 1. / sqrt(x15);
	const GEN_FLT x17 = aa_z * aa_z;
	const GEN_FLT x18 = aa_x * aa_x;
	const GEN_FLT x19 = aa_y * aa_y;
	const GEN_FLT x20 = 1e-10 + x19 + x17 + x18;
	const GEN_FLT x21 = sqrt(x20);
	const GEN_FLT x22 = 0.5 * x21;
	const GEN_FLT x23 = sin(x22);
	const GEN_FLT x24 = x23 * (1. / x21);
	const GEN_FLT x25 = x24 * x16;
	const GEN_FLT x26 = 1. / x20;
	const GEN_FLT x27 = x23 * x23;
	const GEN_FLT x28 = x26 * x27;
	const GEN_FLT x29 = cos(x22);
	const GEN_FLT x30 = 1e-11 + (x28 * x18) + (x28 * x17) + (x29 * x29) + (x28 * x19);
	const GEN_FLT x31 = 1. / sqrt(x30);
	const GEN_FLT x32 = (1. / x8) * x10;
	const GEN_FLT x33 = x32 * time;
	const GEN_FLT x34 = x31 * x33;
	const GEN_FLT x35 = x34 * x25;
	const GEN_FLT x36 = x35 * lh_qi;
	const GEN_FLT x37 = -1 * x36;
	const GEN_FLT x38 = x25 * aa_y;
	const GEN_FLT x39 = 2 * x28;
	const GEN_FLT x40 = 2 * (1. / (x20 * x20)) * x27;
	const GEN_FLT x41 = x40 * x17;
	const GEN_FLT x42 = aa_x * aa_x * aa_x;
	const GEN_FLT x43 = 1.0 * x29;
	const GEN_FLT x44 = x23 * (1. / (x20 * sqrt(x20)));
	const GEN_FLT x45 = x43 * x44;
	const GEN_FLT x46 = x43 * x24;
	const GEN_FLT x47 = x45 * x17;
	const GEN_FLT x48 = x19 * aa_x;
	const GEN_FLT x49 = (x45 * x48) + (-1 * x40 * x42) + (-1 * x40 * x48) + (-1 * x41 * aa_x) + (x39 * aa_x) + (x42 * x45) + (-1 * x46 * aa_x) + (x47 * aa_x);
	const GEN_FLT x50 = 1.0/2.0 * (1. / (x30 * sqrt(x30)));
	const GEN_FLT x51 = x50 * x33;
	const GEN_FLT x52 = x51 * x49;
	const GEN_FLT x53 = x52 * x38;
	const GEN_FLT x54 = x25 * aa_x;
	const GEN_FLT x55 = x52 * lh_qi;
	const GEN_FLT x56 = x29 * x16;
	const GEN_FLT x57 = x56 * x31;
	const GEN_FLT x58 = x57 * x33;
	const GEN_FLT x59 = x58 * lh_qk;
	const GEN_FLT x60 = aa_x * aa_z;
	const GEN_FLT x61 = 0.5 * x26;
	const GEN_FLT x62 = x60 * x61;
	const GEN_FLT x63 = x62 * x59;
	const GEN_FLT x64 = x44 * x16;
	const GEN_FLT x65 = x64 * x18;
	const GEN_FLT x66 = x34 * lh_qi;
	const GEN_FLT x67 = x25 * aa_z;
	const GEN_FLT x68 = x67 * lh_qk;
	const GEN_FLT x69 = x50 * x14;
	const GEN_FLT x70 = x69 * x56;
	const GEN_FLT x71 = x34 * lh_qk;
	const GEN_FLT x72 = x60 * x64;
	const GEN_FLT x73 = x71 * x72;
	const GEN_FLT x74 = x31 * x14;
	const GEN_FLT x75 = x74 * x16;
	const GEN_FLT x76 = x75 * x24;
	const GEN_FLT x77 = x76 * aa_x;
	const GEN_FLT x78 = 0.5 * x77;
	const GEN_FLT x79 = x58 * lh_qi;
	const GEN_FLT x80 = x61 * x18;
	const GEN_FLT x81 = x64 * aa_y;
	const GEN_FLT x82 = x34 * lh_qj;
	const GEN_FLT x83 = x82 * aa_x;
	const GEN_FLT x84 = x58 * lh_qj;
	const GEN_FLT x85 = x84 * x61;
	const GEN_FLT x86 = x85 * aa_y;
	const GEN_FLT x87 = (-1 * x86 * aa_x) + (x81 * x83);
	const GEN_FLT x88 = x35 * lh_qj;
	const GEN_FLT x89 = x88 * aa_x;
	const GEN_FLT x90 = x76 * aa_z;
	const GEN_FLT x91 = x36 * aa_y;
	const GEN_FLT x92 = x90 + x59 + x91 + (-1 * x89);
	const GEN_FLT x93 = x35 * aa_y;
	const GEN_FLT x94 = x93 * lh_qk;
	const GEN_FLT x95 = x67 * x34;
	const GEN_FLT x96 = x95 * lh_qj;
	const GEN_FLT x97 = x79 + x96 + (-1 * x94) + x77;
	const GEN_FLT x98 = x35 * lh_qk;
	const GEN_FLT x99 = x98 * aa_x;
	const GEN_FLT x100 = x76 * aa_y;
	const GEN_FLT x101 = x95 * lh_qi;
	const GEN_FLT x102 = x100 + (-1 * x101) + x99 + x84;
	const GEN_FLT x103 = 1e-10 + (x102 * x102) + (x92 * x92) + (x97 * x97);
	const GEN_FLT x104 = sqrt(x103);
	const GEN_FLT x105 = x95 * lh_qk;
	const GEN_FLT x106 = x88 * aa_y;
	const GEN_FLT x107 = x74 * x56;
	const GEN_FLT x108 = x36 * aa_x;
	const GEN_FLT x109 = (-1 * x108) + x107 + (-1 * x105) + (-1 * x106);
	const GEN_FLT x110 = x109 * x109;
	const GEN_FLT x111 = x104 * (1. / x110);
	const GEN_FLT x112 = x51 * x56;
	const GEN_FLT x113 = x112 * lh_qj;
	const GEN_FLT x114 = x54 * x52;
	const GEN_FLT x115 = x69 * x25;
	const GEN_FLT x116 = x115 * aa_y;
	const GEN_FLT x117 = (x72 * x66) + (-1 * x79 * x62);
	const GEN_FLT x118 = x75 * x44;
	const GEN_FLT x119 = x118 * aa_y;
	const GEN_FLT x120 = 0.5 * x107;
	const GEN_FLT x121 = x26 * x120;
	const GEN_FLT x122 = x121 * aa_y;
	const GEN_FLT x123 = (x122 * aa_x) + (-1 * x119 * aa_x);
	const GEN_FLT x124 = x117 + (-1 * x49 * x116) + x98 + x123 + (-0.5 * x89) + (-1 * x49 * x113) + (-1 * x114 * lh_qk) + (-1 * x71 * x65) + (x67 * x55) + (x80 * x59);
	const GEN_FLT x125 = 2 * x102;
	const GEN_FLT x126 = x112 * lh_qk;
	const GEN_FLT x127 = x67 * x69;
	const GEN_FLT x128 = x81 * aa_x;
	const GEN_FLT x129 = x66 * x128;
	const GEN_FLT x130 = x61 * aa_y;
	const GEN_FLT x131 = x130 * aa_x;
	const GEN_FLT x132 = x79 * x131;
	const GEN_FLT x133 = -1 * x88;
	const GEN_FLT x134 = (x60 * x121) + (-1 * x60 * x118);
	const GEN_FLT x135 = x132 + (-1 * x129) + (-1 * x49 * x127) + (x82 * x65) + (-1 * x55 * x38) + (-1 * x85 * x18) + x133 + (-0.5 * x99) + (-1 * x49 * x126) + x134 + (x114 * lh_qj);
	const GEN_FLT x136 = 2 * x92;
	const GEN_FLT x137 = x85 * x60;
	const GEN_FLT x138 = x59 * x131;
	const GEN_FLT x139 = x112 * lh_qi;
	const GEN_FLT x140 = x115 * aa_x;
	const GEN_FLT x141 = x82 * x72;
	const GEN_FLT x142 = x71 * x128;
	const GEN_FLT x143 = (-1 * x18 * x118) + (-1 * x49 * x139) + (-1 * x141) + (x53 * lh_qk) + (-0.5 * x108) + x137 + (x18 * x121) + x142 + (-1 * x67 * x52 * lh_qj) + (-1 * x49 * x140) + (-1 * x138) + x76;
	const GEN_FLT x144 = 2 * x97;
	const GEN_FLT x145 = (x124 * x125) + (x144 * x143) + (x135 * x136);
	const GEN_FLT x146 = 1. / x104;
	const GEN_FLT x147 = 1.0/2.0 * (1. / x109) * x146;
	const GEN_FLT x148 = (x145 * x147) + (-1 * x111 * ((-1 * x80 * x79) + (-1 * x70 * x49) + (x68 * x52) + x87 + (x53 * lh_qj) + (-1 * x78) + x37 + x73 + (x54 * x55) + (-1 * x63) + (x65 * x66)));
	const GEN_FLT x149 = (1. / (x103 + x110)) * x110 * x146;
	const GEN_FLT x150 = x144 * x149;
	const GEN_FLT x151 = atan2(x104, x109);
	const GEN_FLT x152 = (1. / (x103 * sqrt(x103))) * x151;
	const GEN_FLT x153 = x97 * x152;
	const GEN_FLT x154 = 2 * x146 * x151;
	const GEN_FLT x155 = x18 * aa_y;
	const GEN_FLT x156 = aa_y * aa_y * aa_y;
	const GEN_FLT x157 = (x39 * aa_y) + (-1 * x40 * x155) + (x47 * aa_y) + (-1 * x46 * aa_y) + (x45 * x156) + (-1 * x40 * x156) + (x45 * x155) + (-1 * x41 * aa_y);
	const GEN_FLT x158 = x51 * x157;
	const GEN_FLT x159 = x38 * x158;
	const GEN_FLT x160 = x61 * x19;
	const GEN_FLT x161 = 0.5 * x100;
	const GEN_FLT x162 = x64 * x19;
	const GEN_FLT x163 = x54 * x158;
	const GEN_FLT x164 = x130 * aa_z;
	const GEN_FLT x165 = x81 * aa_z;
	const GEN_FLT x166 = (x71 * x165) + (-1 * x59 * x164);
	const GEN_FLT x167 = x79 * x164;
	const GEN_FLT x168 = x67 * x158;
	const GEN_FLT x169 = x112 * x157;
	const GEN_FLT x170 = x115 * x157;
	const GEN_FLT x171 = x66 * x165;
	const GEN_FLT x172 = (x168 * lh_qi) + x171 + (-1 * x167) + (-0.5 * x106) + (-1 * x169 * lh_qj) + (x19 * x121) + x138 + x76 + (-1 * x19 * x118) + (-1 * x170 * aa_y) + (-1 * x142) + (-1 * x163 * lh_qk);
	const GEN_FLT x173 = (x122 * aa_z) + (-1 * x119 * aa_z);
	const GEN_FLT x174 = x173 + x87 + (x79 * x160) + x36 + (x163 * lh_qj) + (-1 * x127 * x157) + (-1 * x66 * x162) + (-1 * x159 * lh_qi) + (-1 * x169 * lh_qk) + (-0.5 * x94);
	const GEN_FLT x175 = -1 * x98;
	const GEN_FLT x176 = x82 * x165;
	const GEN_FLT x177 = x86 * aa_z;
	const GEN_FLT x178 = (-1 * x169 * lh_qi) + (-1 * x170 * aa_x) + x177 + (-1 * x168 * lh_qj) + (-1 * x176) + (-0.5 * x91) + (x159 * lh_qk) + (-1 * x59 * x160) + x123 + x175 + (x71 * x162);
	const GEN_FLT x179 = (x125 * x172) + (x178 * x144) + (x174 * x136);
	const GEN_FLT x180 = (x179 * x147) + (-1 * x111 * (x166 + x129 + (x159 * lh_qj) + (-1 * x132) + (-1 * x161) + (x68 * x158) + (-1 * x70 * x157) + (x163 * lh_qi) + (x82 * x162) + x133 + (-1 * x84 * x160)));
	const GEN_FLT x181 = x64 * x17;
	const GEN_FLT x182 = x61 * x17;
	const GEN_FLT x183 = x40 * aa_z;
	const GEN_FLT x184 = x45 * aa_z;
	const GEN_FLT x185 = aa_z * aa_z * aa_z;
	const GEN_FLT x186 = (x19 * x184) + (-1 * x40 * x185) + (-1 * x19 * x183) + (x18 * x184) + (-1 * x18 * x183) + (x39 * aa_z) + (-1 * x46 * aa_z) + (x45 * x185);
	const GEN_FLT x187 = x51 * x186;
	const GEN_FLT x188 = x187 * lh_qk;
	const GEN_FLT x189 = x187 * lh_qi;
	const GEN_FLT x190 = x37 + x173 + (-1 * x54 * x188) + (-1 * x113 * x186) + (x67 * x189) + (-0.5 * x96) + (x66 * x181) + (-1 * x116 * x186) + x63 + (-1 * x73) + (-1 * x79 * x182);
	const GEN_FLT x191 = x187 * lh_qj;
	const GEN_FLT x192 = (-1 * x127 * x186) + (-0.5 * x105) + (-1 * x126 * x186) + x76 + (-1 * x171) + x167 + (x54 * x191) + (-1 * x137) + (x17 * x121) + (-1 * x17 * x118) + (-1 * x38 * x189) + x141;
	const GEN_FLT x193 = (-1 * x186 * x139) + x166 + (-1 * x67 * x191) + x134 + (-1 * x82 * x181) + (-0.5 * x101) + x88 + (x85 * x17) + (-1 * x186 * x140) + (x38 * x188);
	const GEN_FLT x194 = (x193 * x144) + (x125 * x190) + (x192 * x136);
	const GEN_FLT x195 = 0.5 * x90;
	const GEN_FLT x196 = (x194 * x147) + (-1 * x111 * (x117 + (x54 * x189) + (-1 * x70 * x186) + (-1 * x195) + (-1 * x177) + x176 + (-1 * x59 * x182) + (x38 * x191) + (x71 * x181) + (x68 * x187) + x175));
	const GEN_FLT x197 = time * time * time;
	const GEN_FLT x198 = x3 * x197;
	const GEN_FLT x199 = x12 * x195;
	const GEN_FLT x200 = time * time * time * time;
	const GEN_FLT x201 = x200 * (lh_qi * lh_qi * lh_qi);
	const GEN_FLT x202 = 1.0 * x14;
	const GEN_FLT x203 = (1. / (x7 * sqrt(x7))) * x10;
	const GEN_FLT x204 = x202 * x203;
	const GEN_FLT x205 = (1. / (x7 * x7)) * x11;
	const GEN_FLT x206 = 2 * x205;
	const GEN_FLT x207 = x0 * x13;
	const GEN_FLT x208 = 2 * x207;
	const GEN_FLT x209 = x200 * x206;
	const GEN_FLT x210 = x200 * x204;
	const GEN_FLT x211 = x1 * x210;
	const GEN_FLT x212 = x1 * x209;
	const GEN_FLT x213 = x0 * x32;
	const GEN_FLT x214 = x213 * x202;
	const GEN_FLT x215 = x5 * x200;
	const GEN_FLT x216 = x215 * x204;
	const GEN_FLT x217 = (-1 * x214 * lh_qi) + (-1 * x212 * lh_qi) + (x216 * lh_qi) + (-1 * x201 * x206) + (x201 * x204) + (x211 * lh_qi) + (x208 * lh_qi) + (-1 * x5 * x209 * lh_qi);
	const GEN_FLT x218 = 1.0/2.0 * (1. / (x15 * sqrt(x15)));
	const GEN_FLT x219 = x24 * x218;
	const GEN_FLT x220 = x71 * x219;
	const GEN_FLT x221 = x217 * x220;
	const GEN_FLT x222 = x78 * x12;
	const GEN_FLT x223 = lh_qk * lh_qi;
	const GEN_FLT x224 = x223 * x197;
	const GEN_FLT x225 = x224 * x222;
	const GEN_FLT x226 = x31 * x203;
	const GEN_FLT x227 = x54 * x226;
	const GEN_FLT x228 = x224 * x227;
	const GEN_FLT x229 = x74 * x218;
	const GEN_FLT x230 = x24 * x229;
	const GEN_FLT x231 = x217 * x230;
	const GEN_FLT x232 = -1 * x95;
	const GEN_FLT x233 = x29 * x218;
	const GEN_FLT x234 = x217 * x233;
	const GEN_FLT x235 = x67 * x226;
	const GEN_FLT x236 = 0.5 * x213;
	const GEN_FLT x237 = x31 * x236;
	const GEN_FLT x238 = x38 * x237;
	const GEN_FLT x239 = x66 * x217;
	const GEN_FLT x240 = x219 * aa_z;
	const GEN_FLT x241 = x57 * x203;
	const GEN_FLT x242 = x241 * x197;
	const GEN_FLT x243 = x242 * lh_qj;
	const GEN_FLT x244 = x12 * x120;
	const GEN_FLT x245 = x244 * x197;
	const GEN_FLT x246 = x245 * lh_qj;
	const GEN_FLT x247 = (x246 * lh_qi) + (-1 * x243 * lh_qi);
	const GEN_FLT x248 = (x239 * x240) + (x235 * x198) + (-1 * x82 * x234) + x247 + x232 + (-1 * x238 * lh_qi) + (-1 * x221 * aa_x) + x225 + (-1 * x231 * aa_y) + (-1 * x198 * x199) + (-1 * x228);
	const GEN_FLT x249 = x38 * x226;
	const GEN_FLT x250 = x67 * x237;
	const GEN_FLT x251 = x12 * x161;
	const GEN_FLT x252 = x83 * x219;
	const GEN_FLT x253 = x219 * aa_y;
	const GEN_FLT x254 = (-1 * x223 * x242) + (x223 * x245);
	const GEN_FLT x255 = x197 * lh_qj;
	const GEN_FLT x256 = x255 * lh_qi;
	const GEN_FLT x257 = (-1 * x256 * x222) + (x256 * x227);
	const GEN_FLT x258 = x254 + x93 + (-1 * x231 * aa_z) + (-1 * x239 * x253) + x257 + (-1 * x250 * lh_qi) + (x251 * x198) + (-1 * x71 * x234) + (-1 * x249 * x198) + (x217 * x252);
	const GEN_FLT x259 = x71 * x253;
	const GEN_FLT x260 = x224 * x249;
	const GEN_FLT x261 = x251 * x224;
	const GEN_FLT x262 = x256 * x199;
	const GEN_FLT x263 = x82 * x240;
	const GEN_FLT x264 = x235 * x256;
	const GEN_FLT x265 = x54 * x237;
	const GEN_FLT x266 = (-1 * x66 * x234) + (-1 * x241 * x198) + (-1 * x231 * aa_x) + (-1 * x217 * x263) + (-1 * x264) + (x244 * x198) + (-1 * x265 * lh_qi) + x260 + (x217 * x259) + (-1 * x261) + x262 + x58;
	const GEN_FLT x267 = (x248 * x125) + (x266 * x144) + (x258 * x136);
	const GEN_FLT x268 = x267 * x152;
	const GEN_FLT x269 = x251 * x256;
	const GEN_FLT x270 = x256 * x249;
	const GEN_FLT x271 = x82 * x253;
	const GEN_FLT x272 = x29 * x229;
	const GEN_FLT x273 = x57 * x236;
	const GEN_FLT x274 = x35 * aa_x;
	const GEN_FLT x275 = -1 * x274;
	const GEN_FLT x276 = (x235 * x224) + (-1 * x224 * x199);
	const GEN_FLT x277 = (x267 * x147) + (-1 * x111 * ((-1 * x217 * x272) + (x219 * x239 * aa_x) + (x227 * x198) + (-1 * x273 * lh_qi) + (-1 * x269) + (x221 * aa_z) + x276 + x270 + x275 + (-1 * x222 * x198) + (x217 * x271)));
	const GEN_FLT x278 = -1 * x93;
	const GEN_FLT x279 = x3 * lh_qj;
	const GEN_FLT x280 = lh_qj * lh_qj * lh_qj;
	const GEN_FLT x281 = (x208 * lh_qj) + (-1 * x209 * x279) + (x211 * lh_qj) + (x210 * x280) + (-1 * x209 * x280) + (x210 * x279) + (-1 * x214 * lh_qj) + (-1 * x212 * lh_qj);
	const GEN_FLT x282 = x82 * x281;
	const GEN_FLT x283 = x5 * x197;
	const GEN_FLT x284 = x283 * x226;
	const GEN_FLT x285 = x281 * aa_z;
	const GEN_FLT x286 = x255 * lh_qk;
	const GEN_FLT x287 = x286 * x199;
	const GEN_FLT x288 = x66 * x219;
	const GEN_FLT x289 = x281 * aa_x;
	const GEN_FLT x290 = x235 * x286;
	const GEN_FLT x291 = x233 * x281;
	const GEN_FLT x292 = x286 * x227;
	const GEN_FLT x293 = x286 * x222;
	const GEN_FLT x294 = x230 * aa_y;
	const GEN_FLT x295 = (-1 * x294 * x281) + (-1 * x289 * x220) + (-1 * x292) + (-1 * x82 * x291) + (-1 * x262) + x293 + (-1 * x238 * lh_qj) + (x288 * x285) + (x283 * x244) + x264 + x58 + (-1 * x5 * x242);
	const GEN_FLT x296 = x66 * x253;
	const GEN_FLT x297 = x230 * aa_z;
	const GEN_FLT x298 = (-1 * x243 * lh_qk) + (x246 * lh_qk);
	const GEN_FLT x299 = x269 + (x281 * x252) + (-1 * x270) + x298 + (-1 * x71 * x291) + (-1 * x296 * x281) + x275 + (-1 * x297 * x281) + (-1 * x250 * lh_qj) + (x54 * x284) + (-1 * x283 * x222);
	const GEN_FLT x300 = x230 * aa_x;
	const GEN_FLT x301 = (x286 * x249) + (-1 * x286 * x251);
	const GEN_FLT x302 = x301 + x247 + (-1 * x67 * x284) + (-1 * x66 * x291) + (-1 * x282 * x240) + (-1 * x281 * x300) + (x283 * x199) + (x281 * x259) + (-1 * x265 * lh_qj) + x95;
	const GEN_FLT x303 = (x302 * x144) + (x295 * x125) + (x299 * x136);
	const GEN_FLT x304 = (x303 * x147) + (-1 * x111 * ((-1 * x273 * lh_qj) + (-1 * x283 * x251) + x257 + (x282 * x253) + x290 + (-1 * x272 * x281) + x278 + (x288 * x289) + (x285 * x220) + (-1 * x287) + (x38 * x284)));
	const GEN_FLT x305 = 2 * lh_qk;
	const GEN_FLT x306 = x205 * x305;
	const GEN_FLT x307 = x3 * x200;
	const GEN_FLT x308 = lh_qk * lh_qk * lh_qk;
	const GEN_FLT x309 = (x216 * lh_qk) + (-1 * x209 * x308) + (-1 * x215 * x306) + (x207 * x305) + (-1 * x307 * x306) + (x204 * x307 * lh_qk) + (-1 * x214 * lh_qk) + (x210 * x308);
	const GEN_FLT x310 = x309 * aa_x;
	const GEN_FLT x311 = x309 * aa_z;
	const GEN_FLT x312 = x1 * x197;
	const GEN_FLT x313 = x233 * x309;
	const GEN_FLT x314 = x261 + (-1 * x71 * x313) + (-1 * x296 * x309) + (-1 * x293) + x58 + (x1 * x245) + (-1 * x297 * x309) + (-1 * x1 * x242) + (-1 * x260) + x292 + (x252 * x309) + (-1 * x68 * x237);
	const GEN_FLT x315 = x298 + x276 + x274 + (x222 * x312) + (-1 * x227 * x312) + (-1 * x238 * lh_qk) + (x288 * x311) + (-1 * x82 * x313) + (-1 * x220 * x310) + (-1 * x294 * x309);
	const GEN_FLT x316 = (-1 * x66 * x313) + (-1 * x263 * x309) + x287 + (x249 * x312) + (-1 * x251 * x312) + (-1 * x265 * lh_qk) + (-1 * x290) + x278 + x254 + (x259 * x309) + (-1 * x309 * x300);
	const GEN_FLT x317 = (x316 * x144) + (x314 * x136) + (x315 * x125);
	const GEN_FLT x318 = (x317 * x147) + (-1 * x111 * (x301 + (x271 * x309) + (-1 * x273 * lh_qk) + (-1 * x272 * x309) + (x288 * x310) + (x220 * x311) + x232 + (-1 * x312 * x199) + (-1 * x225) + x228 + (x235 * x312)));
	const GEN_FLT x319 = x125 * x149;
	const GEN_FLT x320 = x102 * x152;
	const GEN_FLT x321 = x136 * x149;
	const GEN_FLT x322 = x92 * x152;
	out[0] = (x143 * x154) + (x148 * x150) + (-1 * x145 * x153);
	out[1] = (x178 * x154) + (x180 * x150) + (-1 * x179 * x153);
	out[2] = (x193 * x154) + (-1 * x194 * x153) + (x196 * x150);
	out[3] = (x266 * x154) + (-1 * x97 * x268) + (x277 * x150);
	out[4] = (x302 * x154) + (x304 * x150) + (-1 * x303 * x153);
	out[5] = (x316 * x154) + (x318 * x150) + (-1 * x317 * x153);
	out[6] = (x124 * x154) + (x319 * x148) + (-1 * x320 * x145);
	out[7] = (x172 * x154) + (x319 * x180) + (-1 * x320 * x179);
	out[8] = (x319 * x196) + (x190 * x154) + (-1 * x320 * x194);
	out[9] = (x277 * x319) + (x248 * x154) + (-1 * x268 * x102);
	out[10] = (x295 * x154) + (x304 * x319) + (-1 * x303 * x320);
	out[11] = (x315 * x154) + (x319 * x318) + (-1 * x320 * x317);
	out[12] = (x135 * x154) + (x321 * x148) + (-1 * x322 * x145);
	out[13] = (x174 * x154) + (x321 * x180) + (-1 * x322 * x179);
	out[14] = (x192 * x154) + (x321 * x196) + (-1 * x322 * x194);
	out[15] = (x258 * x154) + (x277 * x321) + (-1 * x92 * x268);
	out[16] = (x299 * x154) + (x304 * x321) + (-1 * x303 * x322);
	out[17] = (x314 * x154) + (x321 * x318) + (-1 * x322 * x317);
	out[18] = 0;
	out[19] = 0;
	out[20] = 0;
	out[21] = 1;
	out[22] = 0;
	out[23] = 0;
	out[24] = 0;
	out[25] = 0;
	out[26] = 0;
	out[27] = 0;
	out[28] = 1;
	out[29] = 0;
	out[30] = 0;
	out[31] = 0;
	out[32] = 0;
	out[33] = 0;
	out[34] = 0;
	out[35] = 1;
}

static inline void gen_imu_correct_up(FLT* out, const FLT mu, const FLT* imu_rot, const FLT* up_in_obj) {
	const GEN_FLT obj_qw = imu_rot[0];
	const GEN_FLT obj_qi = imu_rot[1];
	const GEN_FLT obj_qj = imu_rot[2];
	const GEN_FLT obj_qk = imu_rot[3];
	const GEN_FLT aa_x = imu_rot[4];
	const GEN_FLT aa_y = imu_rot[5];
	const GEN_FLT aa_z = imu_rot[6];
	const GEN_FLT obj_up_x = up_in_obj[0];
	const GEN_FLT obj_up_y = up_in_obj[1];
	const GEN_FLT obj_up_z = up_in_obj[2];
	const GEN_FLT x0 = (-1 * obj_qi * obj_up_z) + (obj_qw * obj_up_y) + (obj_qk * obj_up_x);
	const GEN_FLT x1 = (-1 * obj_qj * obj_up_x) + (obj_qw * obj_up_z) + (obj_qi * obj_up_y);
	const GEN_FLT x2 = obj_up_x + (2 * ((x1 * obj_qj) + (-1 * x0 * obj_qk)));
	const GEN_FLT x3 = x2 * x2;
	const GEN_FLT x4 = (-1 * obj_qk * obj_up_y) + (obj_qw * obj_up_x) + (obj_qj * obj_up_z);
	const GEN_FLT x5 = obj_up_y + (2 * ((x4 * obj_qk) + (-1 * x1 * obj_qi)));
	const GEN_FLT x6 = x5 * x5;
	const GEN_FLT x7 = atan2(sqrt(x3 + x6), obj_up_z + (2 * ((x0 * obj_qi) + (-1 * x4 * obj_qj))));
	const GEN_FLT x8 = 0.25 * (mu * mu) * (x7 * x7);
	const GEN_FLT x9 = x3 * x8;
	const GEN_FLT x10 = x6 * x8;
	const GEN_FLT x11 = 1e-10 + x10 + x9;
	const GEN_FLT x12 = sqrt(x11);
	const GEN_FLT x13 = 0.5 * x12;
	const GEN_FLT x14 = sin(x13);
	const GEN_FLT x15 = (x14 * x14) * (1. / x11);
	const GEN_FLT x16 = cos(x13);
	const GEN_FLT x17 = 1. / sqrt(1e-11 + (x15 * x10) + (x9 * x15) + (x16 * x16));
	const GEN_FLT x18 = 0.5 * mu * x7 * x14 * (1. / x12) * x17;
	const GEN_FLT x19 = x2 * x18;
	const GEN_FLT x20 = x17 * x16;
	const GEN_FLT x21 = x5 * x18;
	const GEN_FLT x22 = x18 * obj_qw;
	out[0] = (x19 * obj_qj) + (-1 * x21 * obj_qi) + (x20 * obj_qw);
	out[1] = (x5 * x22) + (-1 * x19 * obj_qk) + (x20 * obj_qi);
	out[2] = (-1 * x2 * x22) + (-1 * x21 * obj_qk) + (x20 * obj_qj);
	out[3] = (x21 * obj_qj) + (x19 * obj_qi) + (x20 * obj_qk);
	out[4] = aa_x;
	out[5] = aa_y;
	out[6] = aa_z;
}

// Jacobian of imu_correct_up wrt [mu]
static inline void gen_imu_correct_up_jac_mu(FLT* out, const FLT mu, const FLT* imu_rot, const FLT* up_in_obj) {
	const GEN_FLT obj_qw = imu_rot[0];
	const GEN_FLT obj_qi = imu_rot[1];
	const GEN_FLT obj_qj = imu_rot[2];
	const GEN_FLT obj_qk = imu_rot[3];
	const GEN_FLT aa_x = imu_rot[4];
	const GEN_FLT aa_y = imu_rot[5];
	const GEN_FLT aa_z = imu_rot[6];
	const GEN_FLT obj_up_x = up_in_obj[0];
	const GEN_FLT obj_up_y = up_in_obj[1];
	const GEN_FLT obj_up_z = up_in_obj[2];
	const GEN_FLT x0 = mu * mu;
	const GEN_FLT x1 = 0.25 * x0;
	const GEN_FLT x2 = (-1 * obj_qj * obj_up_x) + (obj_qw * obj_up_z) + (obj_qi * obj_up_y);
	const GEN_FLT x3 = (-1 * obj_qk * obj_up_y) + (obj_qw * obj_up_x) + (obj_qj * obj_up_z);
	const GEN_FLT x4 = obj_up_y + (2 * ((x3 * obj_qk) + (-1 * x2 * obj_qi)));
	const GEN_FLT x5 = x4 * x4;
	const GEN_FLT x6 = (-1 * obj_qi * obj_up_z) + (obj_qw * obj_up_y) + (obj_qk * obj_up_x);
	const GEN_FLT x7 = obj_up_x + (2 * ((x2 * obj_qj) + (-1 * x6 * obj_qk)));
	const GEN_FLT x8 = x7 * x7;
	const GEN_FLT x9 = atan2(sqrt(x8 + x5), obj_up_z + (2 * ((x6 * obj_qi) + (-1 * x3 * obj_qj))));
	const GEN_FLT x10 = x9 * x9;
	const GEN_FLT x11 = x8 * x10;
	const GEN_FLT x12 = x1 * x11;
	const GEN_FLT x13 = x5 * x10;
	const GEN_FLT x14 = x1 * x13;
	const GEN_FLT x15 = 1e-10 + x14 + x12;
	const GEN_FLT x16 = 1. / x15;
	const GEN_FLT x17 = sqrt(x15);
	const GEN_FLT x18 = 0.5 * x17;
	const GEN_FLT x19 = sin(x18);
	const GEN_FLT x20 = x19 * x19;
	const GEN_FLT x21 = x20 * x16;
	const GEN_FLT x22 = cos(x18);
	const GEN_FLT x23 = 1e-11 + (x21 * x14) + (x21 * x12) + (x22 * x22);
	const GEN_FLT x24 = 1. / sqrt(x23);
	const GEN_FLT x25 = 1. / x17;
	const GEN_FLT x26 = x25 * x19;
	const GEN_FLT x27 = 0.5 * x26;
	const GEN_FLT x28 = x24 * x27;
	const GEN_FLT x29 = x4 * x9;
	const GEN_FLT x30 = x28 * x29;
	const GEN_FLT x31 = x24 * x29;
	const GEN_FLT x32 = 0.125 * x22;
	const GEN_FLT x33 = 0.5 * mu;
	const GEN_FLT x34 = x33 * x13;
	const GEN_FLT x35 = x33 * x11;
	const GEN_FLT x36 = x35 + x34;
	const GEN_FLT x37 = mu * x36 * x16;
	const GEN_FLT x38 = x32 * x37;
	const GEN_FLT x39 = x31 * x38;
	const GEN_FLT x40 = x36 * x19;
	const GEN_FLT x41 = x40 * (1. / (x15 * sqrt(x15)));
	const GEN_FLT x42 = 0.25 * mu;
	const GEN_FLT x43 = x41 * x42;
	const GEN_FLT x44 = x43 * x24;
	const GEN_FLT x45 = x7 * x9;
	const GEN_FLT x46 = x45 * obj_qj;
	const GEN_FLT x47 = x36 * x20 * (1. / (x15 * x15));
	const GEN_FLT x48 = x0 * x41 * x32;
	const GEN_FLT x49 = x40 * x25;
	const GEN_FLT x50 = (1. / (x23 * sqrt(x23))) * ((-0.5 * x49 * x22) + (x48 * x13) + (x48 * x11) + (-1 * x47 * x14) + (x35 * x21) + (x34 * x21) + (-1 * x47 * x12));
	const GEN_FLT x51 = x50 * x42 * x26;
	const GEN_FLT x52 = x51 * x29;
	const GEN_FLT x53 = x43 * x31;
	const GEN_FLT x54 = x22 * obj_qw;
	const GEN_FLT x55 = 1.0/2.0 * x50;
	const GEN_FLT x56 = x38 * x24;
	const GEN_FLT x57 = x45 * x28;
	const GEN_FLT x58 = 0.25 * x49;
	const GEN_FLT x59 = x58 * x24;
	const GEN_FLT x60 = 0.125 * x54 * x37;
	const GEN_FLT x61 = x55 * x22;
	const GEN_FLT x62 = x24 * obj_qk;
	const GEN_FLT x63 = x62 * x45;
	const GEN_FLT x64 = x62 * x29;
	const GEN_FLT x65 = x45 * obj_qw;
	const GEN_FLT x66 = x45 * obj_qi;
	out[0] = (-1 * x54 * x55) + (x53 * obj_qi) + (-1 * x59 * obj_qw) + (-1 * x39 * obj_qi) + (x57 * obj_qj) + (-1 * x30 * obj_qi) + (x52 * obj_qi) + (x56 * x46) + (-1 * x44 * x46) + (-1 * x51 * x46);
	out[1] = (-1 * x59 * obj_qi) + (x51 * x45 * obj_qk) + (-1 * x63 * x38) + (x30 * obj_qw) + (x60 * x31) + (-1 * x52 * obj_qw) + (-1 * x53 * obj_qw) + (-1 * x61 * obj_qi) + (x63 * x43) + (-1 * x63 * x27);
	out[2] = (x65 * x51) + (-1 * x64 * x27) + (-1 * x60 * x45 * x24) + (-1 * x59 * obj_qj) + (x64 * x43) + (x65 * x44) + (x52 * obj_qk) + (-1 * x65 * x28) + (-1 * x64 * x38) + (-1 * x61 * obj_qj);
	out[3] = (x57 * obj_qi) + (-1 * x62 * x58) + (-1 * x61 * obj_qk) + (-1 * x66 * x51) + (-1 * x53 * obj_qj) + (x39 * obj_qj) + (-1 * x52 * obj_qj) + (-1 * x66 * x44) + (x66 * x56) + (x30 * obj_qj);
	out[4] = 0;
	out[5] = 0;
	out[6] = 0;
}

// Jacobian of imu_correct_up wrt [obj_qw, obj_qi, obj_qj, obj_qk, aa_x, aa_y, aa_z]
static inline void gen_imu_correct_up_jac_imu_rot(FLT* out, const FLT mu, const FLT* imu_rot, const FLT* up_in_obj) {
	const GEN_FLT obj_qw = imu_rot[0];
	const GEN_FLT obj_qi = imu_rot[1];
	const GEN_FLT obj_qj = imu_rot[2];
	const GEN_FLT obj_qk = imu_rot[3];
	const GEN_FLT aa_x = imu_rot[4];
	const GEN_FLT aa_y = imu_rot[5];
	const GEN_FLT aa_z = imu_rot[6];
	const GEN_FLT obj_up_x = up_in_obj[0];
	const GEN_FLT obj_up_y = up_in_obj[1];
	const GEN_FLT obj_up_z = up_in_obj[2];
	const GEN_FLT x0 = obj_qw * obj_up_z;
	const GEN_FLT x1 = obj_qi * obj_up_y;
	const GEN_FLT x2 = obj_qj * obj_up_x;
	const GEN_FLT x3 = (-1 * x2) + x0 + x1;
	const GEN_FLT x4 = obj_qw * obj_up_x;
	const GEN_FLT x5 = obj_qj * obj_up_z;
	const GEN_FLT x6 = obj_qk * obj_up_y;
	const GEN_FLT x7 = (-1 * x6) + x4 + x5;
	const GEN_FLT x8 = obj_up_y + (2 * ((x7 * obj_qk) + (-1 * x3 * obj_qi)));
	const GEN_FLT x9 = x8 * x8;
	const GEN_FLT x10 = obj_qw * obj_up_y;
	const GEN_FLT x11 = obj_qk * obj_up_x;
	const GEN_FLT x12 = obj_qi * obj_up_z;
	const GEN_FLT x13 = (-1 * x12) + x10 + x11;
	const GEN_FLT x14 = obj_up_x + (2 * ((x3 * obj_qj) + (-1 * x13 * obj_qk)));
	const GEN_FLT x15 = x14 * x14;
	const GEN_FLT x16 = x15 + x9;
	const GEN_FLT x17 = sqrt(x16);
	const GEN_FLT x18 = obj_up_z + (2 * ((x13 * obj_qi) + (-1 * x7 * obj_qj)));
	const GEN_FLT x19 = atan2(x17, x18);
	const GEN_FLT x20 = 2 * x12;
	const GEN_FLT x21 = 2 * x11;
	const GEN_FLT x22 = x21 + (-1 * x20);
	const GEN_FLT x23 = mu * mu;
	const GEN_FLT x24 = x23 * (x19 * x19);
	const GEN_FLT x25 = 0.5 * x24;
	const GEN_FLT x26 = x8 * x25;
	const GEN_FLT x27 = x22 * x26;
	const GEN_FLT x28 = 2 * x6;
	const GEN_FLT x29 = 2 * x5;
	const GEN_FLT x30 = x29 + (-1 * x28);
	const GEN_FLT x31 = 2 * x14;
	const GEN_FLT x32 = 2 * x8;
	const GEN_FLT x33 = 1.0/2.0 * (1. / x18) * (1. / x17);
	const GEN_FLT x34 = 2 * x2;
	const GEN_FLT x35 = 2 * x1;
	const GEN_FLT x36 = x18 * x18;
	const GEN_FLT x37 = (1. / x36) * x17;
	const GEN_FLT x38 = (-1 * (x35 + (-1 * x34)) * x37) + (((x32 * x22) + (x30 * x31)) * x33);
	const GEN_FLT x39 = (1. / (x16 + x36)) * x36;
	const GEN_FLT x40 = 0.5 * x19;
	const GEN_FLT x41 = x40 * x23;
	const GEN_FLT x42 = x41 * x15;
	const GEN_FLT x43 = x42 * x39;
	const GEN_FLT x44 = x43 * x38;
	const GEN_FLT x45 = x9 * x41;
	const GEN_FLT x46 = x45 * x39;
	const GEN_FLT x47 = x46 * x38;
	const GEN_FLT x48 = x25 * x14;
	const GEN_FLT x49 = x48 * x30;
	const GEN_FLT x50 = x49 + x47 + x27 + x44;
	const GEN_FLT x51 = 0.25 * x24;
	const GEN_FLT x52 = x51 * x15;
	const GEN_FLT x53 = x9 * x51;
	const GEN_FLT x54 = 1e-10 + x53 + x52;
	const GEN_FLT x55 = sqrt(x54);
	const GEN_FLT x56 = 0.5 * x55;
	const GEN_FLT x57 = cos(x56);
	const GEN_FLT x58 = sin(x56);
	const GEN_FLT x59 = (1. / (x54 * sqrt(x54))) * x58;
	const GEN_FLT x60 = x57 * x59 * x24;
	const GEN_FLT x61 = x9 * x60;
	const GEN_FLT x62 = 0.125 * x61;
	const GEN_FLT x63 = 1. / x54;
	const GEN_FLT x64 = x58 * x58;
	const GEN_FLT x65 = x63 * x64;
	const GEN_FLT x66 = x64 * (1. / (x54 * x54));
	const GEN_FLT x67 = x66 * x53;
	const GEN_FLT x68 = x66 * x52;
	const GEN_FLT x69 = x60 * x15;
	const GEN_FLT x70 = 0.125 * x69;
	const GEN_FLT x71 = x58 * (1. / x55);
	const GEN_FLT x72 = 0.5 * x57;
	const GEN_FLT x73 = x71 * x72;
	const GEN_FLT x74 = (-1 * x73 * x50) + (x65 * x44) + (x65 * x27) + (x65 * x49) + (-1 * x67 * x50) + (x62 * x50) + (x70 * x50) + (x65 * x47) + (-1 * x68 * x50);
	const GEN_FLT x75 = mu * x8;
	const GEN_FLT x76 = x71 * x75;
	const GEN_FLT x77 = x74 * x76;
	const GEN_FLT x78 = x77 * x19;
	const GEN_FLT x79 = 1e-11 + (x65 * x53) + (x65 * x52) + (x57 * x57);
	const GEN_FLT x80 = 1. / (x79 * sqrt(x79));
	const GEN_FLT x81 = 0.25 * x80;
	const GEN_FLT x82 = x81 * x78;
	const GEN_FLT x83 = mu * x14;
	const GEN_FLT x84 = x19 * obj_qj;
	const GEN_FLT x85 = x83 * x84;
	const GEN_FLT x86 = x81 * x71;
	const GEN_FLT x87 = x86 * x74;
	const GEN_FLT x88 = x75 * x19;
	const GEN_FLT x89 = x88 * obj_qi;
	const GEN_FLT x90 = 1. / sqrt(x79);
	const GEN_FLT x91 = 0.25 * x90;
	const GEN_FLT x92 = x59 * x91;
	const GEN_FLT x93 = x50 * x92;
	const GEN_FLT x94 = 0.5 * x90;
	const GEN_FLT x95 = x76 * x94;
	const GEN_FLT x96 = x95 * x39;
	const GEN_FLT x97 = x96 * x38;
	const GEN_FLT x98 = x90 * x40;
	const GEN_FLT x99 = x71 * x98;
	const GEN_FLT x100 = mu * x99;
	const GEN_FLT x101 = x100 * obj_qj;
	const GEN_FLT x102 = x57 * x90;
	const GEN_FLT x103 = x83 * x71 * x94;
	const GEN_FLT x104 = x39 * x103;
	const GEN_FLT x105 = x104 * obj_qj;
	const GEN_FLT x106 = x63 * x102;
	const GEN_FLT x107 = 0.125 * x106;
	const GEN_FLT x108 = x50 * x107;
	const GEN_FLT x109 = x85 * x50;
	const GEN_FLT x110 = x80 * obj_qw;
	const GEN_FLT x111 = 1.0/2.0 * x57;
	const GEN_FLT x112 = x110 * x111;
	const GEN_FLT x113 = x50 * obj_qw;
	const GEN_FLT x114 = x71 * x91;
	const GEN_FLT x115 = x22 * x100;
	const GEN_FLT x116 = 2 * x0;
	const GEN_FLT x117 = x34 + (-1 * x116) + (-4 * x1);
	const GEN_FLT x118 = x26 * x117;
	const GEN_FLT x119 = 2 * obj_qk * obj_up_z;
	const GEN_FLT x120 = 2 * obj_qj * obj_up_y;
	const GEN_FLT x121 = x120 + x119;
	const GEN_FLT x122 = 2 * x10;
	const GEN_FLT x123 = (-1 * x37 * ((-4 * x12) + x122 + x21)) + (((x32 * x117) + (x31 * x121)) * x33);
	const GEN_FLT x124 = x46 * x123;
	const GEN_FLT x125 = x43 * x123;
	const GEN_FLT x126 = x48 * x121;
	const GEN_FLT x127 = x126 + x125 + x118 + x124;
	const GEN_FLT x128 = (-1 * x73 * x127) + (x65 * x124) + (x65 * x125) + (x70 * x127) + (x62 * x127) + (x65 * x118) + (-1 * x67 * x127) + (x65 * x126) + (-1 * x68 * x127);
	const GEN_FLT x129 = x76 * x128;
	const GEN_FLT x130 = x81 * x19;
	const GEN_FLT x131 = x130 * obj_qi;
	const GEN_FLT x132 = x86 * x128;
	const GEN_FLT x133 = x114 * x127;
	const GEN_FLT x134 = x107 * x127;
	const GEN_FLT x135 = x92 * x127;
	const GEN_FLT x136 = x96 * x123;
	const GEN_FLT x137 = x76 * x98;
	const GEN_FLT x138 = -1 * x137;
	const GEN_FLT x139 = x110 * x128;
	const GEN_FLT x140 = x100 * obj_qi;
	const GEN_FLT x141 = (-4 * x2) + x116 + x35;
	const GEN_FLT x142 = 2 * obj_qi * obj_up_x;
	const GEN_FLT x143 = x119 + x142;
	const GEN_FLT x144 = 2 * x4;
	const GEN_FLT x145 = x39 * ((-1 * x37 * (x28 + (-1 * x144) + (-4 * x5))) + (((x32 * x143) + (x31 * x141)) * x33));
	const GEN_FLT x146 = x45 * x145;
	const GEN_FLT x147 = x26 * x143;
	const GEN_FLT x148 = x42 * x145;
	const GEN_FLT x149 = x48 * x141;
	const GEN_FLT x150 = x148 + x147 + x149 + x146;
	const GEN_FLT x151 = 0.125 * x150;
	const GEN_FLT x152 = x71 * x150;
	const GEN_FLT x153 = (-1 * x68 * x150) + (-1 * x67 * x150) + (x65 * x148) + (x65 * x147) + (-1 * x72 * x152) + (x61 * x151) + (x65 * x146) + (x65 * x149) + (x69 * x151);
	const GEN_FLT x154 = x76 * x153;
	const GEN_FLT x155 = x83 * x99;
	const GEN_FLT x156 = x100 * x143;
	const GEN_FLT x157 = x106 * x151;
	const GEN_FLT x158 = x103 * x145;
	const GEN_FLT x159 = x92 * x150;
	const GEN_FLT x160 = x95 * x145;
	const GEN_FLT x161 = x71 * x153;
	const GEN_FLT x162 = x81 * x161;
	const GEN_FLT x163 = x91 * x152;
	const GEN_FLT x164 = x20 + (-1 * x122) + (-4 * x11);
	const GEN_FLT x165 = (-4 * x6) + x144 + x29;
	const GEN_FLT x166 = (-1 * (x142 + x120) * x37) + (((x32 * x165) + (x31 * x164)) * x33);
	const GEN_FLT x167 = x46 * x166;
	const GEN_FLT x168 = x26 * x165;
	const GEN_FLT x169 = x43 * x166;
	const GEN_FLT x170 = x48 * x164;
	const GEN_FLT x171 = x170 + x169 + x167 + x168;
	const GEN_FLT x172 = 0.125 * x171;
	const GEN_FLT x173 = x66 * x171;
	const GEN_FLT x174 = (-1 * x73 * x171) + (x69 * x172) + (x65 * x168) + (x65 * x169) + (x65 * x170) + (x65 * x167) + (-1 * x52 * x173) + (x61 * x172) + (-1 * x53 * x173);
	const GEN_FLT x175 = x76 * x174;
	const GEN_FLT x176 = x86 * x174;
	const GEN_FLT x177 = x92 * x171;
	const GEN_FLT x178 = x106 * x172;
	const GEN_FLT x179 = x114 * x171;
	const GEN_FLT x180 = x96 * x166;
	const GEN_FLT x181 = x92 * x113;
	const GEN_FLT x182 = x83 * x19;
	const GEN_FLT x183 = x182 * obj_qk;
	const GEN_FLT x184 = x80 * x111;
	const GEN_FLT x185 = x74 * x184;
	const GEN_FLT x186 = x103 * obj_qk;
	const GEN_FLT x187 = x39 * x186;
	const GEN_FLT x188 = x30 * x100;
	const GEN_FLT x189 = x50 * x114;
	const GEN_FLT x190 = x107 * x113;
	const GEN_FLT x191 = x38 * obj_qw;
	const GEN_FLT x192 = x100 * obj_qw;
	const GEN_FLT x193 = 0.25 * x110;
	const GEN_FLT x194 = 0.25 * x139;
	const GEN_FLT x195 = x128 * x184;
	const GEN_FLT x196 = x88 * obj_qw;
	const GEN_FLT x197 = x100 * obj_qk;
	const GEN_FLT x198 = x184 * x153;
	const GEN_FLT x199 = x19 * x193;
	const GEN_FLT x200 = x174 * x184;
	const GEN_FLT x201 = -1 * x155;
	const GEN_FLT x202 = x88 * obj_qk;
	const GEN_FLT x203 = x182 * x193;
	const GEN_FLT x204 = x71 * x203;
	const GEN_FLT x205 = x182 * obj_qw;
	const GEN_FLT x206 = x104 * obj_qw;
	const GEN_FLT x207 = x130 * obj_qk;
	const GEN_FLT x208 = x81 * x84;
	const GEN_FLT x209 = x182 * obj_qi;
	const GEN_FLT x210 = x104 * obj_qi;
	const GEN_FLT x211 = x84 * x75;
	const GEN_FLT x212 = x96 * obj_qj;
	const GEN_FLT x213 = x211 * x127;
	out[0] = (-1 * x92 * x109) + (-1 * x115 * obj_qi) + (x30 * x101) + (-1 * x85 * x87) + (-1 * x97 * obj_qi) + (x89 * x93) + (x38 * x105) + x102 + (-1 * x74 * x112) + (x82 * obj_qi) + (-1 * x89 * x108) + (-1 * x113 * x114) + (x109 * x107);
	out[1] = (-1 * x117 * x140) + (-1 * x89 * x134) + (-1 * x133 * obj_qw) + (x105 * x123) + (x129 * x131) + x138 + (-1 * x85 * x135) + (x85 * x134) + (-1 * x136 * obj_qi) + (x89 * x135) + (-1 * x85 * x132) + (x101 * x121) + (-1 * x111 * x139);
	out[2] = (x89 * x159) + (-1 * x89 * x157) + (x131 * x154) + (-1 * x112 * x153) + (x101 * x141) + (-1 * x160 * obj_qi) + (-1 * x156 * obj_qi) + x155 + (-1 * x85 * x162) + (x158 * obj_qj) + (x85 * x157) + (-1 * x163 * obj_qw) + (-1 * x85 * x159);
	out[3] = (-1 * x165 * x140) + (x85 * x178) + (x105 * x166) + (-1 * x85 * x177) + (x175 * x131) + (-1 * x85 * x176) + (-1 * x179 * obj_qw) + (x101 * x164) + (-1 * x112 * x174) + (x89 * x177) + (-1 * x89 * x178) + (-1 * x180 * obj_qi);
	out[4] = 0;
	out[5] = 0;
	out[6] = 0;
	out[7] = x137 + (-1 * x38 * x187) + (-1 * x108 * x183) + (-1 * x185 * obj_qi) + (-1 * x88 * x181) + (-1 * x188 * obj_qk) + (x87 * x183) + (x93 * x183) + (-1 * x78 * x193) + (-1 * x189 * obj_qi) + (x88 * x190) + (x96 * x191) + (x22 * x192);
	out[8] = (x196 * x134) + (-1 * x123 * x187) + (x183 * x132) + x102 + (-1 * x76 * x19 * x194) + (-1 * x133 * obj_qi) + (x117 * x192) + (-1 * x196 * x135) + (-1 * x183 * x134) + (-1 * x121 * x197) + (x136 * obj_qw) + (-1 * x195 * obj_qi) + (x183 * x135);
	out[9] = (x160 * obj_qw) + (-1 * x186 * x145) + (-1 * x197 * x141) + (x192 * x143) + (x162 * x183) + (-1 * x183 * x157) + (x183 * x159) + (-1 * x198 * obj_qi) + (-1 * x199 * x154) + (-1 * x196 * x159) + (x196 * x157) + (-1 * x163 * obj_qi);
	out[10] = (-1 * x177 * x196) + x201 + (x178 * x196) + (-1 * x166 * x187) + (-1 * x178 * x183) + (-1 * x200 * obj_qi) + (-1 * x175 * x199) + (x165 * x192) + (-1 * x164 * x197) + (-1 * x179 * obj_qi) + (x176 * x183) + (x177 * x183) + (x180 * obj_qw);
	out[11] = 0;
	out[12] = 0;
	out[13] = 0;
	out[14] = (-1 * x202 * x108) + x201 + (-1 * x189 * obj_qj) + (-1 * x30 * x192) + (-1 * x104 * x191) + (x82 * obj_qk) + (x93 * x202) + (x181 * x182) + (x74 * x204) + (-1 * x182 * x190) + (-1 * x185 * obj_qj) + (-1 * x97 * obj_qk) + (-1 * x115 * obj_qk);
	out[15] = (-1 * x133 * obj_qj) + (x205 * x135) + (-1 * x205 * x134) + (-1 * x206 * x123) + (-1 * x121 * x192) + (x71 * x182 * x194) + (-1 * x136 * obj_qk) + (-1 * x195 * obj_qj) + (x202 * x135) + (-1 * x202 * x134) + (x207 * x129) + (-1 * x117 * x197);
	out[16] = (x202 * x159) + (-1 * x198 * obj_qj) + x102 + (x203 * x161) + (x205 * x159) + (-1 * x192 * x141) + (-1 * x160 * obj_qk) + (-1 * x205 * x157) + (-1 * x163 * obj_qj) + (x207 * x154) + (-1 * x202 * x157) + (-1 * x156 * obj_qk) + (-1 * x158 * obj_qw);
	out[17] = (-1 * x205 * x178) + (-1 * x179 * obj_qj) + (-1 * x164 * x192) + (x205 * x177) + (x204 * x174) + (-1 * x206 * x166) + (-1 * x165 * x197) + (x202 * x177) + (x207 * x175) + x138 + (-1 * x180 * obj_qk) + (-1 * x200 * obj_qj) + (-1 * x202 * x178);
	out[18] = 0;
	out[19] = 0;
	out[20] = 0;
	out[21] = (-1 * x93 * x211) + (x209 * x108) + (x188 * obj_qi) + (-1 * x77 * x208) + (-1 * x93 * x209) + (x38 * x210) + (-1 * x87 * x209) + (-1 * x189 * obj_qk) + (-1 * x185 * obj_qk) + (x22 * x101) + (x211 * x108) + (x38 * x212);
	out[22] = (x212 * x123) + (-1 * x209 * x132) + (-1 * x209 * x135) + x155 + (-1 * x92 * x213) + (x101 * x117) + (-1 * x195 * obj_qk) + (x210 * x123) + (x121 * x140) + (x209 * x134) + (x213 * x107) + (-1 * x208 * x129) + (-1 * x133 * obj_qk);
	out[23] = (x211 * x157) + (-1 * x163 * obj_qk) + (x160 * obj_qj) + (-1 * x209 * x159) + (x101 * x143) + x137 + (x140 * x141) + (-1 * x208 * x154) + (x209 * x157) + (-1 * x198 * obj_qk) + (x158 * obj_qi) + (-1 * x209 * x162) + (-1 * x211 * x159);
	out[24] = x102 + (x211 * x178) + (x209 * x178) + (-1 * x208 * x175) + (x210 * x166) + (x101 * x165) + (x164 * x140) + (-1 * x179 * obj_qk) + (-1 * x209 * x176) + (-1 * x211 * x177) + (x212 * x166) + (-1 * x200 * obj_qk) + (-1 * x209 * x177);
	out[25] = 0;
	out[26] = 0;
	out[27] = 0;
	out[28] = 0;
	out[29] = 0;
	out[30] = 0;
	out[31] = 0;
	out[32] = 1;
	out[33] = 0;
	out[34] = 0;
	out[35] = 0;
	out[36] = 0;
	out[37] = 0;
	out[38] = 0;
	out[39] = 0;
	out[40] = 1;
	out[41] = 0;
	out[42] = 0;
	out[43] = 0;
	out[44] = 0;
	out[45] = 0;
	out[46] = 0;
	out[47] = 0;
	out[48] = 1;
}

// Jacobian of imu_correct_up wrt [obj_up_x, obj_up_y, obj_up_z]
static inline void gen_imu_correct_up_jac_up_in_obj(FLT* out, const FLT mu, const FLT* imu_rot, const FLT* up_in_obj) {
	const GEN_FLT obj_qw = imu_rot[0];
	const GEN_FLT obj_qi = imu_rot[1];
	const GEN_FLT obj_qj = imu_rot[2];
	const GEN_FLT obj_qk = imu_rot[3];
	const GEN_FLT aa_x = imu_rot[4];
	const GEN_FLT aa_y = imu_rot[5];
	const GEN_FLT aa_z = imu_rot[6];
	const GEN_FLT obj_up_x = up_in_obj[0];
	const GEN_FLT obj_up_y = up_in_obj[1];
	const GEN_FLT obj_up_z = up_in_obj[2];
	const GEN_FLT x0 = (-1 * obj_qj * obj_up_x) + (obj_qw * obj_up_z) + (obj_qi * obj_up_y);
	const GEN_FLT x1 = (-1 * obj_qk * obj_up_y) + (obj_qw * obj_up_x) + (obj_qj * obj_up_z);
	const GEN_FLT x2 = obj_up_y + (2 * ((x1 * obj_qk) + (-1 * x0 * obj_qi)));
	const GEN_FLT x3 = x2 * x2;
	const GEN_FLT x4 = (-1 * obj_qi * obj_up_z) + (obj_qw * obj_up_y) + (obj_qk * obj_up_x);
	const GEN_FLT x5 = obj_up_x + (2 * ((x0 * obj_qj) + (-1 * x4 * obj_qk)));
	const GEN_FLT x6 = x5 * x5;
	const GEN_FLT x7 = x6 + x3;
	const GEN_FLT x8 = sqrt(x7);
	const GEN_FLT x9 = obj_up_z + (2 * ((x4 * obj_qi) + (-1 * x1 * obj_qj)));
	const GEN_FLT x10 = atan2(x8, x9);
	const GEN_FLT x11 = mu * x10;
	const GEN_FLT x12 = x2 * x11;
	const GEN_FLT x13 = x12 * obj_qi;
	const GEN_FLT x14 = 2 * obj_qj * obj_qi;
	const GEN_FLT x15 = 2 * obj_qw;
	const GEN_FLT x16 = x15 * obj_qk;
	const GEN_FLT x17 = x16 + x14;
	const GEN_FLT x18 = mu * mu;
	const GEN_FLT x19 = (x10 * x10) * x18;
	const GEN_FLT x20 = 0.5 * x19;
	const GEN_FLT x21 = x2 * x20;
	const GEN_FLT x22 = x21 * x17;
	const GEN_FLT x23 = 0.25 * x19;
	const GEN_FLT x24 = x6 * x23;
	const GEN_FLT x25 = x3 * x23;
	const GEN_FLT x26 = 1e-10 + x25 + x24;
	const GEN_FLT x27 = 1. / x26;
	const GEN_FLT x28 = sqrt(x26);
	const GEN_FLT x29 = 0.5 * x28;
	const GEN_FLT x30 = sin(x29);
	const GEN_FLT x31 = x30 * x30;
	const GEN_FLT x32 = x31 * x27;
	const GEN_FLT x33 = -2 * (obj_qk * obj_qk);
	const GEN_FLT x34 = 1 + (-2 * (obj_qj * obj_qj));
	const GEN_FLT x35 = x34 + x33;
	const GEN_FLT x36 = 2 * x5;
	const GEN_FLT x37 = 2 * x2;
	const GEN_FLT x38 = 1.0/2.0 * (1. / x8) * (1. / x9);
	const GEN_FLT x39 = x15 * obj_qj;
	const GEN_FLT x40 = 2 * obj_qk;
	const GEN_FLT x41 = x40 * obj_qi;
	const GEN_FLT x42 = x9 * x9;
	const GEN_FLT x43 = x8 * (1. / x42);
	const GEN_FLT x44 = x42 * (1. / (x7 + x42));
	const GEN_FLT x45 = x44 * ((-1 * (x41 + (-1 * x39)) * x43) + (((x37 * x17) + (x36 * x35)) * x38));
	const GEN_FLT x46 = 0.5 * x10 * x18;
	const GEN_FLT x47 = x3 * x46;
	const GEN_FLT x48 = x45 * x47;
	const GEN_FLT x49 = x6 * x46;
	const GEN_FLT x50 = x45 * x49;
	const GEN_FLT x51 = x5 * x20;
	const GEN_FLT x52 = x51 * x35;
	const GEN_FLT x53 = x52 + x50 + x48 + x22;
	const GEN_FLT x54 = x31 * (1. / (x26 * x26));
	const GEN_FLT x55 = x54 * x25;
	const GEN_FLT x56 = x54 * x24;
	const GEN_FLT x57 = cos(x29);
	const GEN_FLT x58 = x30 * (1. / x28);
	const GEN_FLT x59 = 0.5 * x58;
	const GEN_FLT x60 = x57 * x59;
	const GEN_FLT x61 = 0.125 * x57;
	const GEN_FLT x62 = x61 * x53;
	const GEN_FLT x63 = x30 * (1. / (x26 * sqrt(x26)));
	const GEN_FLT x64 = x63 * x19;
	const GEN_FLT x65 = x6 * x64;
	const GEN_FLT x66 = x3 * x64;
	const GEN_FLT x67 = (x50 * x32) + (x52 * x32) + (x62 * x66) + (x62 * x65) + (-1 * x53 * x55) + (x32 * x22) + (x48 * x32) + (-1 * x53 * x56) + (-1 * x60 * x53);
	const GEN_FLT x68 = 1e-11 + (x32 * x25) + (x32 * x24) + (x57 * x57);
	const GEN_FLT x69 = 1. / (x68 * sqrt(x68));
	const GEN_FLT x70 = 0.25 * x58;
	const GEN_FLT x71 = x70 * x69;
	const GEN_FLT x72 = x71 * x67;
	const GEN_FLT x73 = x5 * x11;
	const GEN_FLT x74 = x69 * obj_qj;
	const GEN_FLT x75 = x74 * x67;
	const GEN_FLT x76 = x70 * x75;
	const GEN_FLT x77 = 1. / sqrt(x68);
	const GEN_FLT x78 = x77 * obj_qj;
	const GEN_FLT x79 = x59 * x11;
	const GEN_FLT x80 = x79 * x35;
	const GEN_FLT x81 = x70 * x53;
	const GEN_FLT x82 = x81 * x77;
	const GEN_FLT x83 = 0.25 * x63;
	const GEN_FLT x84 = x83 * x53;
	const GEN_FLT x85 = x73 * x78;
	const GEN_FLT x86 = x62 * x27;
	const GEN_FLT x87 = x77 * obj_qi;
	const GEN_FLT x88 = x87 * x12;
	const GEN_FLT x89 = mu * x59;
	const GEN_FLT x90 = x5 * x89;
	const GEN_FLT x91 = x90 * x45;
	const GEN_FLT x92 = 1.0/2.0 * x57;
	const GEN_FLT x93 = x69 * x92;
	const GEN_FLT x94 = x93 * obj_qw;
	const GEN_FLT x95 = x2 * x89;
	const GEN_FLT x96 = x95 * x45;
	const GEN_FLT x97 = x79 * x17;
	const GEN_FLT x98 = x14 + (-1 * x16);
	const GEN_FLT x99 = -2 * (obj_qi * obj_qi);
	const GEN_FLT x100 = 1 + x33 + x99;
	const GEN_FLT x101 = x40 * obj_qj;
	const GEN_FLT x102 = x15 * obj_qi;
	const GEN_FLT x103 = x44 * ((-1 * (x102 + x101) * x43) + (x38 * ((x37 * x100) + (x98 * x36))));
	const GEN_FLT x104 = x47 * x103;
	const GEN_FLT x105 = x21 * x100;
	const GEN_FLT x106 = x49 * x103;
	const GEN_FLT x107 = x51 * x98;
	const GEN_FLT x108 = x107 + x106 + x105 + x104;
	const GEN_FLT x109 = x57 * x108;
	const GEN_FLT x110 = 0.125 * x109;
	const GEN_FLT x111 = (x32 * x106) + (x32 * x107) + (x32 * x105) + (x66 * x110) + (x32 * x104) + (x65 * x110) + (-1 * x59 * x109) + (-1 * x55 * x108) + (-1 * x56 * x108);
	const GEN_FLT x112 = x71 * x111;
	const GEN_FLT x113 = x70 * x74;
	const GEN_FLT x114 = x111 * x113;
	const GEN_FLT x115 = x70 * x77;
	const GEN_FLT x116 = x108 * x115;
	const GEN_FLT x117 = x83 * x108;
	const GEN_FLT x118 = x79 * x98;
	const GEN_FLT x119 = x27 * x110;
	const GEN_FLT x120 = x87 * x108;
	const GEN_FLT x121 = x83 * x120;
	const GEN_FLT x122 = x95 * x103;
	const GEN_FLT x123 = x79 * x100;
	const GEN_FLT x124 = x101 + (-1 * x102);
	const GEN_FLT x125 = x21 * x124;
	const GEN_FLT x126 = x39 + x41;
	const GEN_FLT x127 = x44 * ((-1 * (x34 + x99) * x43) + (((x37 * x124) + (x36 * x126)) * x38));
	const GEN_FLT x128 = x47 * x127;
	const GEN_FLT x129 = x49 * x127;
	const GEN_FLT x130 = x51 * x126;
	const GEN_FLT x131 = x129 + x125 + x130 + x128;
	const GEN_FLT x132 = x87 * x131;
	const GEN_FLT x133 = x12 * x132;
	const GEN_FLT x134 = x61 * x27;
	const GEN_FLT x135 = x83 * x131;
	const GEN_FLT x136 = x79 * x126;
	const GEN_FLT x137 = x90 * x127;
	const GEN_FLT x138 = x61 * x131;
	const GEN_FLT x139 = x27 * x138;
	const GEN_FLT x140 = x95 * x127;
	const GEN_FLT x141 = (x32 * x129) + (x66 * x138) + (-1 * x60 * x131) + (-1 * x56 * x131) + (-1 * x55 * x131) + (x32 * x128) + (x65 * x138) + (x32 * x125) + (x32 * x130);
	const GEN_FLT x142 = x113 * x141;
	const GEN_FLT x143 = x115 * x131;
	const GEN_FLT x144 = x79 * x124;
	const GEN_FLT x145 = x71 * x141;
	const GEN_FLT x146 = x12 * obj_qw;
	const GEN_FLT x147 = x73 * obj_qk;
	const GEN_FLT x148 = x77 * obj_qk;
	const GEN_FLT x149 = x73 * x148;
	const GEN_FLT x150 = x77 * obj_qw;
	const GEN_FLT x151 = x12 * x150;
	const GEN_FLT x152 = x93 * obj_qi;
	const GEN_FLT x153 = x73 * x112;
	const GEN_FLT x154 = x103 * x148;
	const GEN_FLT x155 = x103 * x150;
	const GEN_FLT x156 = x73 * obj_qw;
	const GEN_FLT x157 = x73 * x150;
	const GEN_FLT x158 = x12 * x148;
	const GEN_FLT x159 = x12 * obj_qk;
	const GEN_FLT x160 = x74 * x92;
	const GEN_FLT x161 = x83 * x157;
	const GEN_FLT x162 = x78 * x12;
	const GEN_FLT x163 = x87 * x90;
	const GEN_FLT x164 = x73 * obj_qi;
	const GEN_FLT x165 = x87 * x73;
	const GEN_FLT x166 = x93 * obj_qk;
	const GEN_FLT x167 = x83 * x162;
	const GEN_FLT x168 = x73 * x132;
	out[0] = (-1 * x87 * x97) + (-1 * x84 * x85) + (x72 * x13) + (-1 * x82 * obj_qw) + (-1 * x73 * x76) + (x80 * x78) + (-1 * x88 * x86) + (x78 * x91) + (-1 * x87 * x96) + (-1 * x67 * x94) + (x85 * x86) + (x88 * x84);
	out[1] = (-1 * x87 * x123) + (x78 * x90 * x103) + (-1 * x85 * x117) + (x13 * x112) + (x78 * x118) + (-1 * x73 * x114) + (x85 * x119) + (-1 * x116 * obj_qw) + (x12 * x121) + (-1 * x94 * x111) + (-1 * x88 * x119) + (-1 * x87 * x122);
	out[2] = (x83 * x133) + (x85 * x139) + (-1 * x94 * x141) + (x78 * x136) + (x13 * x145) + (-1 * x85 * x135) + (x78 * x137) + (-1 * x87 * x140) + (-1 * x87 * x144) + (-1 * x73 * x142) + (-1 * x133 * x134) + (-1 * x143 * obj_qw);
	out[3] = (x96 * x150) + (-1 * x91 * x148) + (-1 * x86 * x149) + (-1 * x72 * x146) + (x86 * x151) + (x72 * x147) + (-1 * x84 * x151) + (-1 * x67 * x152) + (-1 * x81 * x87) + (x84 * x149) + (x97 * x150) + (-1 * x80 * x148);
	out[4] = (x123 * x150) + (-1 * x117 * x151) + (-1 * x112 * x146) + (x119 * x151) + (-1 * x90 * x154) + (x153 * obj_qk) + (-1 * x118 * x148) + (x117 * x149) + (-1 * x111 * x152) + (-1 * x70 * x120) + (-1 * x119 * x149) + (x95 * x155);
	out[5] = (x145 * x147) + (-1 * x137 * x148) + (-1 * x139 * x149) + (x139 * x151) + (x144 * x150) + (x140 * x150) + (-1 * x136 * x148) + (-1 * x146 * x145) + (x135 * x149) + (-1 * x70 * x132) + (-1 * x141 * x152) + (-1 * x135 * x151);
	out[6] = (-1 * x96 * x148) + (-1 * x80 * x150) + (x72 * x156) + (-1 * x75 * x92) + (-1 * x86 * x158) + (-1 * x86 * x157) + (-1 * x97 * x148) + (-1 * x91 * x150) + (x84 * x158) + (x72 * x159) + (-1 * x82 * obj_qj) + (x84 * x157);
	out[7] = (x117 * x158) + (-1 * x90 * x155) + (-1 * x111 * x160) + (x108 * x161) + (x153 * obj_qw) + (x112 * x159) + (-1 * x119 * x157) + (-1 * x119 * x158) + (-1 * x95 * x154) + (-1 * x118 * x150) + (-1 * x116 * obj_qj) + (-1 * x123 * x148);
	out[8] = (-1 * x136 * x150) + (-1 * x139 * x157) + (-1 * x143 * obj_qj) + (x161 * x131) + (-1 * x137 * x150) + (x145 * x159) + (x145 * x156) + (-1 * x144 * x148) + (-1 * x140 * x148) + (-1 * x139 * x158) + (-1 * x160 * x141) + (x135 * x158);
	out[9] = (x78 * x97) + (x45 * x163) + (-1 * x76 * x12) + (-1 * x84 * x165) + (x86 * x162) + (x80 * x87) + (x78 * x96) + (-1 * x84 * x162) + (-1 * x72 * x164) + (x86 * x165) + (-1 * x82 * obj_qk) + (-1 * x67 * x166);
	out[10] = (x78 * x123) + (x119 * x165) + (-1 * x12 * x114) + (-1 * x111 * x166) + (-1 * x116 * obj_qk) + (-1 * x108 * x167) + (x103 * x163) + (-1 * x153 * obj_qi) + (x119 * x162) + (x87 * x118) + (-1 * x73 * x121) + (x78 * x122);
	out[11] = (-1 * x167 * x131) + (x87 * x136) + (x162 * x139) + (x168 * x134) + (-1 * x164 * x145) + (-1 * x143 * obj_qk) + (-1 * x166 * x141) + (x87 * x137) + (x78 * x140) + (-1 * x83 * x168) + (-1 * x12 * x142) + (x78 * x144);
	out[12] = 0;
	out[13] = 0;
	out[14] = 0;
	out[15] = 0;
	out[16] = 0;
	out[17] = 0;
	out[18] = 0;
	out[19] = 0;
	out[20] = 0;
}

static inline void gen_imu_predict_up(FLT* out, const SurviveKalmanModel* kalman_model) {
	const GEN_FLT obj_px = (*kalman_model).Pose.Pos[0];
	const GEN_FLT obj_py = (*kalman_model).Pose.Pos[1];
	const GEN_FLT obj_pz = (*kalman_model).Pose.Pos[2];
	const GEN_FLT obj_qw = (*kalman_model).Pose.Rot[0];
	const GEN_FLT obj_qi = (*kalman_model).Pose.Rot[1];
	const GEN_FLT obj_qj = (*kalman_model).Pose.Rot[2];
	const GEN_FLT obj_qk = (*kalman_model).Pose.Rot[3];
	const GEN_FLT vx = (*kalman_model).Velocity.Pos[0];
	const GEN_FLT vy = (*kalman_model).Velocity.Pos[1];
	const GEN_FLT vz = (*kalman_model).Velocity.Pos[2];
	const GEN_FLT avx = (*kalman_model).Velocity.AxisAngleRot[0];
	const GEN_FLT avy = (*kalman_model).Velocity.AxisAngleRot[1];
	const GEN_FLT avz = (*kalman_model).Velocity.AxisAngleRot[2];
	const GEN_FLT acc_x = (*kalman_model).Acc[0];
	const GEN_FLT acc_y = (*kalman_model).Acc[1];
	const GEN_FLT acc_z = (*kalman_model).Acc[2];
	const GEN_FLT acc_scale = (*kalman_model).AccScale;
	const GEN_FLT imu_w = (*kalman_model).IMUCorrection[0];
	const GEN_FLT imu_x = (*kalman_model).IMUCorrection[1];
	const GEN_FLT imu_y = (*kalman_model).IMUCorrection[2];
	const GEN_FLT imu_z = (*kalman_model).IMUCorrection[3];
	const GEN_FLT acc_biasx = (*kalman_model).AccBias[0];
	const GEN_FLT acc_biasy = (*kalman_model).AccBias[1];
	const GEN_FLT acc_biasz = (*kalman_model).AccBias[2];
	const GEN_FLT gbx = (*kalman_model).GyroBias[0];
	const GEN_FLT gby = (*kalman_model).GyroBias[1];
	const GEN_FLT gbz = (*kalman_model).GyroBias[2];
	const GEN_FLT x0 = (1. / sqrt(1e-11 + (obj_qw * obj_qw) + (obj_qi * obj_qi) + (obj_qj * obj_qj) + (obj_qk * obj_qk))) * (1. / sqrt(1e-11 + (imu_x * imu_x) + (imu_z * imu_z) + (imu_w * imu_w) + (imu_y * imu_y)));
	const GEN_FLT x1 = x0 * obj_qj;
	const GEN_FLT x2 = x0 * obj_qk;
	const GEN_FLT x3 = x0 * obj_qw;
	const GEN_FLT x4 = x0 * obj_qi;
	const GEN_FLT x5 = (-1 * x4 * imu_y) + (x3 * imu_z) + (x1 * imu_x) + (-1 * x2 * imu_w);
	const GEN_FLT x6 = x0 * imu_y;
	const GEN_FLT x7 = (x4 * imu_x) + (x3 * imu_w) + (x2 * imu_z) + (x6 * obj_qj);
	const GEN_FLT x8 = 0.101971621297793 * acc_y;
	const GEN_FLT x9 = 0.101971621297793 * acc_x;
	const GEN_FLT x10 = (-1 * x4 * imu_w) + (x3 * imu_x) + (x2 * imu_y) + (-1 * x1 * imu_z);
	const GEN_FLT x11 = 1 + (0.101971621297793 * acc_z);
	const GEN_FLT x12 = (-1 * x11 * x10) + (x8 * x7) + (x5 * x9);
	const GEN_FLT x13 = (x4 * imu_z) + (-1 * x1 * imu_w) + (x6 * obj_qw) + (-1 * x2 * imu_x);
	const GEN_FLT x14 = (x7 * x11) + (-1 * x9 * x13) + (x8 * x10);
	const GEN_FLT x15 = (-1 * x5 * x8) + (x7 * x9) + (x13 * x11);
	out[0] = (acc_scale * (x9 + (2 * ((x14 * x13) + (-1 * x5 * x12))))) + acc_biasx;
	out[1] = (acc_scale * (x8 + (2 * ((x5 * x15) + (-1 * x14 * x10))))) + acc_biasy;
	out[2] = ((x11 + (2 * ((x12 * x10) + (-1 * x15 * x13)))) * acc_scale) + acc_biasz;
}

// Jacobian of imu_predict_up wrt [obj_px, obj_py, obj_pz, obj_qw, obj_qi, obj_qj, obj_qk, vx, vy, vz, avx, avy, avz, acc_x, acc_y, acc_z, acc_scale, imu_w, imu_x, imu_y, imu_z, acc_biasx, acc_biasy, acc_biasz, gbx, gby, gbz]
static inline void gen_imu_predict_up_jac_kalman_model(FLT* out, const SurviveKalmanModel* kalman_model) {
	const GEN_FLT obj_px = (*kalman_model).Pose.Pos[0];
	const GEN_FLT obj_py = (*kalman_model).Pose.Pos[1];
	const GEN_FLT obj_pz = (*kalman_model).Pose.Pos[2];
	const GEN_FLT obj_qw = (*kalman_model).Pose.Rot[0];
	const GEN_FLT obj_qi = (*kalman_model).Pose.Rot[1];
	const GEN_FLT obj_qj = (*kalman_model).Pose.Rot[2];
	const GEN_FLT obj_qk = (*kalman_model).Pose.Rot[3];
	const GEN_FLT vx = (*kalman_model).Velocity.Pos[0];
	const GEN_FLT vy = (*kalman_model).Velocity.Pos[1];
	const GEN_FLT vz = (*kalman_model).Velocity.Pos[2];
	const GEN_FLT avx = (*kalman_model).Velocity.AxisAngleRot[0];
	const GEN_FLT avy = (*kalman_model).Velocity.AxisAngleRot[1];
	const GEN_FLT avz = (*kalman_model).Velocity.AxisAngleRot[2];
	const GEN_FLT acc_x = (*kalman_model).Acc[0];
	const GEN_FLT acc_y = (*kalman_model).Acc[1];
	const GEN_FLT acc_z = (*kalman_model).Acc[2];
	const GEN_FLT acc_scale = (*kalman_model).AccScale;
	const GEN_FLT imu_w = (*kalman_model).IMUCorrection[0];
	const GEN_FLT imu_x = (*kalman_model).IMUCorrection[1];
	const GEN_FLT imu_y = (*kalman_model).IMUCorrection[2];
	const GEN_FLT imu_z = (*kalman_model).IMUCorrection[3];
	const GEN_FLT acc_biasx = (*kalman_model).AccBias[0];
	const GEN_FLT acc_biasy = (*kalman_model).AccBias[1];
	const GEN_FLT acc_biasz = (*kalman_model).AccBias[2];
	const GEN_FLT gbx = (*kalman_model).GyroBias[0];
	const GEN_FLT gby = (*kalman_model).GyroBias[1];
	const GEN_FLT gbz = (*kalman_model).GyroBias[2];
	const GEN_FLT x0 = obj_qw * obj_qw;
	const GEN_FLT x1 = obj_qk * obj_qk;
	const GEN_FLT x2 = obj_qj * obj_qj;
	const GEN_FLT x3 = obj_qi * obj_qi;
	const GEN_FLT x4 = 1e-11 + x2 + x3 + x0 + x1;
	const GEN_FLT x5 = 1. / sqrt(x4);
	const GEN_FLT x6 = imu_z * imu_z;
	const GEN_FLT x7 = imu_y * imu_y;
	const GEN_FLT x8 = imu_w * imu_w;
	const GEN_FLT x9 = imu_x * imu_x;
	const GEN_FLT x10 = 1e-11 + x8 + x9 + x6 + x7;
	const GEN_FLT x11 = 1. / sqrt(x10);
	const GEN_FLT x12 = x5 * x11;
	const GEN_FLT x13 = x12 * imu_z;
	const GEN_FLT x14 = (1. / (x4 * sqrt(x4))) * x11;
	const GEN_FLT x15 = x14 * imu_z;
	const GEN_FLT x16 = x14 * imu_y;
	const GEN_FLT x17 = obj_qw * obj_qi;
	const GEN_FLT x18 = x17 * x16;
	const GEN_FLT x19 = x14 * imu_x;
	const GEN_FLT x20 = x19 * obj_qj;
	const GEN_FLT x21 = -1 * x20 * obj_qw;
	const GEN_FLT x22 = x14 * imu_w;
	const GEN_FLT x23 = x22 * obj_qk;
	const GEN_FLT x24 = x23 * obj_qw;
	const GEN_FLT x25 = x24 + x21 + x13 + x18 + (-1 * x0 * x15);
	const GEN_FLT x26 = x13 * obj_qk;
	const GEN_FLT x27 = x12 * imu_y;
	const GEN_FLT x28 = x27 * obj_qj;
	const GEN_FLT x29 = x12 * imu_w;
	const GEN_FLT x30 = x29 * obj_qw;
	const GEN_FLT x31 = x12 * imu_x;
	const GEN_FLT x32 = x31 * obj_qi;
	const GEN_FLT x33 = x30 + x26 + x32 + x28;
	const GEN_FLT x34 = 0.101971621297793 * acc_y;
	const GEN_FLT x35 = x31 * obj_qj;
	const GEN_FLT x36 = x29 * obj_qk;
	const GEN_FLT x37 = x13 * obj_qw;
	const GEN_FLT x38 = x27 * obj_qi;
	const GEN_FLT x39 = (-1 * x38) + x37 + x35 + (-1 * x36);
	const GEN_FLT x40 = 0.101971621297793 * acc_x;
	const GEN_FLT x41 = x27 * obj_qk;
	const GEN_FLT x42 = x13 * obj_qj;
	const GEN_FLT x43 = x31 * obj_qw;
	const GEN_FLT x44 = x29 * obj_qi;
	const GEN_FLT x45 = (-1 * x44) + x43 + x41 + (-1 * x42);
	const GEN_FLT x46 = 1 + (0.101971621297793 * acc_z);
	const GEN_FLT x47 = (-1 * x45 * x46) + (x34 * x33) + (x40 * x39);
	const GEN_FLT x48 = 2 * x47;
	const GEN_FLT x49 = x22 * x17;
	const GEN_FLT x50 = x16 * obj_qk;
	const GEN_FLT x51 = -1 * x50 * obj_qw;
	const GEN_FLT x52 = x15 * obj_qw;
	const GEN_FLT x53 = x52 * obj_qj;
	const GEN_FLT x54 = x51 + x49 + x53 + (-1 * x0 * x19) + x31;
	const GEN_FLT x55 = -1 * x19 * x17;
	const GEN_FLT x56 = -1 * x52 * obj_qk;
	const GEN_FLT x57 = x16 * obj_qj;
	const GEN_FLT x58 = -1 * x57 * obj_qw;
	const GEN_FLT x59 = x58 + x56 + x55 + x29 + (-1 * x0 * x22);
	const GEN_FLT x60 = (x40 * x25) + (-1 * x54 * x46) + (x59 * x34);
	const GEN_FLT x61 = 2 * x39;
	const GEN_FLT x62 = x22 * obj_qj;
	const GEN_FLT x63 = x62 * obj_qw;
	const GEN_FLT x64 = x19 * obj_qk;
	const GEN_FLT x65 = x64 * obj_qw;
	const GEN_FLT x66 = -1 * x15 * x17;
	const GEN_FLT x67 = (-1 * x0 * x16) + x66 + x63 + x27 + x65;
	const GEN_FLT x68 = x27 * obj_qw;
	const GEN_FLT x69 = x31 * obj_qk;
	const GEN_FLT x70 = x29 * obj_qj;
	const GEN_FLT x71 = x13 * obj_qi;
	const GEN_FLT x72 = x71 + (-1 * x70) + x68 + (-1 * x69);
	const GEN_FLT x73 = (-1 * x72 * x40) + (x46 * x33) + (x45 * x34);
	const GEN_FLT x74 = 2 * x73;
	const GEN_FLT x75 = (x54 * x34) + (-1 * x67 * x40) + (x59 * x46);
	const GEN_FLT x76 = 2 * x72;
	const GEN_FLT x77 = -1 * x20 * obj_qi;
	const GEN_FLT x78 = x23 * obj_qi;
	const GEN_FLT x79 = x78 + x77 + (-1 * x27) + x66 + (x3 * x16);
	const GEN_FLT x80 = x15 * obj_qi;
	const GEN_FLT x81 = -1 * x80 * obj_qk;
	const GEN_FLT x82 = x57 * obj_qi;
	const GEN_FLT x83 = x81 + (-1 * x49) + (-1 * x82) + x31 + (-1 * x3 * x19);
	const GEN_FLT x84 = x62 * obj_qi;
	const GEN_FLT x85 = x64 * obj_qi;
	const GEN_FLT x86 = x85 + (-1 * x18) + x13 + x84 + (-1 * x3 * x15);
	const GEN_FLT x87 = -1 * x29;
	const GEN_FLT x88 = x50 * obj_qi;
	const GEN_FLT x89 = x80 * obj_qj;
	const GEN_FLT x90 = x89 + x87 + (-1 * x88) + x55 + (x3 * x22);
	const GEN_FLT x91 = (x90 * x34) + (x83 * x46) + (-1 * x86 * x40);
	const GEN_FLT x92 = (x79 * x40) + (x83 * x34) + (-1 * x90 * x46);
	const GEN_FLT x93 = x23 * obj_qj;
	const GEN_FLT x94 = x93 + x31 + (-1 * x2 * x19) + x82 + (-1 * x53);
	const GEN_FLT x95 = -1 * x50 * obj_qj;
	const GEN_FLT x96 = (x2 * x15) + x84 + x95 + x21 + (-1 * x13);
	const GEN_FLT x97 = obj_qk * obj_qj;
	const GEN_FLT x98 = x97 * x15;
	const GEN_FLT x99 = (-1 * x98) + (-1 * x2 * x16) + (-1 * x63) + x77 + x27;
	const GEN_FLT x100 = (x94 * x40) + (-1 * x96 * x46) + (x99 * x34);
	const GEN_FLT x101 = x97 * x19;
	const GEN_FLT x102 = x101 + (-1 * x89) + x58 + (x2 * x22) + x87;
	const GEN_FLT x103 = (x96 * x34) + (-1 * x40 * x102) + (x99 * x46);
	const GEN_FLT x104 = (x1 * x22) + x56 + (-1 * x101) + x88 + x87;
	const GEN_FLT x105 = x51 + (-1 * x31) + x81 + (x1 * x19) + x93;
	const GEN_FLT x106 = x13 + (-1 * x1 * x15) + (-1 * x24) + (-1 * x85) + x95;
	const GEN_FLT x107 = x98 + (-1 * x1 * x16) + x27 + (-1 * x65) + x78;
	const GEN_FLT x108 = (x46 * x106) + (x34 * x107) + (-1 * x40 * x105);
	const GEN_FLT x109 = (x40 * x104) + (-1 * x46 * x107) + (x34 * x106);
	const GEN_FLT x110 = 0.101971621297793 * x36;
	const GEN_FLT x111 = 0.101971621297793 * x37;
	const GEN_FLT x112 = 0.101971621297793 * x38;
	const GEN_FLT x113 = 0.101971621297793 * x35;
	const GEN_FLT x114 = x113 + (-1 * x112) + (-1 * x110) + x111;
	const GEN_FLT x115 = (-0.101971621297793 * x71) + (0.101971621297793 * x70) + (-0.101971621297793 * x68) + (0.101971621297793 * x69);
	const GEN_FLT x116 = (0.101971621297793 * x30) + (0.101971621297793 * x32) + (0.101971621297793 * x28) + (0.101971621297793 * x26);
	const GEN_FLT x117 = x61 * x116;
	const GEN_FLT x118 = (0.101971621297793 * x43) + (-0.101971621297793 * x44) + (-0.101971621297793 * x42) + (0.101971621297793 * x41);
	const GEN_FLT x119 = 0.203943242595586 * x45;
	const GEN_FLT x120 = 0.203943242595586 * x72;
	const GEN_FLT x121 = x5 * (1. / (x10 * sqrt(x10)));
	const GEN_FLT x122 = x121 * imu_w;
	const GEN_FLT x123 = x122 * imu_z;
	const GEN_FLT x124 = -1 * x123 * obj_qw;
	const GEN_FLT x125 = x12 * obj_qk;
	const GEN_FLT x126 = -1 * x125;
	const GEN_FLT x127 = x121 * obj_qj;
	const GEN_FLT x128 = x127 * imu_w;
	const GEN_FLT x129 = x128 * imu_x;
	const GEN_FLT x130 = x122 * imu_y;
	const GEN_FLT x131 = x130 * obj_qi;
	const GEN_FLT x132 = x8 * x121;
	const GEN_FLT x133 = (x132 * obj_qk) + x131 + x124 + (-1 * x129) + x126;
	const GEN_FLT x134 = x123 * obj_qi;
	const GEN_FLT x135 = x12 * obj_qj;
	const GEN_FLT x136 = -1 * x135;
	const GEN_FLT x137 = -1 * x130 * obj_qw;
	const GEN_FLT x138 = x122 * imu_x;
	const GEN_FLT x139 = x138 * obj_qk;
	const GEN_FLT x140 = x137 + x139 + (x132 * obj_qj) + (-1 * x134) + x136;
	const GEN_FLT x141 = x12 * obj_qw;
	const GEN_FLT x142 = x138 * obj_qi;
	const GEN_FLT x143 = imu_z * obj_qk;
	const GEN_FLT x144 = x122 * x143;
	const GEN_FLT x145 = x128 * imu_y;
	const GEN_FLT x146 = (-1 * x144) + (-1 * x142) + (-1 * x145) + x141 + (-1 * x132 * obj_qw);
	const GEN_FLT x147 = x12 * obj_qi;
	const GEN_FLT x148 = -1 * x147;
	const GEN_FLT x149 = -1 * x138 * obj_qw;
	const GEN_FLT x150 = x130 * obj_qk;
	const GEN_FLT x151 = x128 * imu_z;
	const GEN_FLT x152 = x151 + (-1 * x150) + x149 + x148 + (x132 * obj_qi);
	const GEN_FLT x153 = (x34 * x152) + (x46 * x146) + (-1 * x40 * x140);
	const GEN_FLT x154 = (x40 * x133) + (x34 * x146) + (-1 * x46 * x152);
	const GEN_FLT x155 = x121 * imu_y;
	const GEN_FLT x156 = x155 * imu_x;
	const GEN_FLT x157 = x156 * obj_qi;
	const GEN_FLT x158 = x9 * x121;
	const GEN_FLT x159 = x121 * imu_x;
	const GEN_FLT x160 = x159 * imu_z;
	const GEN_FLT x161 = -1 * x160 * obj_qw;
	const GEN_FLT x162 = x135 + (-1 * x158 * obj_qj) + x157 + x161 + x139;
	const GEN_FLT x163 = x143 * x159;
	const GEN_FLT x164 = x127 * imu_x;
	const GEN_FLT x165 = -1 * x164 * imu_y;
	const GEN_FLT x166 = x147 + (-1 * x163) + x165 + (-1 * x158 * obj_qi) + x149;
	const GEN_FLT x167 = x156 * obj_qk;
	const GEN_FLT x168 = x164 * imu_z;
	const GEN_FLT x169 = x168 + (-1 * x167) + x141 + x142 + (-1 * x158 * obj_qw);
	const GEN_FLT x170 = (x40 * x162) + (x34 * x166) + (-1 * x46 * x169);
	const GEN_FLT x171 = -1 * x160 * obj_qi;
	const GEN_FLT x172 = -1 * x156 * obj_qw;
	const GEN_FLT x173 = (x158 * obj_qk) + x172 + x171 + x126 + x129;
	const GEN_FLT x174 = (x34 * x169) + (-1 * x40 * x173) + (x46 * x166);
	const GEN_FLT x175 = x7 * x121;
	const GEN_FLT x176 = imu_y * imu_z;
	const GEN_FLT x177 = x121 * x176;
	const GEN_FLT x178 = -1 * x177 * obj_qw;
	const GEN_FLT x179 = x148 + x150 + (x175 * obj_qi) + x165 + x178;
	const GEN_FLT x180 = x127 * x176;
	const GEN_FLT x181 = x125 + (-1 * x175 * obj_qk) + x180 + x131 + x172;
	const GEN_FLT x182 = -1 * x143 * x155;
	const GEN_FLT x183 = x182 + (-1 * x7 * x127) + (-1 * x157) + x137 + x135;
	const GEN_FLT x184 = (x40 * x179) + (-1 * x46 * x181) + (x34 * x183);
	const GEN_FLT x185 = x177 * obj_qi;
	const GEN_FLT x186 = x141 + (-1 * x175 * obj_qw) + (-1 * x185) + x145 + x167;
	const GEN_FLT x187 = (x34 * x181) + (-1 * x40 * x186) + (x46 * x183);
	const GEN_FLT x188 = x6 * x121;
	const GEN_FLT x189 = (-1 * x168) + x144 + (-1 * x188 * obj_qw) + x141 + x185;
	const GEN_FLT x190 = x182 + x136 + (x6 * x127) + x134 + x161;
	const GEN_FLT x191 = x125 + (-1 * x188 * obj_qk) + x171 + (-1 * x180) + x124;
	const GEN_FLT x192 = (x40 * x189) + (-1 * x46 * x190) + (x34 * x191);
	const GEN_FLT x193 = (-1 * x188 * obj_qi) + x178 + x163 + x147 + x151;
	const GEN_FLT x194 = (x34 * x190) + (-1 * x40 * x193) + (x46 * x191);
	const GEN_FLT x195 = 2 * x45;
	const GEN_FLT x196 = (-1 * x34 * x39) + (x40 * x33) + (x72 * x46);
	const GEN_FLT x197 = 2 * x196;
	const GEN_FLT x198 = (x67 * x46) + (-1 * x34 * x25) + (x59 * x40);
	const GEN_FLT x199 = (-1 * x79 * x34) + (x86 * x46) + (x83 * x40);
	const GEN_FLT x200 = (x46 * x102) + (-1 * x94 * x34) + (x99 * x40);
	const GEN_FLT x201 = (-1 * x34 * x104) + (x46 * x105) + (x40 * x106);
	const GEN_FLT x202 = (-1 * x113) + x112 + x110 + (-1 * x111);
	const GEN_FLT x203 = (x46 * x140) + (-1 * x34 * x133) + (x40 * x146);
	const GEN_FLT x204 = (x46 * x173) + (-1 * x34 * x162) + (x40 * x166);
	const GEN_FLT x205 = (x46 * x186) + (-1 * x34 * x179) + (x40 * x183);
	const GEN_FLT x206 = (x46 * x193) + (x40 * x191) + (-1 * x34 * x189);
	out[0] = 0;
	out[1] = 0;
	out[2] = 0;
	out[3] = ((x74 * x67) + (x75 * x76) + (-1 * x48 * x25) + (-1 * x60 * x61)) * acc_scale;
	out[4] = ((x86 * x74) + (-1 * x61 * x92) + (-1 * x79 * x48) + (x76 * x91)) * acc_scale;
	out[5] = acc_scale * ((x74 * x102) + (x76 * x103) + (-1 * x94 * x48) + (-1 * x61 * x100));
	out[6] = ((x76 * x108) + (-1 * x48 * x104) + (-1 * x61 * x109) + (x74 * x105)) * acc_scale;
	out[7] = 0;
	out[8] = 0;
	out[9] = 0;
	out[10] = 0;
	out[11] = 0;
	out[12] = 0;
	out[13] = acc_scale * (0.101971621297793 + (x76 * x115) + (-1 * x61 * x114));
	out[14] = acc_scale * ((x76 * x118) + (-1 * x117));
	out[15] = ((x33 * x120) + (x39 * x119)) * acc_scale;
	out[16] = x40 + (2 * ((x73 * x72) + (-1 * x47 * x39)));
	out[17] = ((x76 * x153) + (-1 * x48 * x133) + (-1 * x61 * x154) + (x74 * x140)) * acc_scale;
	out[18] = ((x76 * x174) + (x74 * x173) + (-1 * x48 * x162) + (-1 * x61 * x170)) * acc_scale;
	out[19] = ((x74 * x186) + (-1 * x48 * x179) + (x76 * x187) + (-1 * x61 * x184)) * acc_scale;
	out[20] = ((x76 * x194) + (x74 * x193) + (-1 * x48 * x189) + (-1 * x61 * x192)) * acc_scale;
	out[21] = 1;
	out[22] = 0;
	out[23] = 0;
	out[24] = 0;
	out[25] = 0;
	out[26] = 0;
	out[27] = 0;
	out[28] = 0;
	out[29] = 0;
	out[30] = acc_scale * ((x25 * x197) + (x61 * x198) + (-1 * x74 * x54) + (-1 * x75 * x195));
	out[31] = acc_scale * ((x61 * x199) + (-1 * x74 * x90) + (-1 * x91 * x195) + (x79 * x197));
	out[32] = acc_scale * ((x61 * x200) + (x94 * x197) + (-1 * x74 * x96) + (-1 * x103 * x195));
	out[33] = ((x61 * x201) + (-1 * x74 * x107) + (-1 * x108 * x195) + (x104 * x197)) * acc_scale;
	out[34] = 0;
	out[35] = 0;
	out[36] = 0;
	out[37] = 0;
	out[38] = 0;
	out[39] = 0;
	out[40] = acc_scale * (x117 + (-1 * x115 * x195));
	out[41] = acc_scale * (0.101971621297793 + (x61 * x202) + (-1 * x118 * x195));
	out[42] = ((x39 * x120) + (-1 * x33 * x119)) * acc_scale;
	out[43] = x34 + (2 * ((x39 * x196) + (-1 * x73 * x45)));
	out[44] = ((x61 * x203) + (-1 * x74 * x152) + (x197 * x133) + (-1 * x195 * x153)) * acc_scale;
	out[45] = ((-1 * x174 * x195) + (x162 * x197) + (-1 * x74 * x169) + (x61 * x204)) * acc_scale;
	out[46] = ((-1 * x187 * x195) + (x179 * x197) + (x61 * x205) + (-1 * x74 * x181)) * acc_scale;
	out[47] = ((x61 * x206) + (x189 * x197) + (-1 * x74 * x190) + (-1 * x194 * x195)) * acc_scale;
	out[48] = 0;
	out[49] = 1;
	out[50] = 0;
	out[51] = 0;
	out[52] = 0;
	out[53] = 0;
	out[54] = 0;
	out[55] = 0;
	out[56] = 0;
	out[57] = acc_scale * ((x54 * x48) + (x60 * x195) + (-1 * x67 * x197) + (-1 * x76 * x198));
	out[58] = acc_scale * ((x92 * x195) + (-1 * x76 * x199) + (x90 * x48) + (-1 * x86 * x197));
	out[59] = acc_scale * ((-1 * x76 * x200) + (x96 * x48) + (-1 * x102 * x197) + (x100 * x195));
	out[60] = ((x109 * x195) + (x48 * x107) + (-1 * x105 * x197) + (-1 * x76 * x201)) * acc_scale;
	out[61] = 0;
	out[62] = 0;
	out[63] = 0;
	out[64] = 0;
	out[65] = 0;
	out[66] = 0;
	out[67] = acc_scale * ((x114 * x195) + (-1 * x76 * x116));
	out[68] = acc_scale * ((x116 * x195) + (-1 * x76 * x202));
	out[69] = acc_scale * (0.101971621297793 + (-0.203943242595586 * (x45 * x45)) + (-0.203943242595586 * (x72 * x72)));
	out[70] = x46 + (2 * ((x45 * x47) + (-1 * x72 * x196)));
	out[71] = ((x48 * x152) + (-1 * x197 * x140) + (x195 * x154) + (-1 * x76 * x203)) * acc_scale;
	out[72] = ((x170 * x195) + (-1 * x173 * x197) + (x48 * x169) + (-1 * x76 * x204)) * acc_scale;
	out[73] = ((x184 * x195) + (x48 * x181) + (-1 * x186 * x197) + (-1 * x76 * x205)) * acc_scale;
	out[74] = ((x192 * x195) + (x48 * x190) + (-1 * x197 * x193) + (-1 * x76 * x206)) * acc_scale;
	out[75] = 0;
	out[76] = 0;
	out[77] = 1;
	out[78] = 0;
	out[79] = 0;
	out[80] = 0;
}

static inline void gen_quatrotateabout(FLT* out, const FLT* q1, const FLT* q2) {
	const GEN_FLT obj_qw = q1[0];
	const GEN_FLT obj_qi = q1[1];
	const GEN_FLT obj_qj = q1[2];
	const GEN_FLT obj_qk = q1[3];
	const GEN_FLT q1_w = q2[0];
	const GEN_FLT q1_x = q2[1];
	const GEN_FLT q1_y = q2[2];
	const GEN_FLT q1_z = q2[3];

	out[0] = (-1 * q1_x * obj_qi) + (q1_w * obj_qw) + (-1 * q1_z * obj_qk) + (-1 * q1_y * obj_qj);
	out[1] = (q1_w * obj_qi) + (q1_z * obj_qj) + (q1_x * obj_qw) + (-1 * q1_y * obj_qk);
	out[2] = (-1 * q1_z * obj_qi) + (q1_x * obj_qk) + (q1_y * obj_qw) + (q1_w * obj_qj);
	out[3] = (q1_y * obj_qi) + (q1_z * obj_qw) + (q1_w * obj_qk) + (-1 * q1_x * obj_qj);
}

// Jacobian of quatrotateabout wrt [obj_qw, obj_qi, obj_qj, obj_qk]
static inline void gen_quatrotateabout_jac_q1(FLT* out, const FLT* q1, const FLT* q2) {
	const GEN_FLT obj_qw = q1[0];
	const GEN_FLT obj_qi = q1[1];
	const GEN_FLT obj_qj = q1[2];
	const GEN_FLT obj_qk = q1[3];
	const GEN_FLT q1_w = q2[0];
	const GEN_FLT q1_x = q2[1];
	const GEN_FLT q1_y = q2[2];
	const GEN_FLT q1_z = q2[3];
	const GEN_FLT x0 = -1 * q1_x;
	const GEN_FLT x1 = -1 * q1_y;
	const GEN_FLT x2 = -1 * q1_z;
	out[0] = q1_w;
	out[1] = x0;
	out[2] = x1;
	out[3] = x2;
	out[4] = q1_x;
	out[5] = q1_w;
	out[6] = q1_z;
	out[7] = x1;
	out[8] = q1_y;
	out[9] = x2;
	out[10] = q1_w;
	out[11] = q1_x;
	out[12] = q1_z;
	out[13] = q1_y;
	out[14] = x0;
	out[15] = q1_w;
}

// Jacobian of quatrotateabout wrt [q1_w, q1_x, q1_y, q1_z]
static inline void gen_quatrotateabout_jac_q2(FLT* out, const FLT* q1, const FLT* q2) {
	const GEN_FLT obj_qw = q1[0];
	const GEN_FLT obj_qi = q1[1];
	const GEN_FLT obj_qj = q1[2];
	const GEN_FLT obj_qk = q1[3];
	const GEN_FLT q1_w = q2[0];
	const GEN_FLT q1_x = q2[1];
	const GEN_FLT q1_y = q2[2];
	const GEN_FLT q1_z = q2[3];
	const GEN_FLT x0 = -1 * obj_qi;
	const GEN_FLT x1 = -1 * obj_qj;
	const GEN_FLT x2 = -1 * obj_qk;
	out[0] = obj_qw;
	out[1] = x0;
	out[2] = x1;
	out[3] = x2;
	out[4] = obj_qi;
	out[5] = obj_qw;
	out[6] = x2;
	out[7] = obj_qj;
	out[8] = obj_qj;
	out[9] = obj_qk;
	out[10] = obj_qw;
	out[11] = x0;
	out[12] = obj_qk;
	out[13] = x1;
	out[14] = obj_qi;
	out[15] = obj_qw;
}

static inline void gen_imu_predict(FLT* out, const SurviveKalmanModel* kalman_model) {
	const GEN_FLT obj_px = (*kalman_model).Pose.Pos[0];
	const GEN_FLT obj_py = (*kalman_model).Pose.Pos[1];
	const GEN_FLT obj_pz = (*kalman_model).Pose.Pos[2];
	const GEN_FLT obj_qw = (*kalman_model).Pose.Rot[0];
	const GEN_FLT obj_qi = (*kalman_model).Pose.Rot[1];
	const GEN_FLT obj_qj = (*kalman_model).Pose.Rot[2];
	const GEN_FLT obj_qk = (*kalman_model).Pose.Rot[3];
	const GEN_FLT vx = (*kalman_model).Velocity.Pos[0];
	const GEN_FLT vy = (*kalman_model).Velocity.Pos[1];
	const GEN_FLT vz = (*kalman_model).Velocity.Pos[2];
	const GEN_FLT avx = (*kalman_model).Velocity.AxisAngleRot[0];
	const GEN_FLT avy = (*kalman_model).Velocity.AxisAngleRot[1];
	const GEN_FLT avz = (*kalman_model).Velocity.AxisAngleRot[2];
	const GEN_FLT acc_x = (*kalman_model).Acc[0];
	const GEN_FLT acc_y = (*kalman_model).Acc[1];
	const GEN_FLT acc_z = (*kalman_model).Acc[2];
	const GEN_FLT acc_scale = (*kalman_model).AccScale;
	const GEN_FLT imu_w = (*kalman_model).IMUCorrection[0];
	const GEN_FLT imu_x = (*kalman_model).IMUCorrection[1];
	const GEN_FLT imu_y = (*kalman_model).IMUCorrection[2];
	const GEN_FLT imu_z = (*kalman_model).IMUCorrection[3];
	const GEN_FLT acc_biasx = (*kalman_model).AccBias[0];
	const GEN_FLT acc_biasy = (*kalman_model).AccBias[1];
	const GEN_FLT acc_biasz = (*kalman_model).AccBias[2];
	const GEN_FLT gbx = (*kalman_model).GyroBias[0];
	const GEN_FLT gby = (*kalman_model).GyroBias[1];
	const GEN_FLT gbz = (*kalman_model).GyroBias[2];
	const GEN_FLT x0 = (1. / sqrt(1e-11 + (obj_qw * obj_qw) + (obj_qi * obj_qi) + (obj_qj * obj_qj) + (obj_qk * obj_qk))) * (1. / sqrt(1e-11 + (imu_x * imu_x) + (imu_z * imu_z) + (imu_w * imu_w) + (imu_y * imu_y)));
	const GEN_FLT x1 = x0 * obj_qj;
	const GEN_FLT x2 = x0 * obj_qk;
	const GEN_FLT x3 = x0 * imu_z;
	const GEN_FLT x4 = x0 * imu_y;
	const GEN_FLT x5 = (-1 * x4 * obj_qi) + (x1 * imu_x) + (x3 * obj_qw) + (-1 * x2 * imu_w);
	const GEN_FLT x6 = x0 * imu_w;
	const GEN_FLT x7 = x0 * imu_x;
	const GEN_FLT x8 = (x7 * obj_qi) + (x6 * obj_qw) + (x2 * imu_z) + (x1 * imu_y);
	const GEN_FLT x9 = 0.101971621297793 * acc_y;
	const GEN_FLT x10 = 0.101971621297793 * acc_x;
	const GEN_FLT x11 = (-1 * x6 * obj_qi) + (x4 * obj_qk) + (x7 * obj_qw) + (-1 * x1 * imu_z);
	const GEN_FLT x12 = 1 + (0.101971621297793 * acc_z);
	const GEN_FLT x13 = (-1 * x12 * x11) + (x8 * x9) + (x5 * x10);
	const GEN_FLT x14 = (x3 * obj_qi) + (-1 * x1 * imu_w) + (x4 * obj_qw) + (-1 * x2 * imu_x);
	const GEN_FLT x15 = (-1 * x14 * x10) + (x8 * x12) + (x9 * x11);
	const GEN_FLT x16 = (-1 * x5 * x9) + (x8 * x10) + (x14 * x12);
	const GEN_FLT x17 = (-1 * x11 * avz) + (x5 * avx) + (x8 * avy);
	const GEN_FLT x18 = (-1 * x14 * avx) + (x8 * avz) + (x11 * avy);
	const GEN_FLT x19 = (-1 * x5 * avy) + (x8 * avx) + (x14 * avz);
	out[0] = (acc_scale * (x10 + (2 * ((x15 * x14) + (-1 * x5 * x13))))) + acc_biasx;
	out[1] = (acc_scale * (x9 + (2 * ((x5 * x16) + (-1 * x15 * x11))))) + acc_biasy;
	out[2] = ((x12 + (2 * ((x13 * x11) + (-1 * x14 * x16)))) * acc_scale) + acc_biasz;
	out[3] = (2 * ((x14 * x18) + (-1 * x5 * x17))) + gbx + avx;
	out[4] = (2 * ((x5 * x19) + (-1 * x11 * x18))) + gby + avy;
	out[5] = (2 * ((x11 * x17) + (-1 * x14 * x19))) + gbz + avz;
}

// Jacobian of imu_predict wrt [obj_px, obj_py, obj_pz, obj_qw, obj_qi, obj_qj, obj_qk, vx, vy, vz, avx, avy, avz, acc_x, acc_y, acc_z, acc_scale, imu_w, imu_x, imu_y, imu_z, acc_biasx, acc_biasy, acc_biasz, gbx, gby, gbz]
static inline void gen_imu_predict_jac_kalman_model(FLT* out, const SurviveKalmanModel* kalman_model) {
	const GEN_FLT obj_px = (*kalman_model).Pose.Pos[0];
	const GEN_FLT obj_py = (*kalman_model).Pose.Pos[1];
	const GEN_FLT obj_pz = (*kalman_model).Pose.Pos[2];
	const GEN_FLT obj_qw = (*kalman_model).Pose.Rot[0];
	const GEN_FLT obj_qi = (*kalman_model).Pose.Rot[1];
	const GEN_FLT obj_qj = (*kalman_model).Pose.Rot[2];
	const GEN_FLT obj_qk = (*kalman_model).Pose.Rot[3];
	const GEN_FLT vx = (*kalman_model).Velocity.Pos[0];
	const GEN_FLT vy = (*kalman_model).Velocity.Pos[1];
	const GEN_FLT vz = (*kalman_model).Velocity.Pos[2];
	const GEN_FLT avx = (*kalman_model).Velocity.AxisAngleRot[0];
	const GEN_FLT avy = (*kalman_model).Velocity.AxisAngleRot[1];
	const GEN_FLT avz = (*kalman_model).Velocity.AxisAngleRot[2];
	const GEN_FLT acc_x = (*kalman_model).Acc[0];
	const GEN_FLT acc_y = (*kalman_model).Acc[1];
	const GEN_FLT acc_z = (*kalman_model).Acc[2];
	const GEN_FLT acc_scale = (*kalman_model).AccScale;
	const GEN_FLT imu_w = (*kalman_model).IMUCorrection[0];
	const GEN_FLT imu_x = (*kalman_model).IMUCorrection[1];
	const GEN_FLT imu_y = (*kalman_model).IMUCorrection[2];
	const GEN_FLT imu_z = (*kalman_model).IMUCorrection[3];
	const GEN_FLT acc_biasx = (*kalman_model).AccBias[0];
	const GEN_FLT acc_biasy = (*kalman_model).AccBias[1];
	const GEN_FLT acc_biasz = (*kalman_model).AccBias[2];
	const GEN_FLT gbx = (*kalman_model).GyroBias[0];
	const GEN_FLT gby = (*kalman_model).GyroBias[1];
	const GEN_FLT gbz = (*kalman_model).GyroBias[2];
	const GEN_FLT x0 = obj_qw * obj_qw;
	const GEN_FLT x1 = obj_qk * obj_qk;
	const GEN_FLT x2 = obj_qj * obj_qj;
	const GEN_FLT x3 = obj_qi * obj_qi;
	const GEN_FLT x4 = 1e-11 + x2 + x3 + x0 + x1;
	const GEN_FLT x5 = 1. / sqrt(x4);
	const GEN_FLT x6 = imu_z * imu_z;
	const GEN_FLT x7 = imu_y * imu_y;
	const GEN_FLT x8 = imu_w * imu_w;
	const GEN_FLT x9 = imu_x * imu_x;
	const GEN_FLT x10 = 1e-11 + x8 + x9 + x6 + x7;
	const GEN_FLT x11 = 1. / sqrt(x10);
	const GEN_FLT x12 = x5 * x11;
	const GEN_FLT x13 = x12 * imu_z;
	const GEN_FLT x14 = (1. / (x4 * sqrt(x4))) * x11;
	const GEN_FLT x15 = x14 * imu_z;
	const GEN_FLT x16 = x14 * imu_y;
	const GEN_FLT x17 = x16 * obj_qw;
	const GEN_FLT x18 = x17 * obj_qi;
	const GEN_FLT x19 = x14 * imu_x;
	const GEN_FLT x20 = x19 * obj_qj;
	const GEN_FLT x21 = -1 * x20 * obj_qw;
	const GEN_FLT x22 = x14 * imu_w;
	const GEN_FLT x23 = x22 * obj_qw;
	const GEN_FLT x24 = x23 * obj_qk;
	const GEN_FLT x25 = x24 + x21 + x13 + x18 + (-1 * x0 * x15);
	const GEN_FLT x26 = x13 * obj_qk;
	const GEN_FLT x27 = x12 * imu_y;
	const GEN_FLT x28 = x27 * obj_qj;
	const GEN_FLT x29 = x12 * imu_w;
	const GEN_FLT x30 = x29 * obj_qw;
	const GEN_FLT x31 = x12 * imu_x;
	const GEN_FLT x32 = x31 * obj_qi;
	const GEN_FLT x33 = x30 + x26 + x32 + x28;
	const GEN_FLT x34 = 0.101971621297793 * acc_y;
	const GEN_FLT x35 = x31 * obj_qj;
	const GEN_FLT x36 = x29 * obj_qk;
	const GEN_FLT x37 = x13 * obj_qw;
	const GEN_FLT x38 = x27 * obj_qi;
	const GEN_FLT x39 = (-1 * x38) + x37 + x35 + (-1 * x36);
	const GEN_FLT x40 = 0.101971621297793 * acc_x;
	const GEN_FLT x41 = x27 * obj_qk;
	const GEN_FLT x42 = x13 * obj_qj;
	const GEN_FLT x43 = x31 * obj_qw;
	const GEN_FLT x44 = x29 * obj_qi;
	const GEN_FLT x45 = (-1 * x44) + x43 + x41 + (-1 * x42);
	const GEN_FLT x46 = 1 + (0.101971621297793 * acc_z);
	const GEN_FLT x47 = (-1 * x45 * x46) + (x34 * x33) + (x40 * x39);
	const GEN_FLT x48 = 2 * x47;
	const GEN_FLT x49 = x23 * obj_qi;
	const GEN_FLT x50 = -1 * x17 * obj_qk;
	const GEN_FLT x51 = x15 * obj_qj;
	const GEN_FLT x52 = x51 * obj_qw;
	const GEN_FLT x53 = x52 + x49 + x50 + (-1 * x0 * x19) + x31;
	const GEN_FLT x54 = x19 * obj_qw;
	const GEN_FLT x55 = -1 * x54 * obj_qi;
	const GEN_FLT x56 = x15 * obj_qw;
	const GEN_FLT x57 = -1 * x56 * obj_qk;
	const GEN_FLT x58 = x16 * obj_qj;
	const GEN_FLT x59 = -1 * x58 * obj_qw;
	const GEN_FLT x60 = x59 + x55 + x57 + x29 + (-1 * x0 * x22);
	const GEN_FLT x61 = (x40 * x25) + (-1 * x53 * x46) + (x60 * x34);
	const GEN_FLT x62 = 2 * x39;
	const GEN_FLT x63 = x23 * obj_qj;
	const GEN_FLT x64 = x54 * obj_qk;
	const GEN_FLT x65 = -1 * x56 * obj_qi;
	const GEN_FLT x66 = (-1 * x0 * x16) + x27 + x65 + x63 + x64;
	const GEN_FLT x67 = x27 * obj_qw;
	const GEN_FLT x68 = x31 * obj_qk;
	const GEN_FLT x69 = x29 * obj_qj;
	const GEN_FLT x70 = x13 * obj_qi;
	const GEN_FLT x71 = x70 + x67 + (-1 * x69) + (-1 * x68);
	const GEN_FLT x72 = (-1 * x71 * x40) + (x46 * x33) + (x45 * x34);
	const GEN_FLT x73 = 2 * x72;
	const GEN_FLT x74 = (-1 * x66 * x40) + (x53 * x34) + (x60 * x46);
	const GEN_FLT x75 = 2 * x71;
	const GEN_FLT x76 = -1 * x20 * obj_qi;
	const GEN_FLT x77 = obj_qk * obj_qi;
	const GEN_FLT x78 = x77 * x22;
	const GEN_FLT x79 = x78 + x65 + (-1 * x27) + x76 + (x3 * x16);
	const GEN_FLT x80 = -1 * x77 * x15;
	const GEN_FLT x81 = x58 * obj_qi;
	const GEN_FLT x82 = x80 + (-1 * x81) + (-1 * x49) + x31 + (-1 * x3 * x19);
	const GEN_FLT x83 = x22 * obj_qj;
	const GEN_FLT x84 = x83 * obj_qi;
	const GEN_FLT x85 = x77 * x19;
	const GEN_FLT x86 = x85 + (-1 * x18) + x13 + x84 + (-1 * x3 * x15);
	const GEN_FLT x87 = -1 * x29;
	const GEN_FLT x88 = x77 * x16;
	const GEN_FLT x89 = x51 * obj_qi;
	const GEN_FLT x90 = x89 + x87 + (-1 * x88) + x55 + (x3 * x22);
	const GEN_FLT x91 = (x90 * x34) + (x82 * x46) + (-1 * x86 * x40);
	const GEN_FLT x92 = (x79 * x40) + (x82 * x34) + (-1 * x90 * x46);
	const GEN_FLT x93 = x83 * obj_qk;
	const GEN_FLT x94 = x31 + (-1 * x2 * x19) + x81 + x93 + (-1 * x52);
	const GEN_FLT x95 = -1 * x58 * obj_qk;
	const GEN_FLT x96 = (x2 * x15) + x84 + x95 + x21 + (-1 * x13);
	const GEN_FLT x97 = x51 * obj_qk;
	const GEN_FLT x98 = x76 + (-1 * x97) + (-1 * x2 * x16) + (-1 * x63) + x27;
	const GEN_FLT x99 = (x94 * x40) + (-1 * x96 * x46) + (x98 * x34);
	const GEN_FLT x100 = x20 * obj_qk;
	const GEN_FLT x101 = x59 + x100 + (-1 * x89) + (x2 * x22) + x87;
	const GEN_FLT x102 = (x96 * x34) + (-1 * x40 * x101) + (x98 * x46);
	const GEN_FLT x103 = (x1 * x22) + (-1 * x100) + x57 + x88 + x87;
	const GEN_FLT x104 = x50 + (-1 * x31) + x80 + (x1 * x19) + x93;
	const GEN_FLT x105 = x13 + (-1 * x1 * x15) + (-1 * x24) + (-1 * x85) + x95;
	const GEN_FLT x106 = x97 + (-1 * x1 * x16) + (-1 * x64) + x27 + x78;
	const GEN_FLT x107 = (x34 * x106) + (x46 * x105) + (-1 * x40 * x104);
	const GEN_FLT x108 = (-1 * x46 * x106) + (x40 * x103) + (x34 * x105);
	const GEN_FLT x109 = 0.101971621297793 * x36;
	const GEN_FLT x110 = 0.101971621297793 * x37;
	const GEN_FLT x111 = 0.101971621297793 * x38;
	const GEN_FLT x112 = 0.101971621297793 * x35;
	const GEN_FLT x113 = x112 + (-1 * x111) + (-1 * x109) + x110;
	const GEN_FLT x114 = (-0.101971621297793 * x70) + (-0.101971621297793 * x67) + (0.101971621297793 * x69) + (0.101971621297793 * x68);
	const GEN_FLT x115 = (0.101971621297793 * x30) + (0.101971621297793 * x32) + (0.101971621297793 * x28) + (0.101971621297793 * x26);
	const GEN_FLT x116 = x62 * x115;
	const GEN_FLT x117 = (0.101971621297793 * x43) + (-0.101971621297793 * x44) + (-0.101971621297793 * x42) + (0.101971621297793 * x41);
	const GEN_FLT x118 = 0.203943242595586 * x45;
	const GEN_FLT x119 = 0.203943242595586 * x71;
	const GEN_FLT x120 = x5 * (1. / (x10 * sqrt(x10)));
	const GEN_FLT x121 = x120 * obj_qw;
	const GEN_FLT x122 = imu_w * imu_z;
	const GEN_FLT x123 = -1 * x122 * x121;
	const GEN_FLT x124 = x12 * obj_qk;
	const GEN_FLT x125 = -1 * x124;
	const GEN_FLT x126 = x120 * obj_qj;
	const GEN_FLT x127 = imu_w * imu_x;
	const GEN_FLT x128 = x127 * x126;
	const GEN_FLT x129 = imu_w * imu_y;
	const GEN_FLT x130 = x120 * obj_qi;
	const GEN_FLT x131 = x129 * x130;
	const GEN_FLT x132 = x120 * obj_qk;
	const GEN_FLT x133 = (x8 * x132) + x131 + (-1 * x128) + x123 + x125;
	const GEN_FLT x134 = x122 * x130;
	const GEN_FLT x135 = x12 * obj_qj;
	const GEN_FLT x136 = -1 * x135;
	const GEN_FLT x137 = x8 * x120;
	const GEN_FLT x138 = -1 * x121 * x129;
	const GEN_FLT x139 = x127 * x132;
	const GEN_FLT x140 = (x137 * obj_qj) + x139 + x138 + (-1 * x134) + x136;
	const GEN_FLT x141 = x12 * obj_qw;
	const GEN_FLT x142 = x127 * x130;
	const GEN_FLT x143 = x122 * x132;
	const GEN_FLT x144 = x126 * x129;
	const GEN_FLT x145 = (-1 * x144) + (-1 * x143) + (-1 * x142) + x141 + (-1 * x137 * obj_qw);
	const GEN_FLT x146 = x12 * obj_qi;
	const GEN_FLT x147 = -1 * x146;
	const GEN_FLT x148 = -1 * x121 * x127;
	const GEN_FLT x149 = x129 * x132;
	const GEN_FLT x150 = x122 * x126;
	const GEN_FLT x151 = (-1 * x149) + x148 + x150 + x147 + (x137 * obj_qi);
	const GEN_FLT x152 = (x34 * x151) + (x46 * x145) + (-1 * x40 * x140);
	const GEN_FLT x153 = (x40 * x133) + (x34 * x145) + (-1 * x46 * x151);
	const GEN_FLT x154 = imu_x * imu_y;
	const GEN_FLT x155 = x120 * x154;
	const GEN_FLT x156 = x155 * obj_qi;
	const GEN_FLT x157 = x9 * x120;
	const GEN_FLT x158 = imu_x * imu_z;
	const GEN_FLT x159 = -1 * x121 * x158;
	const GEN_FLT x160 = x135 + x159 + (-1 * x157 * obj_qj) + x156 + x139;
	const GEN_FLT x161 = x132 * x158;
	const GEN_FLT x162 = -1 * x126 * x154;
	const GEN_FLT x163 = x162 + x146 + (-1 * x157 * obj_qi) + (-1 * x161) + x148;
	const GEN_FLT x164 = x132 * x154;
	const GEN_FLT x165 = x126 * x158;
	const GEN_FLT x166 = x142 + x165 + x141 + (-1 * x164) + (-1 * x157 * obj_qw);
	const GEN_FLT x167 = (x40 * x160) + (x34 * x163) + (-1 * x46 * x166);
	const GEN_FLT x168 = -1 * x130 * x158;
	const GEN_FLT x169 = -1 * x155 * obj_qw;
	const GEN_FLT x170 = x169 + x125 + (x9 * x132) + x168 + x128;
	const GEN_FLT x171 = (x34 * x166) + (-1 * x40 * x170) + (x46 * x163);
	const GEN_FLT x172 = x7 * x120;
	const GEN_FLT x173 = imu_y * imu_z;
	const GEN_FLT x174 = x120 * x173;
	const GEN_FLT x175 = -1 * x174 * obj_qw;
	const GEN_FLT x176 = x149 + x162 + x147 + (x172 * obj_qi) + x175;
	const GEN_FLT x177 = x126 * x173;
	const GEN_FLT x178 = (-1 * x7 * x132) + x177 + x124 + x131 + x169;
	const GEN_FLT x179 = -1 * x173 * x132;
	const GEN_FLT x180 = (-1 * x172 * obj_qj) + (-1 * x156) + x179 + x138 + x135;
	const GEN_FLT x181 = (x40 * x176) + (-1 * x46 * x178) + (x34 * x180);
	const GEN_FLT x182 = x174 * obj_qi;
	const GEN_FLT x183 = x141 + (-1 * x172 * obj_qw) + (-1 * x182) + x144 + x164;
	const GEN_FLT x184 = (-1 * x40 * x183) + (x34 * x178) + (x46 * x180);
	const GEN_FLT x185 = x6 * x120;
	const GEN_FLT x186 = x143 + (-1 * x185 * obj_qw) + (-1 * x165) + x141 + x182;
	const GEN_FLT x187 = (x185 * obj_qj) + x136 + x179 + x134 + x159;
	const GEN_FLT x188 = (-1 * x6 * x132) + x124 + x168 + (-1 * x177) + x123;
	const GEN_FLT x189 = (x40 * x186) + (-1 * x46 * x187) + (x34 * x188);
	const GEN_FLT x190 = x161 + (-1 * x185 * obj_qi) + x175 + x146 + x150;
	const GEN_FLT x191 = (x34 * x187) + (-1 * x40 * x190) + (x46 * x188);
	const GEN_FLT x192 = 2 * x45;
	const GEN_FLT x193 = (-1 * x34 * x39) + (x40 * x33) + (x71 * x46);
	const GEN_FLT x194 = 2 * x193;
	const GEN_FLT x195 = (x66 * x46) + (-1 * x34 * x25) + (x60 * x40);
	const GEN_FLT x196 = (x86 * x46) + (-1 * x79 * x34) + (x82 * x40);
	const GEN_FLT x197 = (x46 * x101) + (-1 * x94 * x34) + (x98 * x40);
	const GEN_FLT x198 = (x46 * x104) + (-1 * x34 * x103) + (x40 * x105);
	const GEN_FLT x199 = (-1 * x112) + x111 + x109 + (-1 * x110);
	const GEN_FLT x200 = (-1 * x34 * x133) + (x46 * x140) + (x40 * x145);
	const GEN_FLT x201 = (x46 * x170) + (-1 * x34 * x160) + (x40 * x163);
	const GEN_FLT x202 = (x46 * x183) + (-1 * x34 * x176) + (x40 * x180);
	const GEN_FLT x203 = (x46 * x190) + (x40 * x188) + (-1 * x34 * x186);
	const GEN_FLT x204 = x71 * x71;
	const GEN_FLT x205 = x45 * x45;
	const GEN_FLT x206 = 2 * x187;
	const GEN_FLT x207 = (x39 * avx) + (-1 * x45 * avz) + (x33 * avy);
	const GEN_FLT x208 = 2 * x207;
	const GEN_FLT x209 = (x60 * avy) + (-1 * x53 * avz) + (x25 * avx);
	const GEN_FLT x210 = 2 * ((-1 * x71 * avx) + (x33 * avz) + (x45 * avy));
	const GEN_FLT x211 = (x53 * avy) + (-1 * x66 * avx) + (x60 * avz);
	const GEN_FLT x212 = (-1 * x90 * avz) + (x82 * avy) + (x79 * avx);
	const GEN_FLT x213 = (x90 * avy) + (-1 * x86 * avx) + (x82 * avz);
	const GEN_FLT x214 = (x98 * avy) + (-1 * x96 * avz) + (x94 * avx);
	const GEN_FLT x215 = (x96 * avy) + (x98 * avz) + (-1 * avx * x101);
	const GEN_FLT x216 = (avy * x105) + (-1 * avz * x106) + (avx * x103);
	const GEN_FLT x217 = (avy * x106) + (-1 * avx * x104) + (avz * x105);
	const GEN_FLT x218 = (-1 * x70) + (-1 * x67) + x69 + x68;
	const GEN_FLT x219 = x62 * x33;
	const GEN_FLT x220 = (-1 * x43) + x44 + x42 + (-1 * x41);
	const GEN_FLT x221 = x75 * x33;
	const GEN_FLT x222 = (-1 * avz * x151) + (avy * x145) + (avx * x133);
	const GEN_FLT x223 = (avy * x151) + (-1 * avx * x140) + (avz * x145);
	const GEN_FLT x224 = (avy * x166) + (-1 * avx * x170) + (avz * x163);
	const GEN_FLT x225 = (avy * x163) + (-1 * avz * x166) + (avx * x160);
	const GEN_FLT x226 = (avy * x178) + (-1 * avx * x183) + (avz * x180);
	const GEN_FLT x227 = (avy * x180) + (-1 * avz * x178) + (avx * x176);
	const GEN_FLT x228 = (avy * x188) + (avx * x186) + (-1 * avz * x187);
	const GEN_FLT x229 = (avy * x187) + (avz * x188) + (-1 * avx * x190);
	const GEN_FLT x230 = 2 * ((-1 * x39 * avy) + (x33 * avx) + (x71 * avz));
	const GEN_FLT x231 = (x66 * avz) + (-1 * x25 * avy) + (x60 * avx);
	const GEN_FLT x232 = (x86 * avz) + (-1 * x79 * avy) + (x82 * avx);
	const GEN_FLT x233 = (avz * x101) + (-1 * x94 * avy) + (x98 * avx);
	const GEN_FLT x234 = (avz * x104) + (-1 * avy * x103) + (avx * x105);
	const GEN_FLT x235 = (-1 * x35) + x38 + x36 + (-1 * x37);
	const GEN_FLT x236 = x33 * x192;
	const GEN_FLT x237 = (avz * x140) + (-1 * avy * x133) + (avx * x145);
	const GEN_FLT x238 = (-1 * avy * x160) + (avz * x170) + (avx * x163);
	const GEN_FLT x239 = (-1 * avy * x176) + (avz * x183) + (avx * x180);
	const GEN_FLT x240 = (-1 * avy * x186) + (avz * x190) + (avx * x188);
	out[0] = 0;
	out[1] = 0;
	out[2] = 0;
	out[3] = ((x75 * x74) + (x73 * x66) + (-1 * x48 * x25) + (-1 * x61 * x62)) * acc_scale;
	out[4] = ((x86 * x73) + (-1 * x62 * x92) + (-1 * x79 * x48) + (x75 * x91)) * acc_scale;
	out[5] = ((x73 * x101) + (-1 * x94 * x48) + (x75 * x102) + (-1 * x62 * x99)) * acc_scale;
	out[6] = ((x75 * x107) + (-1 * x48 * x103) + (-1 * x62 * x108) + (x73 * x104)) * acc_scale;
	out[7] = 0;
	out[8] = 0;
	out[9] = 0;
	out[10] = 0;
	out[11] = 0;
	out[12] = 0;
	out[13] = acc_scale * (0.101971621297793 + (x75 * x114) + (-1 * x62 * x113));
	out[14] = acc_scale * ((x75 * x117) + (-1 * x116));
	out[15] = ((x33 * x119) + (x39 * x118)) * acc_scale;
	out[16] = x40 + (2 * ((x71 * x72) + (-1 * x47 * x39)));
	out[17] = ((x75 * x152) + (-1 * x62 * x153) + (-1 * x48 * x133) + (x73 * x140)) * acc_scale;
	out[18] = ((x73 * x170) + (-1 * x48 * x160) + (x75 * x171) + (-1 * x62 * x167)) * acc_scale;
	out[19] = ((x75 * x184) + (x73 * x183) + (-1 * x48 * x176) + (-1 * x62 * x181)) * acc_scale;
	out[20] = ((x73 * x190) + (-1 * x48 * x186) + (x75 * x191) + (-1 * x62 * x189)) * acc_scale;
	out[21] = 1;
	out[22] = 0;
	out[23] = 0;
	out[24] = 0;
	out[25] = 0;
	out[26] = 0;
	out[27] = 0;
	out[28] = 0;
	out[29] = 0;
	out[30] = acc_scale * ((x25 * x194) + (-1 * x73 * x53) + (x62 * x195) + (-1 * x74 * x192));
	out[31] = acc_scale * ((-1 * x91 * x192) + (x62 * x196) + (-1 * x73 * x90) + (x79 * x194));
	out[32] = acc_scale * ((x94 * x194) + (x62 * x197) + (-1 * x73 * x96) + (-1 * x102 * x192));
	out[33] = ((-1 * x107 * x192) + (-1 * x73 * x106) + (x62 * x198) + (x103 * x194)) * acc_scale;
	out[34] = 0;
	out[35] = 0;
	out[36] = 0;
	out[37] = 0;
	out[38] = 0;
	out[39] = 0;
	out[40] = acc_scale * (x116 + (-1 * x114 * x192));
	out[41] = acc_scale * (0.101971621297793 + (x62 * x199) + (-1 * x117 * x192));
	out[42] = ((x39 * x119) + (-1 * x33 * x118)) * acc_scale;
	out[43] = x34 + (2 * ((x39 * x193) + (-1 * x72 * x45)));
	out[44] = ((x62 * x200) + (-1 * x73 * x151) + (x194 * x133) + (-1 * x192 * x152)) * acc_scale;
	out[45] = ((x160 * x194) + (-1 * x171 * x192) + (-1 * x73 * x166) + (x62 * x201)) * acc_scale;
	out[46] = ((-1 * x184 * x192) + (x176 * x194) + (x62 * x202) + (-1 * x73 * x178)) * acc_scale;
	out[47] = ((x62 * x203) + (-1 * x73 * x187) + (x186 * x194) + (-1 * x191 * x192)) * acc_scale;
	out[48] = 0;
	out[49] = 1;
	out[50] = 0;
	out[51] = 0;
	out[52] = 0;
	out[53] = 0;
	out[54] = 0;
	out[55] = 0;
	out[56] = 0;
	out[57] = acc_scale * ((x61 * x192) + (-1 * x66 * x194) + (x53 * x48) + (-1 * x75 * x195));
	out[58] = acc_scale * ((x92 * x192) + (-1 * x75 * x196) + (x90 * x48) + (-1 * x86 * x194));
	out[59] = acc_scale * ((-1 * x75 * x197) + (x96 * x48) + (-1 * x101 * x194) + (x99 * x192));
	out[60] = ((x108 * x192) + (x48 * x106) + (-1 * x104 * x194) + (-1 * x75 * x198)) * acc_scale;
	out[61] = 0;
	out[62] = 0;
	out[63] = 0;
	out[64] = 0;
	out[65] = 0;
	out[66] = 0;
	out[67] = acc_scale * ((x113 * x192) + (-1 * x75 * x115));
	out[68] = acc_scale * ((x115 * x192) + (-1 * x75 * x199));
	out[69] = acc_scale * (0.101971621297793 + (-0.203943242595586 * x205) + (-0.203943242595586 * x204));
	out[70] = x46 + (2 * ((x45 * x47) + (-1 * x71 * x193)));
	out[71] = ((x192 * x153) + (x48 * x151) + (-1 * x194 * x140) + (-1 * x75 * x200)) * acc_scale;
	out[72] = ((x167 * x192) + (x48 * x166) + (-1 * x170 * x194) + (-1 * x75 * x201)) * acc_scale;
	out[73] = ((x181 * x192) + (x48 * x178) + (-1 * x183 * x194) + (-1 * x75 * x202)) * acc_scale;
	out[74] = ((x47 * x206) + (x189 * x192) + (-1 * x190 * x194) + (-1 * x75 * x203)) * acc_scale;
	out[75] = 0;
	out[76] = 0;
	out[77] = 1;
	out[78] = 0;
	out[79] = 0;
	out[80] = 0;
	out[81] = 0;
	out[82] = 0;
	out[83] = 0;
	out[84] = (x66 * x210) + (-1 * x25 * x208) + (x75 * x211) + (-1 * x62 * x209);
	out[85] = (x75 * x213) + (x86 * x210) + (-1 * x79 * x208) + (-1 * x62 * x212);
	out[86] = (x210 * x101) + (-1 * x94 * x208) + (x75 * x215) + (-1 * x62 * x214);
	out[87] = (x75 * x217) + (x210 * x104) + (-1 * x208 * x103) + (-1 * x62 * x216);
	out[88] = 0;
	out[89] = 0;
	out[90] = 0;
	out[91] = 1 + (x75 * x218) + (-2 * (x39 * x39));
	out[92] = (x71 * x192) + (-1 * x219);
	out[93] = x221 + (-1 * x62 * x220);
	out[94] = 0;
	out[95] = 0;
	out[96] = 0;
	out[97] = 0;
	out[98] = (x210 * x140) + (x75 * x223) + (-1 * x208 * x133) + (-1 * x62 * x222);
	out[99] = (-1 * x62 * x225) + (x75 * x224) + (-1 * x208 * x160) + (x210 * x170);
	out[100] = (-1 * x62 * x227) + (x210 * x183) + (-1 * x208 * x176) + (x75 * x226);
	out[101] = (x210 * x190) + (-1 * x62 * x228) + (x75 * x229) + (-1 * x208 * x186);
	out[102] = 0;
	out[103] = 0;
	out[104] = 0;
	out[105] = 1;
	out[106] = 0;
	out[107] = 0;
	out[108] = 0;
	out[109] = 0;
	out[110] = 0;
	out[111] = (x25 * x230) + (-1 * x53 * x210) + (x62 * x231) + (-1 * x211 * x192);
	out[112] = (-1 * x213 * x192) + (x79 * x230) + (-1 * x90 * x210) + (x62 * x232);
	out[113] = (-1 * x215 * x192) + (x62 * x233) + (-1 * x96 * x210) + (x94 * x230);
	out[114] = (x230 * x103) + (x62 * x234) + (-1 * x210 * x106) + (-1 * x217 * x192);
	out[115] = 0;
	out[116] = 0;
	out[117] = 0;
	out[118] = x219 + (-1 * x218 * x192);
	out[119] = 1 + (x62 * x235) + (-2 * x205);
	out[120] = (x71 * x62) + (-1 * x236);
	out[121] = 0;
	out[122] = 0;
	out[123] = 0;
	out[124] = 0;
	out[125] = (-1 * x223 * x192) + (x230 * x133) + (-1 * x210 * x151) + (x62 * x237);
	out[126] = (x62 * x238) + (x230 * x160) + (-1 * x210 * x166) + (-1 * x224 * x192);
	out[127] = (x62 * x239) + (x230 * x176) + (-1 * x210 * x178) + (-1 * x226 * x192);
	out[128] = (-1 * x229 * x192) + (x62 * x240) + (-1 * x210 * x187) + (x230 * x186);
	out[129] = 0;
	out[130] = 0;
	out[131] = 0;
	out[132] = 0;
	out[133] = 1;
	out[134] = 0;
	out[135] = 0;
	out[136] = 0;
	out[137] = 0;
	out[138] = (x209 * x192) + (-1 * x75 * x231) + (x53 * x208) + (-1 * x66 * x230);
	out[139] = (-1 * x75 * x232) + (x90 * x208) + (-1 * x86 * x230) + (x212 * x192);
	out[140] = (x214 * x192) + (x96 * x208) + (-1 * x230 * x101) + (-1 * x75 * x233);
	out[141] = (-1 * x75 * x234) + (x208 * x106) + (-1 * x230 * x104) + (x216 * x192);
	out[142] = 0;
	out[143] = 0;
	out[144] = 0;
	out[145] = (x39 * x192) + (-1 * x221);
	out[146] = x236 + (-1 * x75 * x235);
	out[147] = 1 + (x220 * x192) + (-2 * x204);
	out[148] = 0;
	out[149] = 0;
	out[150] = 0;
	out[151] = 0;
	out[152] = (x222 * x192) + (x208 * x151) + (-1 * x230 * x140) + (-1 * x75 * x237);
	out[153] = (x225 * x192) + (x208 * x166) + (-1 * x230 * x170) + (-1 * x75 * x238);
	out[154] = (x227 * x192) + (-1 * x230 * x183) + (x208 * x178) + (-1 * x75 * x239);
	out[155] = (x228 * x192) + (x206 * x207) + (-1 * x230 * x190) + (-1 * x75 * x240);
	out[156] = 0;
	out[157] = 0;
	out[158] = 0;
	out[159] = 0;
	out[160] = 0;
	out[161] = 1;
}

static inline void gen_imu_predict_gyro(FLT* out, const SurviveKalmanModel* kalman_model) {
	const GEN_FLT obj_px = (*kalman_model).Pose.Pos[0];
	const GEN_FLT obj_py = (*kalman_model).Pose.Pos[1];
	const GEN_FLT obj_pz = (*kalman_model).Pose.Pos[2];
	const GEN_FLT obj_qw = (*kalman_model).Pose.Rot[0];
	const GEN_FLT obj_qi = (*kalman_model).Pose.Rot[1];
	const GEN_FLT obj_qj = (*kalman_model).Pose.Rot[2];
	const GEN_FLT obj_qk = (*kalman_model).Pose.Rot[3];
	const GEN_FLT vx = (*kalman_model).Velocity.Pos[0];
	const GEN_FLT vy = (*kalman_model).Velocity.Pos[1];
	const GEN_FLT vz = (*kalman_model).Velocity.Pos[2];
	const GEN_FLT avx = (*kalman_model).Velocity.AxisAngleRot[0];
	const GEN_FLT avy = (*kalman_model).Velocity.AxisAngleRot[1];
	const GEN_FLT avz = (*kalman_model).Velocity.AxisAngleRot[2];
	const GEN_FLT acc_x = (*kalman_model).Acc[0];
	const GEN_FLT acc_y = (*kalman_model).Acc[1];
	const GEN_FLT acc_z = (*kalman_model).Acc[2];
	const GEN_FLT acc_scale = (*kalman_model).AccScale;
	const GEN_FLT imu_w = (*kalman_model).IMUCorrection[0];
	const GEN_FLT imu_x = (*kalman_model).IMUCorrection[1];
	const GEN_FLT imu_y = (*kalman_model).IMUCorrection[2];
	const GEN_FLT imu_z = (*kalman_model).IMUCorrection[3];
	const GEN_FLT acc_biasx = (*kalman_model).AccBias[0];
	const GEN_FLT acc_biasy = (*kalman_model).AccBias[1];
	const GEN_FLT acc_biasz = (*kalman_model).AccBias[2];
	const GEN_FLT gbx = (*kalman_model).GyroBias[0];
	const GEN_FLT gby = (*kalman_model).GyroBias[1];
	const GEN_FLT gbz = (*kalman_model).GyroBias[2];
	const GEN_FLT x0 = (1. / sqrt(1e-11 + (obj_qw * obj_qw) + (obj_qi * obj_qi) + (obj_qj * obj_qj) + (obj_qk * obj_qk))) * (1. / sqrt(1e-11 + (imu_x * imu_x) + (imu_z * imu_z) + (imu_w * imu_w) + (imu_y * imu_y)));
	const GEN_FLT x1 = x0 * imu_x;
	const GEN_FLT x2 = x0 * imu_w;
	const GEN_FLT x3 = x0 * imu_z;
	const GEN_FLT x4 = x0 * obj_qi;
	const GEN_FLT x5 = (x3 * obj_qw) + (-1 * x4 * imu_y) + (x1 * obj_qj) + (-1 * x2 * obj_qk);
	const GEN_FLT x6 = x0 * imu_y;
	const GEN_FLT x7 = (x4 * imu_x) + (x2 * obj_qw) + (x3 * obj_qk) + (x6 * obj_qj);
	const GEN_FLT x8 = (-1 * x4 * imu_w) + (x1 * obj_qw) + (x6 * obj_qk) + (-1 * x3 * obj_qj);
	const GEN_FLT x9 = (-1 * x8 * avz) + (x5 * avx) + (x7 * avy);
	const GEN_FLT x10 = (x4 * imu_z) + (-1 * x2 * obj_qj) + (x6 * obj_qw) + (-1 * x1 * obj_qk);
	const GEN_FLT x11 = (-1 * x10 * avx) + (x7 * avz) + (x8 * avy);
	const GEN_FLT x12 = (-1 * x5 * avy) + (x7 * avx) + (x10 * avz);
	out[0] = (2 * ((x11 * x10) + (-1 * x5 * x9))) + gbx + avx;
	out[1] = (2 * ((x5 * x12) + (-1 * x8 * x11))) + gby + avy;
	out[2] = (2 * ((x8 * x9) + (-1 * x12 * x10))) + gbz + avz;
}

// Jacobian of imu_predict_gyro wrt [obj_px, obj_py, obj_pz, obj_qw, obj_qi, obj_qj, obj_qk, vx, vy, vz, avx, avy, avz, acc_x, acc_y, acc_z, acc_scale, imu_w, imu_x, imu_y, imu_z, acc_biasx, acc_biasy, acc_biasz, gbx, gby, gbz]
static inline void gen_imu_predict_gyro_jac_kalman_model(FLT* out, const SurviveKalmanModel* kalman_model) {
	const GEN_FLT obj_px = (*kalman_model).Pose.Pos[0];
	const GEN_FLT obj_py = (*kalman_model).Pose.Pos[1];
	const GEN_FLT obj_pz = (*kalman_model).Pose.Pos[2];
	const GEN_FLT obj_qw = (*kalman_model).Pose.Rot[0];
	const GEN_FLT obj_qi = (*kalman_model).Pose.Rot[1];
	const GEN_FLT obj_qj = (*kalman_model).Pose.Rot[2];
	const GEN_FLT obj_qk = (*kalman_model).Pose.Rot[3];
	const GEN_FLT vx = (*kalman_model).Velocity.Pos[0];
	const GEN_FLT vy = (*kalman_model).Velocity.Pos[1];
	const GEN_FLT vz = (*kalman_model).Velocity.Pos[2];
	const GEN_FLT avx = (*kalman_model).Velocity.AxisAngleRot[0];
	const GEN_FLT avy = (*kalman_model).Velocity.AxisAngleRot[1];
	const GEN_FLT avz = (*kalman_model).Velocity.AxisAngleRot[2];
	const GEN_FLT acc_x = (*kalman_model).Acc[0];
	const GEN_FLT acc_y = (*kalman_model).Acc[1];
	const GEN_FLT acc_z = (*kalman_model).Acc[2];
	const GEN_FLT acc_scale = (*kalman_model).AccScale;
	const GEN_FLT imu_w = (*kalman_model).IMUCorrection[0];
	const GEN_FLT imu_x = (*kalman_model).IMUCorrection[1];
	const GEN_FLT imu_y = (*kalman_model).IMUCorrection[2];
	const GEN_FLT imu_z = (*kalman_model).IMUCorrection[3];
	const GEN_FLT acc_biasx = (*kalman_model).AccBias[0];
	const GEN_FLT acc_biasy = (*kalman_model).AccBias[1];
	const GEN_FLT acc_biasz = (*kalman_model).AccBias[2];
	const GEN_FLT gbx = (*kalman_model).GyroBias[0];
	const GEN_FLT gby = (*kalman_model).GyroBias[1];
	const GEN_FLT gbz = (*kalman_model).GyroBias[2];
	const GEN_FLT x0 = obj_qw * obj_qw;
	const GEN_FLT x1 = obj_qk * obj_qk;
	const GEN_FLT x2 = obj_qj * obj_qj;
	const GEN_FLT x3 = obj_qi * obj_qi;
	const GEN_FLT x4 = 1e-11 + x2 + x3 + x0 + x1;
	const GEN_FLT x5 = 1. / sqrt(x4);
	const GEN_FLT x6 = imu_z * imu_z;
	const GEN_FLT x7 = imu_y * imu_y;
	const GEN_FLT x8 = imu_w * imu_w;
	const GEN_FLT x9 = imu_x * imu_x;
	const GEN_FLT x10 = 1e-11 + x8 + x9 + x6 + x7;
	const GEN_FLT x11 = 1. / sqrt(x10);
	const GEN_FLT x12 = x5 * x11;
	const GEN_FLT x13 = x12 * imu_z;
	const GEN_FLT x14 = (1. / (x4 * sqrt(x4))) * x11;
	const GEN_FLT x15 = x14 * imu_z;
	const GEN_FLT x16 = x14 * imu_y;
	const GEN_FLT x17 = x16 * obj_qw;
	const GEN_FLT x18 = x17 * obj_qi;
	const GEN_FLT x19 = x14 * imu_x;
	const GEN_FLT x20 = obj_qw * obj_qj;
	const GEN_FLT x21 = -1 * x20 * x19;
	const GEN_FLT x22 = x14 * imu_w;
	const GEN_FLT x23 = x22 * obj_qk;
	const GEN_FLT x24 = x23 * obj_qw;
	const GEN_FLT x25 = x24 + x21 + x13 + x18 + (-1 * x0 * x15);
	const GEN_FLT x26 = x12 * imu_x;
	const GEN_FLT x27 = x26 * obj_qj;
	const GEN_FLT x28 = x12 * imu_w;
	const GEN_FLT x29 = x28 * obj_qk;
	const GEN_FLT x30 = x13 * obj_qw;
	const GEN_FLT x31 = x12 * imu_y;
	const GEN_FLT x32 = x31 * obj_qi;
	const GEN_FLT x33 = (-1 * x32) + x30 + x27 + (-1 * x29);
	const GEN_FLT x34 = (x26 * obj_qi) + (x28 * obj_qw) + (x13 * obj_qk) + (x31 * obj_qj);
	const GEN_FLT x35 = x31 * obj_qk;
	const GEN_FLT x36 = x13 * obj_qj;
	const GEN_FLT x37 = x26 * obj_qw;
	const GEN_FLT x38 = x28 * obj_qi;
	const GEN_FLT x39 = (-1 * x38) + x37 + x35 + (-1 * x36);
	const GEN_FLT x40 = 2 * ((-1 * x39 * avz) + (x33 * avx) + (x34 * avy));
	const GEN_FLT x41 = obj_qw * obj_qi;
	const GEN_FLT x42 = x41 * x22;
	const GEN_FLT x43 = -1 * x17 * obj_qk;
	const GEN_FLT x44 = x20 * x15;
	const GEN_FLT x45 = x44 + x43 + (-1 * x0 * x19) + x42 + x26;
	const GEN_FLT x46 = -1 * x41 * x19;
	const GEN_FLT x47 = x15 * obj_qk;
	const GEN_FLT x48 = -1 * x47 * obj_qw;
	const GEN_FLT x49 = -1 * x17 * obj_qj;
	const GEN_FLT x50 = x48 + x46 + x49 + x28 + (-1 * x0 * x22);
	const GEN_FLT x51 = (x50 * avy) + (-1 * x45 * avz) + (x25 * avx);
	const GEN_FLT x52 = 2 * x33;
	const GEN_FLT x53 = x22 * obj_qj;
	const GEN_FLT x54 = x53 * obj_qw;
	const GEN_FLT x55 = x19 * obj_qk;
	const GEN_FLT x56 = x55 * obj_qw;
	const GEN_FLT x57 = -1 * x41 * x15;
	const GEN_FLT x58 = x31 + x57 + (-1 * x0 * x16) + x54 + x56;
	const GEN_FLT x59 = x31 * obj_qw;
	const GEN_FLT x60 = x26 * obj_qk;
	const GEN_FLT x61 = x28 * obj_qj;
	const GEN_FLT x62 = x13 * obj_qi;
	const GEN_FLT x63 = x62 + x59 + (-1 * x61) + (-1 * x60);
	const GEN_FLT x64 = 2 * ((-1 * x63 * avx) + (x34 * avz) + (x39 * avy));
	const GEN_FLT x65 = (x45 * avy) + (-1 * x58 * avx) + (x50 * avz);
	const GEN_FLT x66 = 2 * x63;
	const GEN_FLT x67 = obj_qj * obj_qi;
	const GEN_FLT x68 = -1 * x67 * x19;
	const GEN_FLT x69 = x23 * obj_qi;
	const GEN_FLT x70 = x69 + x68 + x57 + (-1 * x31) + (x3 * x16);
	const GEN_FLT x71 = -1 * x28;
	const GEN_FLT x72 = x16 * obj_qk;
	const GEN_FLT x73 = x72 * obj_qi;
	const GEN_FLT x74 = x67 * x15;
	const GEN_FLT x75 = (-1 * x73) + x74 + x46 + x71 + (x3 * x22);
	const GEN_FLT x76 = -1 * x47 * obj_qi;
	const GEN_FLT x77 = x67 * x16;
	const GEN_FLT x78 = x76 + (-1 * x42) + x26 + (-1 * x77) + (-1 * x3 * x19);
	const GEN_FLT x79 = (x78 * avy) + (-1 * x75 * avz) + (x70 * avx);
	const GEN_FLT x80 = x53 * obj_qi;
	const GEN_FLT x81 = x55 * obj_qi;
	const GEN_FLT x82 = x81 + (-1 * x18) + x80 + x13 + (-1 * x3 * x15);
	const GEN_FLT x83 = (x75 * avy) + (-1 * x82 * avx) + (x78 * avz);
	const GEN_FLT x84 = x23 * obj_qj;
	const GEN_FLT x85 = x26 + x84 + (-1 * x2 * x19) + x77 + (-1 * x44);
	const GEN_FLT x86 = -1 * x72 * obj_qj;
	const GEN_FLT x87 = (x2 * x15) + x21 + x80 + x86 + (-1 * x13);
	const GEN_FLT x88 = x47 * obj_qj;
	const GEN_FLT x89 = x68 + (-1 * x88) + (-1 * x54) + (-1 * x2 * x16) + x31;
	const GEN_FLT x90 = (x89 * avy) + (-1 * x87 * avz) + (x85 * avx);
	const GEN_FLT x91 = x55 * obj_qj;
	const GEN_FLT x92 = x91 + x49 + (x2 * x22) + (-1 * x74) + x71;
	const GEN_FLT x93 = (x87 * avy) + (x89 * avz) + (-1 * x92 * avx);
	const GEN_FLT x94 = (x1 * x22) + (-1 * x91) + x48 + x73 + x71;
	const GEN_FLT x95 = x31 + x88 + (-1 * x1 * x16) + (-1 * x56) + x69;
	const GEN_FLT x96 = (-1 * x24) + (-1 * x1 * x15) + (-1 * x81) + x13 + x86;
	const GEN_FLT x97 = (x96 * avy) + (-1 * x95 * avz) + (x94 * avx);
	const GEN_FLT x98 = x43 + x76 + (x1 * x19) + (-1 * x26) + x84;
	const GEN_FLT x99 = (x95 * avy) + (-1 * x98 * avx) + (x96 * avz);
	const GEN_FLT x100 = (-1 * x62) + (-1 * x59) + x61 + x60;
	const GEN_FLT x101 = x52 * x34;
	const GEN_FLT x102 = 2 * x39;
	const GEN_FLT x103 = (-1 * x37) + x38 + x36 + (-1 * x35);
	const GEN_FLT x104 = x66 * x34;
	const GEN_FLT x105 = x5 * (1. / (x10 * sqrt(x10)));
	const GEN_FLT x106 = x105 * obj_qw;
	const GEN_FLT x107 = imu_w * imu_z;
	const GEN_FLT x108 = -1 * x107 * x106;
	const GEN_FLT x109 = x12 * obj_qk;
	const GEN_FLT x110 = -1 * x109;
	const GEN_FLT x111 = x105 * obj_qj;
	const GEN_FLT x112 = imu_w * imu_x;
	const GEN_FLT x113 = x111 * x112;
	const GEN_FLT x114 = x105 * obj_qi;
	const GEN_FLT x115 = imu_w * imu_y;
	const GEN_FLT x116 = x114 * x115;
	const GEN_FLT x117 = x8 * x105;
	const GEN_FLT x118 = (-1 * x113) + (x117 * obj_qk) + x108 + x116 + x110;
	const GEN_FLT x119 = x12 * obj_qi;
	const GEN_FLT x120 = -1 * x119;
	const GEN_FLT x121 = -1 * x106 * x112;
	const GEN_FLT x122 = x105 * obj_qk;
	const GEN_FLT x123 = x115 * x122;
	const GEN_FLT x124 = x107 * x111;
	const GEN_FLT x125 = x124 + x121 + (-1 * x123) + x120 + (x117 * obj_qi);
	const GEN_FLT x126 = x12 * obj_qw;
	const GEN_FLT x127 = x112 * x114;
	const GEN_FLT x128 = x107 * x122;
	const GEN_FLT x129 = x111 * x115;
	const GEN_FLT x130 = (-1 * x127) + (-1 * x129) + x126 + (-1 * x128) + (-1 * x117 * obj_qw);
	const GEN_FLT x131 = (avy * x130) + (-1 * avz * x125) + (avx * x118);
	const GEN_FLT x132 = x107 * x114;
	const GEN_FLT x133 = x12 * obj_qj;
	const GEN_FLT x134 = -1 * x133;
	const GEN_FLT x135 = -1 * x106 * x115;
	const GEN_FLT x136 = x112 * x122;
	const GEN_FLT x137 = x135 + (x8 * x111) + x136 + (-1 * x132) + x134;
	const GEN_FLT x138 = (avy * x125) + (-1 * avx * x137) + (avz * x130);
	const GEN_FLT x139 = imu_x * imu_y;
	const GEN_FLT x140 = x114 * x139;
	const GEN_FLT x141 = imu_x * imu_z;
	const GEN_FLT x142 = -1 * x106 * x141;
	const GEN_FLT x143 = x133 + x142 + x140 + (-1 * x9 * x111) + x136;
	const GEN_FLT x144 = -1 * x114 * x141;
	const GEN_FLT x145 = -1 * x106 * x139;
	const GEN_FLT x146 = x9 * x105;
	const GEN_FLT x147 = (x146 * obj_qk) + x145 + x110 + x144 + x113;
	const GEN_FLT x148 = x122 * x141;
	const GEN_FLT x149 = -1 * x111 * x139;
	const GEN_FLT x150 = x149 + x119 + (-1 * x148) + (-1 * x146 * obj_qi) + x121;
	const GEN_FLT x151 = x122 * x139;
	const GEN_FLT x152 = x111 * x141;
	const GEN_FLT x153 = (-1 * x151) + x127 + x152 + x126 + (-1 * x146 * obj_qw);
	const GEN_FLT x154 = (avy * x153) + (-1 * avx * x147) + (avz * x150);
	const GEN_FLT x155 = (avy * x150) + (-1 * avz * x153) + (avx * x143);
	const GEN_FLT x156 = x7 * x105;
	const GEN_FLT x157 = imu_y * imu_z;
	const GEN_FLT x158 = -1 * x106 * x157;
	const GEN_FLT x159 = x149 + x123 + x120 + (x156 * obj_qi) + x158;
	const GEN_FLT x160 = x114 * x157;
	const GEN_FLT x161 = (-1 * x160) + x126 + (-1 * x156 * obj_qw) + x129 + x151;
	const GEN_FLT x162 = -1 * x122 * x157;
	const GEN_FLT x163 = x162 + (-1 * x140) + x135 + (-1 * x7 * x111) + x133;
	const GEN_FLT x164 = x111 * x157;
	const GEN_FLT x165 = (-1 * x156 * obj_qk) + x164 + x109 + x116 + x145;
	const GEN_FLT x166 = (avy * x165) + (-1 * avx * x161) + (avz * x163);
	const GEN_FLT x167 = (avy * x163) + (-1 * avz * x165) + (avx * x159);
	const GEN_FLT x168 = x6 * x105;
	const GEN_FLT x169 = (-1 * x168 * obj_qw) + (-1 * x152) + x126 + x128 + x160;
	const GEN_FLT x170 = x134 + x162 + x132 + (x6 * x111) + x142;
	const GEN_FLT x171 = x109 + (-1 * x168 * obj_qk) + (-1 * x164) + x144 + x108;
	const GEN_FLT x172 = (avy * x171) + (avx * x169) + (-1 * avz * x170);
	const GEN_FLT x173 = (-1 * x168 * obj_qi) + x148 + x158 + x119 + x124;
	const GEN_FLT x174 = (avz * x171) + (avy * x170) + (-1 * avx * x173);
	const GEN_FLT x175 = 2 * ((-1 * x33 * avy) + (x34 * avx) + (x63 * avz));
	const GEN_FLT x176 = (x58 * avz) + (-1 * x25 * avy) + (x50 * avx);
	const GEN_FLT x177 = (x82 * avz) + (-1 * x70 * avy) + (x78 * avx);
	const GEN_FLT x178 = (x92 * avz) + (-1 * x85 * avy) + (x89 * avx);
	const GEN_FLT x179 = (x98 * avz) + (-1 * x94 * avy) + (x96 * avx);
	const GEN_FLT x180 = x32 + x29 + (-1 * x27) + (-1 * x30);
	const GEN_FLT x181 = x34 * x102;
	const GEN_FLT x182 = (avz * x137) + (-1 * avy * x118) + (avx * x130);
	const GEN_FLT x183 = (avz * x147) + (-1 * avy * x143) + (avx * x150);
	const GEN_FLT x184 = (avz * x161) + (-1 * avy * x159) + (avx * x163);
	const GEN_FLT x185 = (avz * x173) + (-1 * avy * x169) + (avx * x171);
	out[0] = 0;
	out[1] = 0;
	out[2] = 0;
	out[3] = (x65 * x66) + (x64 * x58) + (-1 * x40 * x25) + (-1 * x52 * x51);
	out[4] = (x83 * x66) + (x82 * x64) + (-1 * x70 * x40) + (-1 * x79 * x52);
	out[5] = (x66 * x93) + (x64 * x92) + (-1 * x85 * x40) + (-1 * x52 * x90);
	out[6] = (x66 * x99) + (x64 * x98) + (-1 * x94 * x40) + (-1 * x52 * x97);
	out[7] = 0;
	out[8] = 0;
	out[9] = 0;
	out[10] = 1 + (x66 * x100) + (-2 * (x33 * x33));
	out[11] = (x63 * x102) + (-1 * x101);
	out[12] = x104 + (-1 * x52 * x103);
	out[13] = 0;
	out[14] = 0;
	out[15] = 0;
	out[16] = 0;
	out[17] = (x66 * x138) + (x64 * x137) + (-1 * x40 * x118) + (-1 * x52 * x131);
	out[18] = (-1 * x52 * x155) + (-1 * x40 * x143) + (x66 * x154) + (x64 * x147);
	out[19] = (-1 * x52 * x167) + (-1 * x40 * x159) + (x64 * x161) + (x66 * x166);
	out[20] = (x64 * x173) + (-1 * x52 * x172) + (x66 * x174) + (-1 * x40 * x169);
	out[21] = 0;
	out[22] = 0;
	out[23] = 0;
	out[24] = 1;
	out[25] = 0;
	out[26] = 0;
	out[27] = 0;
	out[28] = 0;
	out[29] = 0;
	out[30] = (x52 * x176) + (x25 * x175) + (-1 * x64 * x45) + (-1 * x65 * x102);
	out[31] = (x70 * x175) + (-1 * x83 * x102) + (-1 * x75 * x64) + (x52 * x177);
	out[32] = (-1 * x93 * x102) + (-1 * x87 * x64) + (x52 * x178) + (x85 * x175);
	out[33] = (x52 * x179) + (x94 * x175) + (-1 * x64 * x95) + (-1 * x99 * x102);
	out[34] = 0;
	out[35] = 0;
	out[36] = 0;
	out[37] = x101 + (-1 * x100 * x102);
	out[38] = 1 + (x52 * x180) + (-2 * (x39 * x39));
	out[39] = (x63 * x52) + (-1 * x181);
	out[40] = 0;
	out[41] = 0;
	out[42] = 0;
	out[43] = 0;
	out[44] = (-1 * x102 * x138) + (x118 * x175) + (-1 * x64 * x125) + (x52 * x182);
	out[45] = (x52 * x183) + (x175 * x143) + (-1 * x64 * x153) + (-1 * x102 * x154);
	out[46] = (x175 * x159) + (-1 * x64 * x165) + (x52 * x184) + (-1 * x102 * x166);
	out[47] = (x52 * x185) + (-1 * x102 * x174) + (-1 * x64 * x170) + (x169 * x175);
	out[48] = 0;
	out[49] = 0;
	out[50] = 0;
	out[51] = 0;
	out[52] = 1;
	out[53] = 0;
	out[54] = 0;
	out[55] = 0;
	out[56] = 0;
	out[57] = (x40 * x45) + (x51 * x102) + (-1 * x66 * x176) + (-1 * x58 * x175);
	out[58] = (-1 * x66 * x177) + (x75 * x40) + (-1 * x82 * x175) + (x79 * x102);
	out[59] = (x87 * x40) + (-1 * x92 * x175) + (x90 * x102) + (-1 * x66 * x178);
	out[60] = (-1 * x98 * x175) + (-1 * x66 * x179) + (x95 * x40) + (x97 * x102);
	out[61] = 0;
	out[62] = 0;
	out[63] = 0;
	out[64] = (x33 * x102) + (-1 * x104);
	out[65] = x181 + (-1 * x66 * x180);
	out[66] = 1 + (x103 * x102) + (-2 * (x63 * x63));
	out[67] = 0;
	out[68] = 0;
	out[69] = 0;
	out[70] = 0;
	out[71] = (x102 * x131) + (x40 * x125) + (-1 * x175 * x137) + (-1 * x66 * x182);
	out[72] = (x102 * x155) + (x40 * x153) + (-1 * x175 * x147) + (-1 * x66 * x183);
	out[73] = (x102 * x167) + (x40 * x165) + (-1 * x161 * x175) + (-1 * x66 * x184);
	out[74] = (x102 * x172) + (x40 * x170) + (-1 * x175 * x173) + (-1 * x66 * x185);
	out[75] = 0;
	out[76] = 0;
	out[77] = 0;
	out[78] = 0;
	out[79] = 0;
	out[80] = 1;
}

static inline void gen_quatfind(FLT* out, const FLT* q1, const FLT* q2) {
	const GEN_FLT obj_qw = q1[0];
	const GEN_FLT obj_qi = q1[1];
	const GEN_FLT obj_qj = q1[2];
	const GEN_FLT obj_qk = q1[3];
	const GEN_FLT q1_w = q2[0];
	const GEN_FLT q1_x = q2[1];
	const GEN_FLT q1_y = q2[2];
	const GEN_FLT q1_z = q2[3];

	out[0] = (q1_x * obj_qi) + (q1_w * obj_qw) + (q1_z * obj_qk) + (q1_y * obj_qj);
	out[1] = (q1_x * obj_qw) + (-1 * q1_y * obj_qk) + (q1_z * obj_qj) + (-1 * q1_w * obj_qi);
	out[2] = (q1_x * obj_qk) + (-1 * q1_z * obj_qi) + (-1 * q1_w * obj_qj) + (q1_y * obj_qw);
	out[3] = (-1 * q1_x * obj_qj) + (-1 * q1_w * obj_qk) + (q1_z * obj_qw) + (q1_y * obj_qi);
}

// Jacobian of quatfind wrt [obj_qw, obj_qi, obj_qj, obj_qk]
static inline void gen_quatfind_jac_q1(FLT* out, const FLT* q1, const FLT* q2) {
	const GEN_FLT obj_qw = q1[0];
	const GEN_FLT obj_qi = q1[1];
	const GEN_FLT obj_qj = q1[2];
	const GEN_FLT obj_qk = q1[3];
	const GEN_FLT q1_w = q2[0];
	const GEN_FLT q1_x = q2[1];
	const GEN_FLT q1_y = q2[2];
	const GEN_FLT q1_z = q2[3];
	const GEN_FLT x0 = -1 * q1_w;
	out[0] = q1_w;
	out[1] = q1_x;
	out[2] = q1_y;
	out[3] = q1_z;
	out[4] = q1_x;
	out[5] = x0;
	out[6] = q1_z;
	out[7] = -1 * q1_y;
	out[8] = q1_y;
	out[9] = -1 * q1_z;
	out[10] = x0;
	out[11] = q1_x;
	out[12] = q1_z;
	out[13] = q1_y;
	out[14] = -1 * q1_x;
	out[15] = x0;
}

// Jacobian of quatfind wrt [q1_w, q1_x, q1_y, q1_z]
static inline void gen_quatfind_jac_q2(FLT* out, const FLT* q1, const FLT* q2) {
	const GEN_FLT obj_qw = q1[0];
	const GEN_FLT obj_qi = q1[1];
	const GEN_FLT obj_qj = q1[2];
	const GEN_FLT obj_qk = q1[3];
	const GEN_FLT q1_w = q2[0];
	const GEN_FLT q1_x = q2[1];
	const GEN_FLT q1_y = q2[2];
	const GEN_FLT q1_z = q2[3];
	const GEN_FLT x0 = -1 * obj_qi;
	const GEN_FLT x1 = -1 * obj_qk;
	const GEN_FLT x2 = -1 * obj_qj;
	out[0] = obj_qw;
	out[1] = obj_qi;
	out[2] = obj_qj;
	out[3] = obj_qk;
	out[4] = x0;
	out[5] = obj_qw;
	out[6] = x1;
	out[7] = obj_qj;
	out[8] = x2;
	out[9] = obj_qk;
	out[10] = obj_qw;
	out[11] = x0;
	out[12] = x1;
	out[13] = x2;
	out[14] = obj_qi;
	out[15] = obj_qw;
}

static inline void gen_quatrotate_small(FLT* out, const FLT* q, const FLT* axis_angle) {
	const GEN_FLT obj_qw = q[0];
	const GEN_FLT obj_qi = q[1];
	const GEN_FLT obj_qj = q[2];
	const GEN_FLT obj_qk = q[3];
	const GEN_FLT aa_x = axis_angle[0];
	const GEN_FLT aa_y = axis_angle[1];
	const GEN_FLT aa_z = axis_angle[2];
	const GEN_FLT x0 = 1.0/2.0 * aa_z;
	const GEN_FLT x1 = 1.0/2.0 * aa_y;
	const GEN_FLT x2 = 1.0/2.0 * aa_x;
	out[0] = (-1 * x2 * obj_qi) + obj_qw + (-1 * x0 * obj_qk) + (-1 * x1 * obj_qj);
	out[1] = obj_qi + (x2 * obj_qw) + (-1 * x1 * obj_qk) + (x0 * obj_qj);
	out[2] = (x1 * obj_qw) + (-1 * x0 * obj_qi) + (x2 * obj_qk) + obj_qj;
	out[3] = (x1 * obj_qi) + (x0 * obj_qw) + (-1 * x2 * obj_qj) + obj_qk;
}

// Jacobian of quatrotate_small wrt [obj_qw, obj_qi, obj_qj, obj_qk]
static inline void gen_quatrotate_small_jac_q(FLT* out, const FLT* q, const FLT* axis_angle) {
	const GEN_FLT obj_qw = q[0];
	const GEN_FLT obj_qi = q[1];
	const GEN_FLT obj_qj = q[2];
	const GEN_FLT obj_qk = q[3];
	const GEN_FLT aa_x = axis_angle[0];
	const GEN_FLT aa_y = axis_angle[1];
	const GEN_FLT aa_z = axis_angle[2];
	const GEN_FLT x0 = 1.0/2.0 * aa_x;
	const GEN_FLT x1 = -1 * x0;
	const GEN_FLT x2 = 1.0/2.0 * aa_y;
	const GEN_FLT x3 = -1 * x2;
	const GEN_FLT x4 = 1.0/2.0 * aa_z;
	const GEN_FLT x5 = -1 * x4;
	out[0] = 1;
	out[1] = x1;
	out[2] = x3;
	out[3] = x5;
	out[4] = x0;
	out[5] = 1;
	out[6] = x4;
	out[7] = x3;
	out[8] = x2;
	out[9] = x5;
	out[10] = 1;
	out[11] = x0;
	out[12] = x4;
	out[13] = x2;
	out[14] = x1;
	out[15] = 1;
}

// Jacobian of quatrotate_small wrt [aa_x, aa_y, aa_z]
static inline void gen_quatrotate_small_jac_axis_angle(FLT* out, const FLT* q, const FLT* axis_angle) {
	const GEN_FLT obj_qw = q[0];
	const GEN_FLT obj_qi = q[1];
	const GEN_FLT obj_qj = q[2];
	const GEN_FLT obj_qk = q[3];
	const GEN_FLT aa_x = axis_angle[0];
	const GEN_FLT aa_y = axis_angle[1];
	const GEN_FLT aa_z = axis_angle[2];
	const GEN_FLT x0 = 1.0/2.0 * obj_qi;
	const GEN_FLT x1 = -1 * x0;
	const GEN_FLT x2 = 1.0/2.0 * obj_qj;
	const GEN_FLT x3 = -1 * x2;
	const GEN_FLT x4 = 1.0/2.0 * obj_qk;
	const GEN_FLT x5 = -1 * x4;
	const GEN_FLT x6 = 1.0/2.0 * obj_qw;
	out[0] = x1;
	out[1] = x3;
	out[2] = x5;
	out[3] = x6;
	out[4] = x5;
	out[5] = x2;
	out[6] = x4;
	out[7] = x6;
	out[8] = x1;
	out[9] = x3;
	out[10] = x0;
	out[11] = x6;
}

