
/*
Add contents of data.js here:
 */

const data = {
	"turbo" : {
		"interpolate" : true,
		"colors" : [
			[ 0.19, 0.0718, 0.2322 ],	[ 0.1948, 0.0834, 0.2615 ], [ 0.1996, 0.095, 0.2902 ],
			[ 0.2042, 0.1065, 0.3184 ], [ 0.2086, 0.118, 0.3461 ],	[ 0.2129, 0.1295, 0.3731 ],
			[ 0.2171, 0.1409, 0.3996 ], [ 0.2211, 0.1522, 0.4256 ], [ 0.225, 0.1635, 0.451 ],
			[ 0.2288, 0.1748, 0.4758 ], [ 0.2324, 0.186, 0.5 ],		[ 0.2358, 0.1972, 0.5237 ],
			[ 0.2392, 0.2083, 0.5469 ], [ 0.2423, 0.2194, 0.5694 ], [ 0.2454, 0.2304, 0.5914 ],
			[ 0.2483, 0.2414, 0.6129 ], [ 0.2511, 0.2524, 0.6337 ], [ 0.2537, 0.2633, 0.6541 ],
			[ 0.2562, 0.2741, 0.6738 ], [ 0.2585, 0.2849, 0.693 ],	[ 0.2607, 0.2957, 0.7116 ],
			[ 0.2628, 0.3064, 0.7297 ], [ 0.2647, 0.3171, 0.7472 ], [ 0.2665, 0.3277, 0.7641 ],
			[ 0.2682, 0.3382, 0.7805 ], [ 0.2697, 0.3488, 0.7963 ], [ 0.271, 0.3593, 0.8116 ],
			[ 0.2723, 0.3697, 0.8262 ], [ 0.2733, 0.3801, 0.8404 ], [ 0.2743, 0.3904, 0.8539 ],
			[ 0.2751, 0.4007, 0.8669 ], [ 0.2758, 0.411, 0.8794 ],	[ 0.2763, 0.4212, 0.8912 ],
			[ 0.2767, 0.4313, 0.9025 ], [ 0.2769, 0.4414, 0.9133 ], [ 0.277, 0.4515, 0.9235 ],
			[ 0.277, 0.4615, 0.9331 ],	[ 0.2768, 0.4715, 0.9421 ], [ 0.2765, 0.4814, 0.9506 ],
			[ 0.276, 0.4913, 0.9586 ],	[ 0.2754, 0.5012, 0.9659 ], [ 0.2747, 0.5109, 0.9728 ],
			[ 0.2738, 0.5207, 0.979 ],	[ 0.2727, 0.5304, 0.9846 ], [ 0.2711, 0.5402, 0.9893 ],
			[ 0.2688, 0.55, 0.993 ],	[ 0.2659, 0.5598, 0.9958 ], [ 0.2625, 0.5697, 0.9977 ],
			[ 0.2586, 0.5796, 0.9988 ], [ 0.2542, 0.5895, 0.999 ],	[ 0.2495, 0.5994, 0.9984 ],
			[ 0.2443, 0.6094, 0.997 ],	[ 0.2387, 0.6193, 0.9948 ], [ 0.2329, 0.6292, 0.992 ],
			[ 0.2268, 0.6391, 0.9885 ], [ 0.2204, 0.649, 0.9844 ],	[ 0.2138, 0.6589, 0.9796 ],
			[ 0.2071, 0.6687, 0.9742 ], [ 0.2002, 0.6784, 0.9683 ], [ 0.1933, 0.6881, 0.9619 ],
			[ 0.1862, 0.6978, 0.955 ],	[ 0.1792, 0.7073, 0.9476 ], [ 0.1722, 0.7168, 0.9398 ],
			[ 0.1653, 0.7262, 0.9316 ], [ 0.1584, 0.7355, 0.923 ],	[ 0.1517, 0.7447, 0.9142 ],
			[ 0.1452, 0.7538, 0.905 ],	[ 0.1389, 0.7628, 0.8955 ], [ 0.1328, 0.7716, 0.8858 ],
			[ 0.127, 0.7804, 0.8759 ],	[ 0.1215, 0.789, 0.8658 ],	[ 0.1164, 0.7974, 0.8556 ],
			[ 0.1117, 0.8057, 0.8452 ], [ 0.1074, 0.8138, 0.8348 ], [ 0.1036, 0.8218, 0.8244 ],
			[ 0.1003, 0.8296, 0.8139 ], [ 0.0975, 0.8371, 0.8034 ], [ 0.0953, 0.8446, 0.793 ],
			[ 0.0938, 0.8518, 0.7826 ], [ 0.0929, 0.8588, 0.7724 ], [ 0.0927, 0.8655, 0.7623 ],
			[ 0.0932, 0.8721, 0.7524 ], [ 0.0945, 0.8784, 0.7426 ], [ 0.0966, 0.8845, 0.7332 ],
			[ 0.0996, 0.8904, 0.7239 ], [ 0.1034, 0.896, 0.715 ],	[ 0.1082, 0.9014, 0.706 ],
			[ 0.1137, 0.9067, 0.6965 ], [ 0.1201, 0.9119, 0.6866 ], [ 0.1273, 0.917, 0.6763 ],
			[ 0.1353, 0.922, 0.6656 ],	[ 0.1439, 0.9268, 0.6545 ], [ 0.1532, 0.9315, 0.6431 ],
			[ 0.1632, 0.9361, 0.6314 ], [ 0.1738, 0.9405, 0.6194 ], [ 0.1849, 0.9448, 0.6071 ],
			[ 0.1966, 0.949, 0.5947 ],	[ 0.2088, 0.953, 0.582 ],	[ 0.2214, 0.9569, 0.5691 ],
			[ 0.2345, 0.9606, 0.5561 ], [ 0.248, 0.9642, 0.543 ],	[ 0.2618, 0.9676, 0.5298 ],
			[ 0.276, 0.9709, 0.5165 ],	[ 0.2904, 0.974, 0.5032 ],	[ 0.3051, 0.977, 0.4899 ],
			[ 0.3201, 0.9797, 0.4765 ], [ 0.3352, 0.9823, 0.4632 ], [ 0.3504, 0.9848, 0.45 ],
			[ 0.3658, 0.987, 0.4369 ],	[ 0.3813, 0.9891, 0.4239 ], [ 0.3968, 0.991, 0.411 ],
			[ 0.4123, 0.9927, 0.3983 ], [ 0.4278, 0.9942, 0.3858 ], [ 0.4432, 0.9955, 0.3734 ],
			[ 0.4585, 0.9966, 0.3614 ], [ 0.4738, 0.9976, 0.3496 ], [ 0.4888, 0.9983, 0.3382 ],
			[ 0.5036, 0.9988, 0.327 ],	[ 0.5182, 0.9991, 0.3162 ], [ 0.5326, 0.9992, 0.3058 ],
			[ 0.5466, 0.9991, 0.2958 ], [ 0.5603, 0.9987, 0.2862 ], [ 0.5736, 0.9982, 0.2771 ],
			[ 0.5865, 0.9974, 0.2685 ], [ 0.5989, 0.9964, 0.2604 ], [ 0.6109, 0.9951, 0.2528 ],
			[ 0.6223, 0.9937, 0.2458 ], [ 0.6332, 0.992, 0.2394 ],	[ 0.6436, 0.99, 0.2336 ],
			[ 0.6539, 0.9878, 0.2284 ], [ 0.6643, 0.9852, 0.2237 ], [ 0.6746, 0.9825, 0.2196 ],
			[ 0.6849, 0.9794, 0.216 ],	[ 0.6952, 0.9761, 0.2129 ], [ 0.7055, 0.9726, 0.2103 ],
			[ 0.7158, 0.9688, 0.2082 ], [ 0.726, 0.9647, 0.2064 ],	[ 0.7361, 0.9604, 0.205 ],
			[ 0.7462, 0.9559, 0.2041 ], [ 0.7562, 0.9512, 0.2034 ], [ 0.7661, 0.9463, 0.2031 ],
			[ 0.7759, 0.9411, 0.2031 ], [ 0.7856, 0.9358, 0.2034 ], [ 0.7952, 0.9302, 0.2039 ],
			[ 0.8047, 0.9245, 0.2046 ], [ 0.8141, 0.9186, 0.2055 ], [ 0.8233, 0.9125, 0.2066 ],
			[ 0.8324, 0.9063, 0.2079 ], [ 0.8413, 0.8999, 0.2093 ], [ 0.8501, 0.8933, 0.2107 ],
			[ 0.8587, 0.8866, 0.2123 ], [ 0.8671, 0.8797, 0.2139 ], [ 0.8753, 0.8727, 0.2156 ],
			[ 0.8833, 0.8655, 0.2172 ], [ 0.8911, 0.8583, 0.2188 ], [ 0.8987, 0.8509, 0.2204 ],
			[ 0.906, 0.8434, 0.2219 ],	[ 0.9132, 0.8358, 0.2233 ], [ 0.92, 0.8281, 0.2246 ],
			[ 0.9267, 0.8202, 0.2257 ], [ 0.933, 0.8124, 0.2267 ],	[ 0.9391, 0.8044, 0.2274 ],
			[ 0.9449, 0.7963, 0.228 ],	[ 0.9504, 0.7882, 0.2283 ], [ 0.9556, 0.78, 0.2284 ],
			[ 0.9605, 0.7718, 0.2281 ], [ 0.9651, 0.7635, 0.2275 ], [ 0.9693, 0.7552, 0.2266 ],
			[ 0.9732, 0.7468, 0.2254 ], [ 0.9768, 0.7384, 0.2237 ], [ 0.98, 0.73, 0.2216 ],
			[ 0.9829, 0.7214, 0.2192 ], [ 0.9855, 0.7125, 0.2165 ], [ 0.9878, 0.7033, 0.2136 ],
			[ 0.9899, 0.6938, 0.2104 ], [ 0.9916, 0.6841, 0.2071 ], [ 0.9931, 0.6741, 0.2035 ],
			[ 0.9944, 0.6639, 0.1997 ], [ 0.9954, 0.6534, 0.1958 ], [ 0.9961, 0.6428, 0.1916 ],
			[ 0.9965, 0.6319, 0.1874 ], [ 0.9968, 0.6209, 0.183 ],	[ 0.9967, 0.6098, 0.1784 ],
			[ 0.9964, 0.5985, 0.1738 ], [ 0.9959, 0.587, 0.169 ],	[ 0.9952, 0.5755, 0.1641 ],
			[ 0.9942, 0.5639, 0.1592 ], [ 0.993, 0.5521, 0.1542 ],	[ 0.9915, 0.5404, 0.1491 ],
			[ 0.9899, 0.5285, 0.144 ],	[ 0.988, 0.5167, 0.1388 ],	[ 0.9859, 0.5048, 0.1337 ],
			[ 0.9836, 0.4929, 0.1285 ], [ 0.9811, 0.481, 0.1233 ],	[ 0.9784, 0.4692, 0.1182 ],
			[ 0.9754, 0.4574, 0.113 ],	[ 0.9723, 0.4456, 0.108 ],	[ 0.969, 0.434, 0.1029 ],
			[ 0.9656, 0.4224, 0.098 ],	[ 0.9619, 0.4109, 0.0931 ], [ 0.958, 0.3996, 0.0883 ],
			[ 0.954, 0.3884, 0.0836 ],	[ 0.9498, 0.3773, 0.079 ],	[ 0.9454, 0.3664, 0.0746 ],
			[ 0.9408, 0.3557, 0.0703 ], [ 0.9361, 0.3451, 0.0662 ], [ 0.9312, 0.3348, 0.0622 ],
			[ 0.9262, 0.3247, 0.0584 ], [ 0.921, 0.3149, 0.0548 ],	[ 0.9157, 0.3053, 0.0513 ],
			[ 0.9102, 0.296, 0.0481 ],	[ 0.9046, 0.287, 0.0452 ],	[ 0.8989, 0.2782, 0.0424 ],
			[ 0.893, 0.2698, 0.0399 ],	[ 0.8869, 0.2615, 0.0375 ], [ 0.8807, 0.2533, 0.0352 ],
			[ 0.8742, 0.2453, 0.033 ],	[ 0.8676, 0.2373, 0.0308 ], [ 0.8608, 0.2294, 0.0288 ],
			[ 0.8538, 0.2217, 0.0268 ], [ 0.8466, 0.2141, 0.0249 ], [ 0.8393, 0.2065, 0.023 ],
			[ 0.8317, 0.1991, 0.0213 ], [ 0.824, 0.1918, 0.0197 ],	[ 0.8161, 0.1846, 0.0181 ],
			[ 0.808, 0.1775, 0.0166 ],	[ 0.7997, 0.1706, 0.0152 ], [ 0.7912, 0.1637, 0.0139 ],
			[ 0.7826, 0.1569, 0.0126 ], [ 0.7738, 0.1503, 0.0115 ], [ 0.7648, 0.1437, 0.0104 ],
			[ 0.7556, 0.1373, 0.0094 ], [ 0.7462, 0.131, 0.0085 ],	[ 0.7366, 0.1248, 0.0077 ],
			[ 0.7269, 0.1187, 0.007 ],	[ 0.7169, 0.1127, 0.0063 ], [ 0.7068, 0.1068, 0.0057 ],
			[ 0.6965, 0.101, 0.0052 ],	[ 0.686, 0.0954, 0.0048 ],	[ 0.6754, 0.0898, 0.0045 ],
			[ 0.6645, 0.0844, 0.0042 ], [ 0.6534, 0.079, 0.0041 ],	[ 0.6422, 0.0738, 0.004 ],
			[ 0.6308, 0.0687, 0.004 ],	[ 0.6192, 0.0637, 0.0041 ], [ 0.6075, 0.0588, 0.0043 ],
			[ 0.5955, 0.054, 0.0045 ],	[ 0.5834, 0.0493, 0.0049 ], [ 0.571, 0.0447, 0.0053 ],
			[ 0.5585, 0.0403, 0.0058 ], [ 0.5458, 0.0359, 0.0064 ], [ 0.533, 0.0317, 0.007 ],
			[ 0.5199, 0.0276, 0.0078 ], [ 0.5066, 0.0235, 0.0086 ], [ 0.4932, 0.0196, 0.0096 ],
			[ 0.4796, 0.0158, 0.0106 ]
		]
	}
};

const Accent = partial('Accent');
const Accent_r = partial('Accent_r');
const Blues = partial('Blues');
const Blues_r = partial('Blues_r');
const BrBG = partial('BrBG');
const BrBG_r = partial('BrBG_r');
const BuGn = partial('BuGn');
const BuGn_r = partial('BuGn_r');
const BuPu = partial('BuPu');
const BuPu_r = partial('BuPu_r');
const CMRmap = partial('CMRmap');
const CMRmap_r = partial('CMRmap_r');
const Dark2 = partial('Dark2');
const Dark2_r = partial('Dark2_r');
const GnBu = partial('GnBu');
const GnBu_r = partial('GnBu_r');
const Greens = partial('Greens');
const Greens_r = partial('Greens_r');
const Greys = partial('Greys');
const Greys_r = partial('Greys_r');
const OrRd = partial('OrRd');
const OrRd_r = partial('OrRd_r');
const Oranges = partial('Oranges');
const Oranges_r = partial('Oranges_r');
const PRGn = partial('PRGn');
const PRGn_r = partial('PRGn_r');
const Paired = partial('Paired');
const Paired_r = partial('Paired_r');
const Pastel1 = partial('Pastel1');
const Pastel1_r = partial('Pastel1_r');
const Pastel2 = partial('Pastel2');
const Pastel2_r = partial('Pastel2_r');
const PiYG = partial('PiYG');
const PiYG_r = partial('PiYG_r');
const PuBu = partial('PuBu');
const PuBu_r = partial('PuBu_r');
const PuBuGn = partial('PuBuGn');
const PuBuGn_r = partial('PuBuGn_r');
const PuOr = partial('PuOr');
const PuOr_r = partial('PuOr_r');
const PuRd = partial('PuRd');
const PuRd_r = partial('PuRd_r');
const Purples = partial('Purples');
const Purples_r = partial('Purples_r');
const RdBu = partial('RdBu');
const RdBu_r = partial('RdBu_r');
const RdGy = partial('RdGy');
const RdGy_r = partial('RdGy_r');
const RdPu = partial('RdPu');
const RdPu_r = partial('RdPu_r');
const RdYlBu = partial('RdYlBu');
const RdYlBu_r = partial('RdYlBu_r');
const RdYlGn = partial('RdYlGn');
const RdYlGn_r = partial('RdYlGn_r');
const Reds = partial('Reds');
const Reds_r = partial('Reds_r');
const Set1 = partial('Set1');
const Set1_r = partial('Set1_r');
const Set2 = partial('Set2');
const Set2_r = partial('Set2_r');
const Set3 = partial('Set3');
const Set3_r = partial('Set3_r');
const Spectral = partial('Spectral');
const Spectral_r = partial('Spectral_r');
const Wistia = partial('Wistia');
const Wistia_r = partial('Wistia_r');
const YlGn = partial('YlGn');
const YlGn_r = partial('YlGn_r');
const YlGnBu = partial('YlGnBu');
const YlGnBu_r = partial('YlGnBu_r');
const YlOrBr = partial('YlOrBr');
const YlOrBr_r = partial('YlOrBr_r');
const YlOrRd = partial('YlOrRd');
const YlOrRd_r = partial('YlOrRd_r');
const afmhot = partial('afmhot');
const afmhot_r = partial('afmhot_r');
const autumn = partial('autumn');
const autumn_r = partial('autumn_r');
const binary = partial('binary');
const binary_r = partial('binary_r');
const bone = partial('bone');
const bone_r = partial('bone_r');
const brg = partial('brg');
const brg_r = partial('brg_r');
const bwr = partial('bwr');
const bwr_r = partial('bwr_r');
const cividis = partial('cividis');
const cividis_r = partial('cividis_r');
const cool = partial('cool');
const cool_r = partial('cool_r');
const coolwarm = partial('coolwarm');
const coolwarm_r = partial('coolwarm_r');
const copper = partial('copper');
const copper_r = partial('copper_r');
const cubehelix = partial('cubehelix');
const cubehelix_r = partial('cubehelix_r');
const flag = partial('flag');
const flag_r = partial('flag_r');
const gist_earth = partial('gist_earth');
const gist_earth_r = partial('gist_earth_r');
const gist_gray = partial('gist_gray');
const gist_gray_r = partial('gist_gray_r');
const gist_heat = partial('gist_heat');
const gist_heat_r = partial('gist_heat_r');
const gist_ncar = partial('gist_ncar');
const gist_ncar_r = partial('gist_ncar_r');
const gist_rainbow = partial('gist_rainbow');
const gist_rainbow_r = partial('gist_rainbow_r');
const gist_stern = partial('gist_stern');
const gist_stern_r = partial('gist_stern_r');
const gist_yarg = partial('gist_yarg');
const gist_yarg_r = partial('gist_yarg_r');
const gnuplot = partial('gnuplot');
const gnuplot_r = partial('gnuplot_r');
const gnuplot2 = partial('gnuplot2');
const gnuplot2_r = partial('gnuplot2_r');
const gray = partial('gray');
const gray_r = partial('gray_r');
const hot = partial('hot');
const hot_r = partial('hot_r');
const hsv = partial('hsv');
const hsv_r = partial('hsv_r');
const inferno = partial('inferno');
const inferno_r = partial('inferno_r');
const jet = partial('jet');
const jet_r = partial('jet_r');
const magma = partial('magma');
const magma_r = partial('magma_r');
const nipy_spectral = partial('nipy_spectral');
const nipy_spectral_r = partial('nipy_spectral_r');
const ocean = partial('ocean');
const ocean_r = partial('ocean_r');
const pink = partial('pink');
const pink_r = partial('pink_r');
const plasma = partial('plasma');
const plasma_r = partial('plasma_r');
const prism = partial('prism');
const prism_r = partial('prism_r');
const rainbow = partial('rainbow');
const rainbow_r = partial('rainbow_r');
const seismic = partial('seismic');
const seismic_r = partial('seismic_r');
const spring = partial('spring');
const spring_r = partial('spring_r');
const summer = partial('summer');
const summer_r = partial('summer_r');
const tab10 = partial('tab10');
const tab10_r = partial('tab10_r');
const tab20 = partial('tab20');
const tab20_r = partial('tab20_r');
const tab20b = partial('tab20b');
const tab20b_r = partial('tab20b_r');
const tab20c = partial('tab20c');
const tab20c_r = partial('tab20c_r');
const terrain = partial('terrain');
const terrain_r = partial('terrain_r');
const turbo = partial('turbo');
const turbo_r = partial('turbo_r');
const twilight = partial('twilight');
const twilight_r = partial('twilight_r');
const twilight_shifted = partial('twilight_shifted');
const twilight_shifted_r = partial('twilight_shifted_r');
const viridis = partial('viridis');
const viridis_r = partial('viridis_r');
const winter = partial('winter');
const winter_r = partial('winter_r');

/*
Define auxiliary functions for evaluating colormaps
 */

function evaluate_cmap(x, name, reverse) {
	/**
	 * Evaluate colormap `name` at some value `x`.
	 * @param {number} x - The value (between 0 and 1) at which to evaluate the colormap.
	 * @param {string} name - The name of the colormap (see matplotlib documentation).
	 * @reverse {boolean} reverse - Whether or not to reverse the colormap.
	 * @return {list} - A 3-tuple (R, G, B) containing the color assigned to `x`.
	 */

	// Ensure that the value of `x` is valid (i.e., 0 <= x <= 1)
	if (!(0 <= x <= 1)) {
		alert('Illegal value for x! Must be in [0, 1].')
	}

	// Ensure that `name` is a valid colormap
	if (!(name in data)) {
		alert('Colormap ' + name + 'does not exist!');
	}

	// We can get the reverse colormap by evaluating colormap(1-x)
	if (reverse === true) {
		x = 1 - x;
	}

	// Get the colors and whether or not we need to interpolate
	let colors = data[name]['colors'];
	let interpolate = data[name]['interpolate'];

	if (interpolate === true) {
		return interpolated(x, colors);
	} else {
		return qualitative(x, colors);
	}
}

function interpolated(x, colors) {
	let lo = Math.floor(x * (colors.length - 1));
	let hi = Math.ceil(x * (colors.length - 1));
	let r = Math.round((colors[lo][0] + colors[hi][0]) / 2 * 255);
	let g = Math.round((colors[lo][1] + colors[hi][1]) / 2 * 255);
	let b = Math.round((colors[lo][2] + colors[hi][2]) / 2 * 255);
	return [ r, g, b ];
}

function qualitative(x, colors) {
	let idx = 0;
	while (x > (idx + 1) / (colors.length - 0)) {
		idx++;
	}
	let r = Math.round(colors[idx][0] * 255);
	let g = Math.round(colors[idx][1] * 255);
	let b = Math.round(colors[idx][2] * 255);
	return [ r, g, b ];
}

function partial(name) {
	if (name.endsWith('_r')) {
		return function(x) { return evaluate_cmap(x, name.substring(0, name.length - 2), true) };
	} else {
		return function(x) { return evaluate_cmap(x, name, false) };
	}
}
